/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Collections;
import java.util.Set;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.SubscriptionType;
import org.assertj.core.util.Sets;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BrokerEntryMetadataE2ETest
extends BrokerTestBase {
    @DataProvider(name="subscriptionTypes")
    public static Object[] subscriptionTypes() {
        return new Object[]{SubscriptionType.Exclusive, SubscriptionType.Failover, SubscriptionType.Shared, SubscriptionType.Key_Shared};
    }

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        this.conf.setBrokerEntryMetadataInterceptors((Set)Sets.newTreeSet((Object[])new String[]{"org.apache.pulsar.common.intercept.AppendBrokerTimestampMetadataInterceptor", "org.apache.pulsar.common.intercept.AppendIndexMetadataInterceptor"}));
        this.baseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        this.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="subscriptionTypes")
    public void testProduceAndConsume(SubscriptionType subType) throws Exception {
        String topic = this.newTopicName();
        int messages = 10;
        Producer producer = this.pulsarClient.newProducer().topic(topic).create();
        try {
            Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionType(subType).subscriptionName("my-sub").subscribe();
            try {
                for (int i = 0; i < 10; ++i) {
                    producer.send((Object)String.valueOf(i).getBytes());
                }
                int receives = 0;
                for (int i = 0; i < 10; ++i) {
                    Message received = consumer.receive();
                    ++receives;
                    Assert.assertEquals((int)i, (int)Integer.valueOf(new String((byte[])received.getValue())));
                }
                Assert.assertEquals((int)10, (int)receives);
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }
}

