/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.ConsistentHashingStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Consumer;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ConsistentHashingStickyKeyConsumerSelectorTest {
    @Test
    public void testConsumerSelect() throws BrokerServiceException.ConsumerAssignException {
        int count;
        int i;
        ConsistentHashingStickyKeyConsumerSelector selector = new ConsistentHashingStickyKeyConsumerSelector(100);
        String key1 = "anyKey";
        Assert.assertNull((Object)selector.select(key1.getBytes()));
        Consumer consumer1 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)consumer1.consumerName()).thenReturn((Object)"c1");
        selector.addConsumer(consumer1);
        Assert.assertEquals((Object)selector.select(key1.getBytes()), (Object)consumer1);
        Consumer consumer2 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)consumer2.consumerName()).thenReturn((Object)"c2");
        selector.addConsumer(consumer2);
        int N = 1000;
        double PERCENT_ERROR = 0.2;
        HashMap<String, Integer> selectionMap = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < 1000; ++i2) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            int count2 = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count2 + 1);
        }
        Assert.assertEquals((double)((Integer)selectionMap.get("c1")).intValue(), (double)500.0, (double)100.0);
        Assert.assertEquals((double)((Integer)selectionMap.get("c2")).intValue(), (double)500.0, (double)100.0);
        selectionMap.clear();
        Consumer consumer3 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)consumer3.consumerName()).thenReturn((Object)"c3");
        selector.addConsumer(consumer3);
        for (int i3 = 0; i3 < 1000; ++i3) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            int count3 = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count3 + 1);
        }
        Assert.assertEquals((double)((Integer)selectionMap.get("c1")).intValue(), (double)333.0, (double)66.60000000000001);
        Assert.assertEquals((double)((Integer)selectionMap.get("c2")).intValue(), (double)333.0, (double)66.60000000000001);
        Assert.assertEquals((double)((Integer)selectionMap.get("c3")).intValue(), (double)333.0, (double)66.60000000000001);
        selectionMap.clear();
        Consumer consumer4 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)consumer4.consumerName()).thenReturn((Object)"c4");
        selector.addConsumer(consumer4);
        for (i = 0; i < 1000; ++i) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            count = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count + 1);
        }
        Assert.assertEquals((double)((Integer)selectionMap.get("c1")).intValue(), (double)250.0, (double)50.0);
        Assert.assertEquals((double)((Integer)selectionMap.get("c2")).intValue(), (double)250.0, (double)50.0);
        Assert.assertEquals((double)((Integer)selectionMap.get("c3")).intValue(), (double)250.0, (double)50.0);
        Assert.assertEquals((double)((Integer)selectionMap.get("c4")).intValue(), (double)250.0, (double)50.0);
        selectionMap.clear();
        selector.removeConsumer(consumer1);
        for (i = 0; i < 1000; ++i) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            count = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count + 1);
        }
        Assert.assertEquals((double)((Integer)selectionMap.get("c2")).intValue(), (double)333.0, (double)66.60000000000001);
        Assert.assertEquals((double)((Integer)selectionMap.get("c3")).intValue(), (double)333.0, (double)66.60000000000001);
        Assert.assertEquals((double)((Integer)selectionMap.get("c4")).intValue(), (double)333.0, (double)66.60000000000001);
        selectionMap.clear();
        selector.removeConsumer(consumer2);
        for (i = 0; i < 1000; ++i) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            count = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count + 1);
        }
        System.err.println(selectionMap);
        Assert.assertEquals((double)((Integer)selectionMap.get("c3")).intValue(), (double)500.0, (double)100.0);
        Assert.assertEquals((double)((Integer)selectionMap.get("c4")).intValue(), (double)500.0, (double)100.0);
        selectionMap.clear();
        selector.removeConsumer(consumer3);
        for (i = 0; i < 1000; ++i) {
            String key = UUID.randomUUID().toString();
            Consumer selectedConsumer = selector.select(key.getBytes());
            count = selectionMap.computeIfAbsent(selectedConsumer.consumerName(), c -> 0);
            selectionMap.put(selectedConsumer.consumerName(), count + 1);
        }
        Assert.assertEquals((int)((Integer)selectionMap.get("c4")), (int)1000);
    }

    @Test
    public void testGetConsumerKeyHashRanges() throws BrokerServiceException.ConsumerAssignException {
        ConsistentHashingStickyKeyConsumerSelector selector = new ConsistentHashingStickyKeyConsumerSelector(3);
        List<String> consumerName = Arrays.asList("consumer1", "consumer2", "consumer3");
        for (String s : consumerName) {
            Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
            Mockito.when((Object)consumer.consumerName()).thenReturn((Object)s);
            selector.addConsumer(consumer);
        }
        HashMap<String, ImmutableSet> expectedResult = new HashMap<String, ImmutableSet>();
        expectedResult.put("consumer1", ImmutableSet.of((Object)"[0, 330121749]", (Object)"[330121750, 618146114]", (Object)"[1797637922, 1976098885]"));
        expectedResult.put("consumer2", ImmutableSet.of((Object)"[938427576, 1094135919]", (Object)"[1138613629, 1342907082]", (Object)"[1342907083, 1797637921]"));
        expectedResult.put("consumer3", ImmutableSet.of((Object)"[618146115, 772640562]", (Object)"[772640563, 938427575]", (Object)"[1094135920, 1138613628]"));
        for (Map.Entry entry : selector.getConsumerKeyHashRanges().entrySet()) {
            Assert.assertEquals(new HashSet((Collection)entry.getValue()), (Set)((Set)expectedResult.get(entry.getKey())));
            expectedResult.remove(entry.getKey());
        }
        Assert.assertEquals((int)expectedResult.size(), (int)0);
    }
}

