/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.HashMap;
import org.apache.pulsar.broker.service.PrecisPublishLimiter;
import org.apache.pulsar.broker.service.PublishRateLimiterImpl;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class PublishRateLimiterTest {
    private final String CLUSTER_NAME = "clusterName";
    private final Policies policies = new Policies();
    private final PublishRate publishRate = new PublishRate(10, 100L);
    private final PublishRate newPublishRate = new PublishRate(20, 200L);
    private PrecisPublishLimiter precisPublishLimiter;
    private PublishRateLimiterImpl publishRateLimiter;

    @BeforeMethod
    public void setup() throws Exception {
        this.policies.publishMaxMessageRate = new HashMap();
        this.policies.publishMaxMessageRate.put("clusterName", this.publishRate);
        this.precisPublishLimiter = new PrecisPublishLimiter(this.policies, "clusterName", () -> System.out.print("Refresh permit"));
        this.publishRateLimiter = new PublishRateLimiterImpl(this.policies, "clusterName");
    }

    @Test
    public void testPublishRateLimiterImplExceed() throws Exception {
        this.publishRateLimiter.incrementPublishCount(5, 50L);
        this.publishRateLimiter.checkPublishRate();
        Assert.assertFalse((boolean)this.publishRateLimiter.isPublishRateExceeded());
        this.publishRateLimiter.resetPublishCount();
        this.publishRateLimiter.incrementPublishCount(11, 100L);
        this.publishRateLimiter.checkPublishRate();
        Assert.assertTrue((boolean)this.publishRateLimiter.isPublishRateExceeded());
        this.publishRateLimiter.resetPublishCount();
        this.publishRateLimiter.incrementPublishCount(9, 110L);
        this.publishRateLimiter.checkPublishRate();
        Assert.assertTrue((boolean)this.publishRateLimiter.isPublishRateExceeded());
    }

    @Test
    public void testPublishRateLimiterImplUpdate() {
        this.publishRateLimiter.incrementPublishCount(11, 110L);
        this.publishRateLimiter.checkPublishRate();
        Assert.assertTrue((boolean)this.publishRateLimiter.isPublishRateExceeded());
        this.publishRateLimiter.update(this.newPublishRate);
        this.publishRateLimiter.incrementPublishCount(11, 110L);
        this.publishRateLimiter.checkPublishRate();
        Assert.assertFalse((boolean)this.publishRateLimiter.isPublishRateExceeded());
    }

    @Test
    public void testPrecisePublishRateLimiterUpdate() {
        Assert.assertFalse((boolean)this.precisPublishLimiter.tryAcquire(15, 150L));
        this.precisPublishLimiter.update(this.newPublishRate);
        Assert.assertTrue((boolean)this.precisPublishLimiter.tryAcquire(15, 150L));
    }

    @Test
    public void testPrecisePublishRateLimiterAcquire() throws Exception {
        Assert.assertTrue((boolean)this.precisPublishLimiter.tryAcquire(1, 10L));
        Thread.sleep(1100L);
        Assert.assertFalse((boolean)this.precisPublishLimiter.tryAcquire(11, 100L));
        Thread.sleep(1100L);
        Assert.assertFalse((boolean)this.precisPublishLimiter.tryAcquire(10, 101L));
        Thread.sleep(1100L);
        Assert.assertTrue((boolean)this.precisPublishLimiter.tryAcquire(10, 100L));
    }
}

