/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Collections;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.api.proto.MarkersMessageIdData;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.Markers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionMarkerDeleteTest
extends BrokerTestBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testTransactionMarkerDelete() throws Exception {
        ManagedLedger managedLedger = this.pulsar.getManagedLedgerFactory().open("test");
        PersistentTopic topic = (PersistentTopic)Mockito.mock(PersistentTopic.class);
        BrokerService brokerService = (BrokerService)Mockito.mock(BrokerService.class);
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        ServiceConfiguration configuration = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        ((PersistentTopic)Mockito.doReturn((Object)brokerService).when((Object)topic)).getBrokerService();
        ((BrokerService)Mockito.doReturn((Object)pulsarService).when((Object)brokerService)).getPulsar();
        ((PulsarService)Mockito.doReturn((Object)configuration).when((Object)pulsarService)).getConfig();
        ((ServiceConfiguration)Mockito.doReturn((Object)true).when((Object)configuration)).isTransactionCoordinatorEnabled();
        ((PersistentTopic)Mockito.doReturn((Object)managedLedger).when((Object)topic)).getManagedLedger();
        ((PersistentTopic)Mockito.doReturn((Object)TopicName.TRANSACTION_COORDINATOR_ASSIGN.getLocalName()).when((Object)topic)).getName();
        ManagedCursor cursor = managedLedger.openCursor("test");
        PersistentSubscription persistentSubscription = new PersistentSubscription(topic, "test", managedLedger.openCursor("test"), false);
        MarkersMessageIdData messageIdData = new MarkersMessageIdData().setLedgerId(1L).setEntryId(1L);
        Position position1 = managedLedger.addEntry("test".getBytes());
        managedLedger.addEntry(Markers.newTxnCommitMarker((long)1L, (long)1L, (long)1L).array());
        Position position3 = managedLedger.addEntry(Markers.newTxnCommitMarker((long)1L, (long)1L, (long)1L).array());
        Assert.assertEquals((long)cursor.getNumberOfEntriesInBacklog(true), (long)3L);
        Assert.assertTrue((((PositionImpl)cursor.getMarkDeletedPosition()).compareTo((PositionImpl)position1) < 0 ? 1 : 0) != 0);
        persistentSubscription.acknowledgeMessage(Collections.singletonList(position1), CommandAck.AckType.Individual, Collections.emptyMap());
        Thread.sleep(1000L);
        Assert.assertEquals((int)((PositionImpl)persistentSubscription.getCursor().getMarkDeletedPosition()).compareTo((PositionImpl)position3), (int)0);
    }

    @Test
    public void testMarkerDeleteTimes() throws Exception {
        ManagedLedgerImpl managedLedger = (ManagedLedgerImpl)Mockito.spy((Object)((ManagedLedgerImpl)this.pulsar.getManagedLedgerFactory().open("test")));
        PersistentTopic topic = (PersistentTopic)Mockito.mock(PersistentTopic.class);
        BrokerService brokerService = (BrokerService)Mockito.mock(BrokerService.class);
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        ServiceConfiguration configuration = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        ((PersistentTopic)Mockito.doReturn((Object)brokerService).when((Object)topic)).getBrokerService();
        ((BrokerService)Mockito.doReturn((Object)pulsarService).when((Object)brokerService)).getPulsar();
        ((PulsarService)Mockito.doReturn((Object)configuration).when((Object)pulsarService)).getConfig();
        ((ServiceConfiguration)Mockito.doReturn((Object)false).when((Object)configuration)).isTransactionCoordinatorEnabled();
        ((PersistentTopic)Mockito.doReturn((Object)managedLedger).when((Object)topic)).getManagedLedger();
        ManagedCursor cursor = managedLedger.openCursor("test");
        PersistentSubscription persistentSubscription = (PersistentSubscription)Mockito.spy((Object)new PersistentSubscription(topic, "test", cursor, false));
        Position position = managedLedger.addEntry("test".getBytes());
        persistentSubscription.acknowledgeMessage(Collections.singletonList(position), CommandAck.AckType.Individual, Collections.emptyMap());
        ((ManagedLedgerImpl)Mockito.verify((Object)managedLedger, (VerificationMode)Mockito.times((int)0))).asyncReadEntry((PositionImpl)ArgumentMatchers.any(), (AsyncCallbacks.ReadEntryCallback)ArgumentMatchers.any(), ArgumentMatchers.any());
    }
}

