/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.BrokerTestUtil;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class DelayedDeliveryTest
extends ProducerConsumerBase {
    @Override
    @BeforeClass
    public void setup() throws Exception {
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTopicLevelPoliciesEnabled(true);
        this.conf.setDelayedDeliveryTickTimeMillis(1024L);
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelayedDelivery() throws Exception {
        String topic = BrokerTestUtil.newUniqueName("testNegativeAcks");
        Consumer failoverConsumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("failover-sub").subscriptionType(SubscriptionType.Failover).subscribe();
        try {
            Consumer sharedConsumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("shared-sub").subscriptionType(SubscriptionType.Shared).subscribe();
            try {
                Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
                try {
                    int i;
                    for (int i2 = 0; i2 < 10; ++i2) {
                        producer.newMessage().value((Object)("msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).sendAsync();
                    }
                    producer.flush();
                    Message msg = sharedConsumer.receive(100, TimeUnit.MILLISECONDS);
                    Assert.assertNull((Object)msg);
                    for (int i3 = 0; i3 < 10; ++i3) {
                        msg = failoverConsumer.receive(100, TimeUnit.MILLISECONDS);
                        Assert.assertEquals((String)((String)msg.getValue()), (String)("msg-" + i3));
                    }
                    TreeSet<Object> receivedMsgs = new TreeSet<Object>();
                    for (i = 0; i < 10; ++i) {
                        msg = sharedConsumer.receive(10, TimeUnit.SECONDS);
                        receivedMsgs.add(msg.getValue());
                    }
                    Assert.assertEquals((int)receivedMsgs.size(), (int)10);
                    for (i = 0; i < 10; ++i) {
                        Assert.assertTrue((boolean)receivedMsgs.contains("msg-" + i));
                    }
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(sharedConsumer).get(0) != null) {
                    sharedConsumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(failoverConsumer).get(0) != null) {
                failoverConsumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterleavedMessages() throws Exception {
        String topic = BrokerTestUtil.newUniqueName("testInterleavedMessages");
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("shared-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
            try {
                int i;
                int i2;
                for (i2 = 0; i2 < 10; ++i2) {
                    producer.newMessage().value((Object)("immediate-msg-" + i2)).sendAsync();
                    producer.newMessage().value((Object)("delayed-msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).sendAsync();
                }
                producer.flush();
                for (i2 = 0; i2 < 10; ++i2) {
                    Message msg = consumer.receive(100, TimeUnit.MILLISECONDS);
                    Assert.assertEquals((String)((String)msg.getValue()), (String)("immediate-msg-" + i2));
                    consumer.acknowledge(msg);
                }
                TreeSet<Object> delayedMessages = new TreeSet<Object>();
                for (i = 0; i < 10; ++i) {
                    Message msg = consumer.receive(10, TimeUnit.SECONDS);
                    delayedMessages.add(msg.getValue());
                    consumer.acknowledge(msg);
                }
                for (i = 0; i < 10; ++i) {
                    Assert.assertTrue((boolean)delayedMessages.contains("delayed-msg-" + i));
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEverythingFilteredInMultipleReads() throws Exception {
        String topic = BrokerTestUtil.newUniqueName("testEverythingFilteredInMultipleReads");
        Consumer sharedConsumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("shared-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
            try {
                int i;
                int i2;
                for (i2 = 0; i2 < 10; ++i2) {
                    producer.newMessage().value((Object)("msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).send();
                }
                Thread.sleep(1000L);
                for (i2 = 10; i2 < 20; ++i2) {
                    producer.newMessage().value((Object)("msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).send();
                }
                Message msg = sharedConsumer.receive(100, TimeUnit.MILLISECONDS);
                Assert.assertNull((Object)msg);
                TreeSet<Object> receivedMsgs = new TreeSet<Object>();
                for (i = 0; i < 20; ++i) {
                    msg = sharedConsumer.receive(10, TimeUnit.SECONDS);
                    receivedMsgs.add(msg.getValue());
                }
                Assert.assertEquals((int)receivedMsgs.size(), (int)20);
                for (i = 0; i < 10; ++i) {
                    Assert.assertTrue((boolean)receivedMsgs.contains("msg-" + i));
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(sharedConsumer).get(0) != null) {
                sharedConsumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelayedDeliveryWithMultipleConcurrentReadEntries() throws Exception {
        String topic = BrokerTestUtil.newUniqueName("persistent://public/default/testDelayedDelivery");
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("shared-sub").subscriptionType(SubscriptionType.Shared).receiverQueueSize(1).subscribe();
        try {
            PersistentDispatcherMultipleConsumers d = (PersistentDispatcherMultipleConsumers)((PersistentTopic)this.pulsar.getBrokerService().getTopicReference(topic).get()).getSubscription("shared-sub").getDispatcher();
            Thread t = new Thread(() -> {
                while (true) {
                    PersistentDispatcherMultipleConsumers persistentDispatcherMultipleConsumers = d;
                    synchronized (persistentDispatcherMultipleConsumers) {
                        d.readMoreEntries();
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            });
            t.start();
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
            try {
                int i;
                int N = 1000;
                for (int i2 = 0; i2 < 1000; ++i2) {
                    producer.newMessage().value((Object)("msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).sendAsync();
                }
                producer.flush();
                Message msg = consumer.receive(100, TimeUnit.MILLISECONDS);
                Assert.assertNull((Object)msg);
                TreeSet<Object> receivedMsgs = new TreeSet<Object>();
                for (i = 0; i < 1000; ++i) {
                    msg = consumer.receive(10, TimeUnit.SECONDS);
                    receivedMsgs.add(msg.getValue());
                }
                Assert.assertEquals((int)receivedMsgs.size(), (int)1000);
                for (i = 0; i < 1000; ++i) {
                    Assert.assertTrue((boolean)receivedMsgs.contains("msg-" + i));
                }
                t.interrupt();
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrderingDispatch() throws PulsarClientException {
        String topic = BrokerTestUtil.newUniqueName("persistent://public/default/testOrderingDispatch");
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("shared-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
            try {
                int i;
                int N = 1000;
                for (int i2 = 0; i2 < 1000; ++i2) {
                    producer.newMessage().value((Object)("msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).send();
                }
                ArrayList<Message> receives = new ArrayList<Message>(1000);
                for (i = 0; i < 1000; ++i) {
                    Message received = consumer.receive();
                    receives.add(received);
                    consumer.acknowledge(received);
                }
                Assert.assertEquals((int)receives.size(), (int)1000);
                for (i = 0; i < 1000; ++i) {
                    if (i >= 999) continue;
                    Assert.assertTrue((((Message)receives.get(i)).getMessageId().compareTo((Object)((Message)receives.get(i + 1)).getMessageId()) < 0 ? 1 : 0) != 0);
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    @Test(timeOut=20000L)
    public void testEnableAndDisableTopicDelayedDelivery() throws Exception {
        int i;
        String topicName = "persistent://public/default/topic-" + UUID.randomUUID().toString();
        this.admin.topics().createPartitionedTopic(topicName, 3);
        Assert.assertNull((Object)this.admin.topics().getDelayedDeliveryPolicy(topicName));
        DelayedDeliveryPolicies delayedDeliveryPolicies = new DelayedDeliveryPolicies(2000L, false);
        this.admin.topics().setDelayedDeliveryPolicy(topicName, delayedDeliveryPolicies);
        for (i = 0; i < 50; ++i) {
            Thread.sleep(100L);
            if (this.admin.topics().getDelayedDeliveryPolicy(topicName) != null) break;
        }
        Assert.assertFalse((boolean)this.admin.topics().getDelayedDeliveryPolicy(topicName).isActive());
        Assert.assertEquals((long)2000L, (long)this.admin.topics().getDelayedDeliveryPolicy(topicName).getTickTime());
        this.admin.topics().removeDelayedDeliveryPolicy(topicName);
        for (i = 0; i < 50; ++i) {
            Thread.sleep(100L);
            if (this.admin.topics().getDelayedDeliveryPolicy(topicName) == null) break;
        }
        Assert.assertNull((Object)this.admin.topics().getDelayedDeliveryPolicy(topicName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=20000L)
    public void testEnableTopicDelayedDelivery() throws Exception {
        String topicName = "persistent://public/default/test" + UUID.randomUUID().toString();
        this.admin.topics().createPartitionedTopic(topicName, 3);
        Assert.assertNull((Object)this.admin.topics().getDelayedDeliveryPolicy(topicName));
        DelayedDeliveryPolicies delayedDeliveryPolicies = new DelayedDeliveryPolicies(2000L, true);
        this.admin.topics().setDelayedDeliveryPolicy(topicName, delayedDeliveryPolicies);
        for (int i = 0; i < 50; ++i) {
            Thread.sleep(100L);
            if (this.admin.topics().getDelayedDeliveryPolicy(topicName) != null) break;
        }
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topicName}).subscriptionName("test-sub" + System.currentTimeMillis()).subscriptionType(SubscriptionType.Shared).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topicName).create();
            try {
                int i;
                int i2;
                for (int i3 = 0; i3 < 10; ++i3) {
                    producer.newMessage().value((Object)("delayed-msg-" + i3)).deliverAfter(5L, TimeUnit.SECONDS).sendAsync();
                }
                producer.flush();
                Assert.assertNull((Object)consumer.receive(3, TimeUnit.SECONDS));
                HashSet<Object> delayedMessages = new HashSet<Object>();
                for (i2 = 0; i2 < 10; ++i2) {
                    Message msg = consumer.receive(4, TimeUnit.SECONDS);
                    delayedMessages.add(msg.getValue());
                    consumer.acknowledge(msg);
                }
                for (i2 = 0; i2 < 10; ++i2) {
                    Assert.assertTrue((boolean)delayedMessages.contains("delayed-msg-" + i2));
                }
                delayedDeliveryPolicies.setActive(false);
                this.admin.topics().setDelayedDeliveryPolicy(topicName, delayedDeliveryPolicies);
                for (i2 = 0; i2 < 50; ++i2) {
                    Thread.sleep(100L);
                    if (!this.admin.topics().getDelayedDeliveryPolicy(topicName).isActive()) break;
                }
                producer.newMessage().value((Object)"disabled-msg").deliverAfter(5L, TimeUnit.SECONDS).send();
                Message msg = consumer.receive(1, TimeUnit.SECONDS);
                Assert.assertNotNull((Object)msg);
                consumer.acknowledge(msg);
                delayedDeliveryPolicies.setActive(true);
                delayedDeliveryPolicies.setTickTime(Integer.MAX_VALUE);
                this.admin.topics().setDelayedDeliveryPolicy(topicName, delayedDeliveryPolicies);
                for (i = 0; i < 50; ++i) {
                    Thread.sleep(100L);
                    if (this.admin.topics().getDelayedDeliveryPolicy(topicName).isActive()) break;
                }
                producer.newMessage().value((Object)"long-tick-msg").deliverAfter(5L, TimeUnit.SECONDS).send();
                msg = consumer.receive(1, TimeUnit.SECONDS);
                Assert.assertNotNull((Object)msg);
                consumer.acknowledge(msg);
                this.admin.topics().removeDelayedDeliveryPolicy(topicName);
                for (i = 0; i < 50; ++i) {
                    Thread.sleep(100L);
                    if (this.admin.topics().getDelayedDeliveryPolicy(topicName) == null) break;
                }
                producer.newMessage().value((Object)"long-tick-msg").deliverAfter(2L, TimeUnit.SECONDS).send();
                msg = consumer.receive(1, TimeUnit.SECONDS);
                Assert.assertNull((Object)msg);
                msg = consumer.receive(3, TimeUnit.SECONDS);
                Assert.assertNotNull((Object)msg);
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearDelayedMessagesWhenClearBacklog() throws PulsarClientException, PulsarAdminException {
        String topic = "persistent://public/default/testClearDelayedMessagesWhenClearBacklog-" + UUID.randomUUID().toString();
        String subName = "my-sub";
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
            try {
                int messages = 100;
                for (int i = 0; i < 100; ++i) {
                    producer.newMessage().deliverAfter(1L, TimeUnit.HOURS).value((Object)("Delayed Message - " + i)).send();
                }
                Dispatcher dispatcher = ((Topic)this.pulsar.getBrokerService().getTopicReference(topic).get()).getSubscription("my-sub").getDispatcher();
                Awaitility.await().untilAsserted(() -> Assert.assertEquals((long)dispatcher.getNumberOfDelayedMessages(), (long)100L));
                this.admin.topics().skipAllMessages(topic, "my-sub");
                Awaitility.await().untilAsserted(() -> Assert.assertEquals((long)dispatcher.getNumberOfDelayedMessages(), (long)0L));
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }
}

