/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClient;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionStablePositionTest
extends TransactionTestBase {
    private static final Logger log = LoggerFactory.getLogger(TransactionStablePositionTest.class);
    private static final String TENANT = "tnx";
    private static final String NAMESPACE1 = "tnx/ns1";
    private static final String TOPIC = "tnx/ns1/test-topic";

    @BeforeMethod
    protected void setup() throws Exception {
        this.internalSetup();
        String[] brokerServiceUrlArr = this.getPulsarServiceList().get(0).getBrokerServiceUrl().split(":");
        String webServicePort = brokerServiceUrlArr[brokerServiceUrlArr.length - 1];
        this.admin.clusters().createCluster("test", new ClusterData("http://localhost:" + webServicePort));
        this.admin.tenants().createTenant(TENANT, new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NAMESPACE1);
        this.admin.topics().createNonPartitionedTopic(TOPIC);
        this.admin.tenants().createTenant(NamespaceName.SYSTEM_NAMESPACE.getTenant(), new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NamespaceName.SYSTEM_NAMESPACE.toString());
        this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), 16);
        if (this.pulsarClient != null) {
            this.pulsarClient.shutdown();
        }
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsarServiceList().get(0).getBrokerServiceUrl()).statsInterval(0L, TimeUnit.SECONDS).enableTransaction(true).build();
        Awaitility.await().until(() -> ((PulsarClientImpl)this.pulsarClient).getTcClient().getState() == TransactionCoordinatorClient.State.READY);
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void commitTxnTest() throws Exception {
        Transaction txn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(5L, TimeUnit.SECONDS).build().get();
        Producer producer = this.pulsarClient.newProducer().topic(TOPIC).sendTimeout(0, TimeUnit.SECONDS).enableBatching(false).create();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{TOPIC}).subscriptionName("test").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).enableBatchIndexAcknowledgment(true).subscriptionType(SubscriptionType.Failover).subscribe();
        String TEST1 = "test1";
        String TEST2 = "test2";
        String TEST3 = "test3";
        producer.newMessage().value((Object)"test1".getBytes()).send();
        producer.newMessage(txn).value((Object)"test2".getBytes()).send();
        producer.newMessage().value((Object)"test3".getBytes()).send();
        Message message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertEquals((String)new String(message.getData()), (String)"test1");
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertNull((Object)message);
        txn.commit().get();
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertEquals((String)new String(message.getData()), (String)"test2");
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertEquals((String)new String(message.getData()), (String)"test3");
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertNull((Object)message);
    }

    @Test
    public void abortTxnTest() throws Exception {
        Transaction txn = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(5L, TimeUnit.SECONDS).build().get();
        Producer producer = this.pulsarClient.newProducer().topic(TOPIC).sendTimeout(0, TimeUnit.SECONDS).enableBatching(false).create();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{TOPIC}).subscriptionName("test").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).enableBatchIndexAcknowledgment(true).subscriptionType(SubscriptionType.Failover).subscribe();
        String TEST1 = "test1";
        String TEST2 = "test2";
        String TEST3 = "test3";
        producer.newMessage().value((Object)"test1".getBytes()).send();
        producer.newMessage(txn).value((Object)"test2".getBytes()).send();
        producer.newMessage().value((Object)"test3".getBytes()).send();
        Message message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertEquals((String)new String(message.getData()), (String)"test1");
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertNull((Object)message);
        txn.abort().get();
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertEquals((String)new String(message.getData()), (String)"test3");
        message = consumer.receive(2, TimeUnit.SECONDS);
        Assert.assertNull((Object)message);
    }
}

