/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.MockedBookKeeperClientFactory;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.impl.auth.AuthenticationTls;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooKeeper;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.Response;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class WebServiceTest {
    private PulsarService pulsar;
    private String BROKER_LOOKUP_URL;
    private String BROKER_LOOKUP_URL_TLS;
    private static final String TLS_SERVER_CERT_FILE_PATH = "./src/test/resources/certificate/server.crt";
    private static final String TLS_SERVER_KEY_FILE_PATH = "./src/test/resources/certificate/server.key";
    private static final String TLS_CLIENT_CERT_FILE_PATH = "./src/test/resources/certificate/client.crt";
    private static final String TLS_CLIENT_KEY_FILE_PATH = "./src/test/resources/certificate/client.key";
    private static final Logger log = LoggerFactory.getLogger(WebServiceTest.class);

    @Test
    public void testDefaultClientVersion() throws Exception {
        this.setupEnv(true, "1.0", true, false, false, false, -1.0, false);
        try {
            this.makeHttpRequest(false, false);
        }
        catch (Exception e) {
            Assert.fail((String)"HTTP request to lookup a namespace shouldn't fail ", (Throwable)e);
        }
    }

    @Test
    public void testTlsEnabled() throws Exception {
        this.setupEnv(false, "1.0", false, true, false, false, -1.0, false);
        try {
            this.makeHttpRequest(false, false);
        }
        catch (Exception e) {
            Assert.fail((String)"HTTP request shouldn't fail ", (Throwable)e);
        }
        try {
            this.makeHttpRequest(true, false);
        }
        catch (Exception e) {
            Assert.fail((String)"HTTPS request shouldn't fail ", (Throwable)e);
        }
    }

    @Test
    public void testTlsDisabled() throws Exception {
        this.setupEnv(false, "1.0", false, false, false, false, -1.0, false);
        try {
            this.makeHttpRequest(false, false);
        }
        catch (Exception e) {
            Assert.fail((String)"HTTP request shouldn't fail ", (Throwable)e);
        }
        try {
            this.makeHttpRequest(true, false);
            Assert.fail((String)"HTTPS request should fail ");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTlsAuthAllowInsecure() throws Exception {
        this.setupEnv(false, "1.0", false, true, true, true, -1.0, false);
        try {
            this.makeHttpRequest(true, false);
            Assert.fail((String)"Request without client certficate should fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("HTTP response code: 401"));
        }
        try {
            this.makeHttpRequest(true, true);
        }
        catch (Exception e) {
            Assert.fail((String)"Request with client certificate shouldn't fail", (Throwable)e);
        }
    }

    @Test
    public void testTlsAuthDisallowInsecure() throws Exception {
        this.setupEnv(false, "1.0", false, true, true, false, -1.0, false);
        try {
            this.makeHttpRequest(true, false);
            Assert.fail((String)"Request without client certficate should fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("HTTP response code: 401"));
        }
        try {
            this.makeHttpRequest(true, true);
        }
        catch (Exception e) {
            Assert.fail((String)"Request with client certificate shouldn't fail", (Throwable)e);
        }
    }

    @Test
    public void testRateLimiting() throws Exception {
        int i;
        this.setupEnv(false, "1.0", false, false, false, false, 10.0, false);
        for (i = 0; i < 5; ++i) {
            this.makeHttpRequest(false, false);
            Thread.sleep(200L);
        }
        try {
            for (i = 0; i < 500; ++i) {
                this.makeHttpRequest(false, false);
            }
            Assert.fail((String)"Some request should have failed");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("429"));
        }
    }

    @Test
    public void testSplitPath() {
        String result = PulsarWebResource.splitPath((String)"prop/cluster/ns/topic1", (int)4);
        Assert.assertEquals((String)result, (String)"topic1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableHttpTraceAndTrackMethods() throws Exception {
        this.setupEnv(true, "1.0", true, false, false, false, -1.0, true);
        String url = this.pulsar.getWebServiceAddress() + "/admin/v2/tenants/my-tenant" + System.currentTimeMillis();
        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient();
        try {
            BoundRequestBuilder builder = client.prepare("TRACE", url);
            Response res = (Response)builder.execute().get();
            Assert.assertEquals((int)res.getStatusCode(), (int)405);
            builder = client.prepare("TRACK", url);
            res = (Response)builder.execute().get();
            Assert.assertEquals((int)res.getStatusCode(), (int)405);
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxRequestSize() throws Exception {
        this.setupEnv(true, "1.0", true, false, false, false, -1.0, false);
        String url = this.pulsar.getWebServiceAddress() + "/admin/v2/tenants/my-tenant" + System.currentTimeMillis();
        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient();
        try {
            BoundRequestBuilder builder = (BoundRequestBuilder)((BoundRequestBuilder)client.preparePut(url).setHeader((CharSequence)"Accept", "application/json")).setHeader((CharSequence)"Content-Type", "application/json");
            TenantInfo info1 = new TenantInfo();
            info1.setAdminRoles(Collections.singleton(StringUtils.repeat((String)"*", (int)20480)));
            builder.setBody(ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)info1));
            Response res = (Response)builder.execute().get();
            Assert.assertEquals((int)res.getStatusCode(), (int)400);
            String localCluster = "test";
            String clusterPath = PulsarWebResource.path((String[])new String[]{"clusters", localCluster});
            this.pulsar.getPulsarResources().getClusterResources().create(clusterPath, (Object)new ClusterData());
            TenantInfo info2 = new TenantInfo();
            info2.setAdminRoles(Collections.singleton(StringUtils.repeat((String)"*", (int)1024)));
            info2.setAllowedClusters((Set)Sets.newHashSet((Object[])new String[]{localCluster}));
            builder.setBody(ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)info2));
            Response res2 = (Response)builder.execute().get();
            Assert.assertEquals((int)res2.getStatusCode(), (int)204);
            Response res3 = (Response)((BoundRequestBuilder)((BoundRequestBuilder)client.prepareGet(url).setHeader((CharSequence)"Accept", "application/json")).setHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            Assert.assertEquals((int)res3.getStatusCode(), (int)200);
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrokerReady() throws Exception {
        this.setupEnv(true, "1.0", true, false, false, false, -1.0, false);
        String url = this.pulsar.getWebServiceAddress() + "/admin/v2/brokers/ready";
        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient();
        try {
            Response res = (Response)client.prepareGet(url).execute().get();
            Assert.assertEquals((int)res.getStatusCode(), (int)200);
            Assert.assertEquals((String)res.getResponseBody(), (String)"ok");
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeHttpRequest(boolean useTls, boolean useAuth) throws Exception {
        String string;
        InputStream response = null;
        try {
            if (useTls) {
                KeyManager[] keyManagers = null;
                if (useAuth) {
                    Certificate[] tlsCert = SecurityUtility.loadCertificatesFromPemFile((String)TLS_CLIENT_CERT_FILE_PATH);
                    PrivateKey tlsKey = SecurityUtility.loadPrivateKeyFromPemFile((String)TLS_CLIENT_KEY_FILE_PATH);
                    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    ks.load(null, null);
                    ks.setKeyEntry("private", tlsKey, "".toCharArray(), tlsCert);
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, "".toCharArray());
                    keyManagers = kmf.getKeyManagers();
                }
                TrustManager[] trustManagers = InsecureTrustManagerFactory.INSTANCE.getTrustManagers();
                SSLContext sslCtx = SSLContext.getInstance("TLS");
                sslCtx.init(keyManagers, trustManagers, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sslCtx.getSocketFactory());
                response = new URL(this.BROKER_LOOKUP_URL_TLS).openStream();
            } else {
                response = new URL(this.BROKER_LOOKUP_URL).openStream();
            }
            String resp = CharStreams.toString((Readable)new InputStreamReader(response));
            log.info("Response: {}", (Object)resp);
            string = resp;
        }
        catch (Throwable throwable) {
            Closeables.close(response, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)response, (boolean)false);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupEnv(boolean enableFilter, String minApiVersion, boolean allowUnversionedClients, boolean enableTls, boolean enableAuth, boolean allowInsecure, double rateLimit, boolean disableTrace) throws Exception {
        if (this.pulsar != null) {
            throw new Exception("broker already started");
        }
        HashSet<String> providers = new HashSet<String>();
        providers.add("org.apache.pulsar.broker.authentication.AuthenticationProviderTls");
        HashSet<String> roles = new HashSet<String>();
        roles.add("client");
        ServiceConfiguration config = new ServiceConfiguration();
        config.setAdvertisedAddress("localhost");
        config.setBrokerShutdownTimeoutMs(0L);
        config.setBrokerServicePort(Optional.of(0));
        config.setWebServicePort(Optional.of(0));
        if (enableTls) {
            config.setWebServicePortTls(Optional.of(0));
        }
        config.setClientLibraryVersionCheckEnabled(enableFilter);
        config.setAuthenticationEnabled(enableAuth);
        config.setAuthenticationProviders(providers);
        config.setAuthorizationEnabled(false);
        config.setSuperUserRoles(roles);
        config.setTlsCertificateFilePath(TLS_SERVER_CERT_FILE_PATH);
        config.setTlsKeyFilePath(TLS_SERVER_KEY_FILE_PATH);
        config.setTlsAllowInsecureConnection(allowInsecure);
        config.setTlsTrustCertsFilePath(allowInsecure ? "" : TLS_CLIENT_CERT_FILE_PATH);
        config.setClusterName("local");
        config.setAdvertisedAddress("localhost");
        config.setZookeeperServers("localhost:2181");
        config.setHttpMaxRequestSize(10240L);
        config.setDisableHttpDebugMethods(disableTrace);
        if (rateLimit > 0.0) {
            config.setHttpRequestsLimitEnabled(true);
            config.setHttpRequestsMaxPerSecond(rateLimit);
        }
        this.pulsar = (PulsarService)Mockito.spy((Object)new PulsarService(config));
        final MockZooKeeper mockZooKeeper = MockedPulsarServiceBaseTest.createMockZooKeeper();
        ZooKeeperClientFactory mockZooKeeperClientFactory = new ZooKeeperClientFactory(){

            public CompletableFuture<ZooKeeper> create(String serverList, ZooKeeperClientFactory.SessionType sessionType, int zkSessionTimeoutMillis) {
                return CompletableFuture.completedFuture(mockZooKeeper);
            }
        };
        ((PulsarService)Mockito.doReturn((Object)mockZooKeeperClientFactory).when((Object)this.pulsar)).getZooKeeperClientFactory();
        ((PulsarService)Mockito.doReturn((Object)new ZKMetadataStore((ZooKeeper)mockZooKeeper)).when((Object)this.pulsar)).createConfigurationMetadataStore();
        ((PulsarService)Mockito.doReturn((Object)new ZKMetadataStore((ZooKeeper)mockZooKeeper)).when((Object)this.pulsar)).createLocalMetadataStore();
        ((PulsarService)Mockito.doReturn((Object)new MockedBookKeeperClientFactory()).when((Object)this.pulsar)).newBookKeeperClientFactory();
        this.pulsar.start();
        try {
            this.pulsar.getZkClient().delete("/minApiVersion", -1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pulsar.getZkClient().create("/minApiVersion", minApiVersion.getBytes(), null, CreateMode.PERSISTENT);
        String BROKER_URL_BASE = "http://localhost:" + this.pulsar.getListenPortHTTP().get();
        String BROKER_URL_BASE_TLS = "https://localhost:" + this.pulsar.getListenPortHTTPS().orElse(-1);
        String serviceUrl = BROKER_URL_BASE;
        PulsarAdminBuilder adminBuilder = PulsarAdmin.builder();
        if (enableTls && enableAuth) {
            serviceUrl = BROKER_URL_BASE_TLS;
            HashMap<String, String> authParams = new HashMap<String, String>();
            authParams.put("tlsCertFile", TLS_CLIENT_CERT_FILE_PATH);
            authParams.put("tlsKeyFile", TLS_CLIENT_KEY_FILE_PATH);
            adminBuilder.authentication(AuthenticationTls.class.getName(), authParams).allowTlsInsecureConnection(true);
        }
        this.BROKER_LOOKUP_URL = BROKER_URL_BASE + "/lookup/v2/destination/persistent/my-property/local/my-namespace/my-topic";
        this.BROKER_LOOKUP_URL_TLS = BROKER_URL_BASE_TLS + "/lookup/v2/destination/persistent/my-property/local/my-namespace/my-topic";
        try (PulsarAdmin pulsarAdmin = adminBuilder.serviceHttpUrl(serviceUrl).build();){
            pulsarAdmin.clusters().createCluster(config.getClusterName(), new ClusterData(this.pulsar.getSafeWebServiceAddress()));
        }
    }

    @AfterMethod(alwaysRun=true)
    void teardown() {
        if (this.pulsar != null) {
            try {
                this.pulsar.close();
                this.pulsar = null;
            }
            catch (Exception e) {
                Assert.fail((String)"Got exception while closing the pulsar instance ", (Throwable)e);
            }
        }
    }
}

