/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentStickyKeyDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.EncryptionKeyInfo;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.util.Murmur3_32Hash;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"flaky"})
public class KeySharedSubscriptionTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(KeySharedSubscriptionTest.class);
    private static final List<String> keys = Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
    private static final Random random = new Random(System.nanoTime());
    private static final int NUMBER_OF_KEYS = 300;

    @DataProvider(name="batch")
    public Object[] batchProvider() {
        return new Object[]{false, true};
    }

    @DataProvider(name="partitioned")
    public Object[][] partitionedProvider() {
        return new Object[][]{{false}, {true}};
    }

    @DataProvider(name="data")
    public Object[][] dataProvider() {
        return new Object[][]{{"persistent", false}, {"persistent", true}, {"non-persistent", false}, {"non-persistent", true}};
    }

    @Override
    @BeforeMethod(alwaysRun=true)
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
        this.conf.setSubscriptionKeySharedUseConsistentHashing(true);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="data")
    public void testSendAndReceiveWithHashRangeAutoSplitStickyKeyConsumerSelector(String topicType, boolean enableBatch) throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = topicType + "://public/default/key_shared-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic);
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic);
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic);
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                        }
                        this.receiveAndCheckDistribution(Lists.newArrayList((Object[])new Consumer[]{consumer1, consumer2, consumer3}), 1000);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="data")
    public void testSendAndReceiveWithBatching(String topicType, boolean enableBatch) throws Exception {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = topicType + "://public/default/key_shared-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic);
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic);
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic);
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            String key = String.valueOf(random.nextInt(300));
                            CompletableFuture future = producer.newMessage().key(key).value((Object)i).sendAsync();
                            if (!enableBatch) {
                                future.get();
                            }
                            future = producer.newMessage().key(key).value((Object)i).sendAsync();
                            if (enableBatch) continue;
                            future.get();
                        }
                        producer.flush();
                        this.receiveAndCheckDistribution(Lists.newArrayList((Object[])new Consumer[]{consumer1, consumer2, consumer3}), 2000);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="batch")
    public void testSendAndReceiveWithHashRangeExclusiveStickyKeyConsumerSelector(boolean enableBatch) throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "persistent://public/default/key_shared_exclusive-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic, (KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(new Range[]{Range.of((int)0, (int)20000)}));
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic, (KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(new Range[]{Range.of((int)20001, (int)40000)}));
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic, (KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(new Range[]{Range.of((int)40001, (int)65535)}));
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        int consumer1ExpectMessages = 0;
                        int consumer2ExpectMessages = 0;
                        int consumer3ExpectMessages = 0;
                        for (int i = 0; i < 10; ++i) {
                            for (String key : keys) {
                                int slot = Murmur3_32Hash.getInstance().makeHash(key.getBytes()) % 65536;
                                if (slot <= 20000) {
                                    ++consumer1ExpectMessages;
                                } else if (slot <= 40000) {
                                    ++consumer2ExpectMessages;
                                } else {
                                    ++consumer3ExpectMessages;
                                }
                                producer.newMessage().key(key).value((Object)i).send();
                            }
                        }
                        ArrayList<KeyValue<Consumer<Integer>, Integer>> checkList = new ArrayList<KeyValue<Consumer<Integer>, Integer>>();
                        checkList.add(new KeyValue(consumer1, (Object)consumer1ExpectMessages));
                        checkList.add(new KeyValue(consumer2, (Object)consumer2ExpectMessages));
                        checkList.add(new KeyValue(consumer3, (Object)consumer3ExpectMessages));
                        this.receiveAndCheck(checkList);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="data")
    public void testConsumerCrashSendAndReceiveWithHashRangeAutoSplitStickyKeyConsumerSelector(String topicType, boolean enableBatch) throws PulsarClientException, InterruptedException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = topicType + "://public/default/key_shared_consumer_crash-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic);
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic);
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic);
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        int i;
                        for (i = 0; i < 1000; ++i) {
                            producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                        }
                        this.receiveAndCheckDistribution(Lists.newArrayList((Object[])new Consumer[]{consumer1, consumer2, consumer3}), 1000);
                        Thread.sleep(1000L);
                        consumer1.close();
                        consumer2.close();
                        for (i = 0; i < 10; ++i) {
                            producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                        }
                        this.receiveAndCheckDistribution(Lists.newArrayList((Object[])new Consumer[]{consumer3}), 10);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="data")
    public void testNonKeySendAndReceiveWithHashRangeAutoSplitStickyKeyConsumerSelector(String topicType, boolean enableBatch) throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = topicType + "://public/default/key_shared_none_key-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic);
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic);
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic);
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        for (int i = 0; i < 100; ++i) {
                            producer.newMessage().value((Object)i).send();
                        }
                        this.receive(Lists.newArrayList((Object[])new Consumer[]{consumer1, consumer2, consumer3}));
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="batch")
    public void testNonKeySendAndReceiveWithHashRangeExclusiveStickyKeyConsumerSelector(boolean enableBatch) throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "persistent://public/default/key_shared_none_key_exclusive-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic, (KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(new Range[]{Range.of((int)0, (int)20000)}));
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic, (KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(new Range[]{Range.of((int)20001, (int)40000)}));
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic, (KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(new Range[]{Range.of((int)40001, (int)65535)}));
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        for (int i = 0; i < 100; ++i) {
                            producer.newMessage().value((Object)i).send();
                        }
                        int slot = Murmur3_32Hash.getInstance().makeHash("NONE_KEY".getBytes()) % 65536;
                        ArrayList<KeyValue<Consumer<Integer>, Integer>> checkList = new ArrayList<KeyValue<Consumer<Integer>, Integer>>();
                        if (slot <= 20000) {
                            checkList.add(new KeyValue(consumer1, (Object)100));
                        } else if (slot <= 40000) {
                            checkList.add(new KeyValue(consumer2, (Object)100));
                        } else {
                            checkList.add(new KeyValue(consumer3, (Object)100));
                        }
                        this.receiveAndCheck(checkList);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="batch")
    public void testOrderingKeyWithHashRangeAutoSplitStickyKeyConsumerSelector(boolean enableBatch) throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "persistent://public/default/key_shared_ordering_key-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic);
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic);
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic);
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            producer.newMessage().key("any key").orderingKey(String.valueOf(random.nextInt(300)).getBytes()).value((Object)i).send();
                        }
                        this.receiveAndCheckDistribution(Lists.newArrayList((Object[])new Consumer[]{consumer1, consumer2, consumer3}), 1000);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="batch")
    public void testOrderingKeyWithHashRangeExclusiveStickyKeyConsumerSelector(boolean enableBatch) throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "persistent://public/default/key_shared_exclusive_ordering_key-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic, (KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(new Range[]{Range.of((int)0, (int)20000)}));
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic, (KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(new Range[]{Range.of((int)20001, (int)40000)}));
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic, (KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(new Range[]{Range.of((int)40001, (int)65535)}));
                try {
                    Producer<Integer> producer = this.createProducer(topic, enableBatch);
                    try {
                        int consumer1ExpectMessages = 0;
                        int consumer2ExpectMessages = 0;
                        int consumer3ExpectMessages = 0;
                        for (int i = 0; i < 10; ++i) {
                            for (String key : keys) {
                                int slot = Murmur3_32Hash.getInstance().makeHash(key.getBytes()) % 65536;
                                if (slot <= 20000) {
                                    ++consumer1ExpectMessages;
                                } else if (slot <= 40000) {
                                    ++consumer2ExpectMessages;
                                } else {
                                    ++consumer3ExpectMessages;
                                }
                                producer.newMessage().key("any key").orderingKey(key.getBytes()).value((Object)i).send();
                            }
                        }
                        ArrayList<KeyValue<Consumer<Integer>, Integer>> checkList = new ArrayList<KeyValue<Consumer<Integer>, Integer>>();
                        checkList.add(new KeyValue(consumer1, (Object)consumer1ExpectMessages));
                        checkList.add(new KeyValue(consumer2, (Object)consumer2ExpectMessages));
                        checkList.add(new KeyValue(consumer3, (Object)consumer3ExpectMessages));
                        this.receiveAndCheck(checkList);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    @Test(expectedExceptions={PulsarClientException.NotAllowedException.class})
    public void testDisableKeySharedSubscription() throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(false);
        String topic = "persistent://public/default/key_shared_disabled";
        this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("key_shared").subscriptionType(SubscriptionType.Key_Shared).ackTimeout(10L, TimeUnit.SECONDS).subscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCannotUseAcknowledgeCumulative() throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "persistent://public/default/key_shared_ack_cumulative-" + UUID.randomUUID();
        Producer<Integer> producer = this.createProducer(topic, false);
        try {
            Consumer<Integer> consumer = this.createConsumer(topic);
            try {
                int i;
                for (i = 0; i < 10; ++i) {
                    producer.send((Object)i);
                }
                for (i = 0; i < 10; ++i) {
                    Message message = consumer.receive();
                    if (i != 9) continue;
                    try {
                        consumer.acknowledgeCumulative(message);
                        Assert.fail((String)"should have failed");
                        continue;
                    }
                    catch (PulsarClientException.InvalidConfigurationException invalidConfigurationException) {
                        // empty catch block
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="batch")
    public void testMakingProgressWithSlowerConsumer(boolean enableBatch) throws Exception {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "testMakingProgressWithSlowerConsumer-" + UUID.randomUUID();
        String slowKey = "slowKey";
        ArrayList<PulsarClient> clients = new ArrayList<PulsarClient>();
        try {
            AtomicInteger receivedMessages = new AtomicInteger();
            for (int i = 0; i < 10; ++i) {
                PulsarClient client = PulsarClient.builder().serviceUrl(this.brokerUrl.toString()).build();
                clients.add(client);
                client.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("key_shared").subscriptionType(SubscriptionType.Key_Shared).receiverQueueSize(1).messageListener((MessageListener & Serializable)(consumer, msg) -> {
                    try {
                        if (slowKey.equals(msg.getKey())) {
                            Thread.sleep(10000L);
                        }
                        receivedMessages.incrementAndGet();
                        consumer.acknowledge(msg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).subscribe();
            }
            Producer<Integer> producer = this.createProducer(topic, enableBatch);
            try {
                producer.newMessage().key(slowKey).value((Object)-1).send();
                int N = 1000;
                for (int i = 0; i < N; ++i) {
                    producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                }
                Thread.sleep(5000L);
                Assert.assertEquals((double)receivedMessages.get(), (double)((double)N * 0.9), (double)((double)N * 0.3));
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            for (PulsarClient c : clients) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrderingWhenAddingConsumers() throws Exception {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "testOrderingWhenAddingConsumers-" + UUID.randomUUID();
        Producer<Integer> producer = this.createProducer(topic, false);
        try {
            Consumer<Integer> c1 = this.createConsumer(topic);
            try {
                for (int i = 0; i < 10; ++i) {
                    producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                }
                Consumer<Integer> c2 = this.createConsumer(topic);
                try {
                    int i;
                    for (i = 10; i < 20; ++i) {
                        producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                    }
                    c1.close();
                    for (i = 0; i < 20; ++i) {
                        Message msg = c2.receive();
                        Assert.assertEquals((int)((Integer)msg.getValue()), (int)i);
                        c2.acknowledge(msg);
                    }
                }
                finally {
                    if (Collections.singletonList(c2).get(0) != null) {
                        c2.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(c1).get(0) != null) {
                    c1.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadAheadWhenAddingConsumers() throws Exception {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "testReadAheadWhenAddingConsumers-" + UUID.randomUUID();
        Producer<Integer> producer = this.createProducer(topic, false);
        try {
            Consumer c1 = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("key_shared").subscriptionType(SubscriptionType.Key_Shared).receiverQueueSize(10).subscribe();
            try {
                for (int i = 0; i < 10; ++i) {
                    producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                }
                Consumer c2 = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("key_shared").subscriptionType(SubscriptionType.Key_Shared).receiverQueueSize(10).subscribe();
                try {
                    for (int i = 10; i < 1000; ++i) {
                        producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).sendAsync();
                    }
                    producer.flush();
                    Thread.sleep(1000L);
                    Topic t = (Topic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topic).get()).get();
                    PersistentSubscription sub = (PersistentSubscription)t.getSubscription("key_shared");
                    PositionImpl readPosition = (PositionImpl)sub.getCursor().getReadPosition();
                    Assert.assertTrue((readPosition.getEntryId() < 1000L ? 1 : 0) != 0);
                }
                finally {
                    if (Collections.singletonList(c2).get(0) != null) {
                        c2.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(c1).get(0) != null) {
                    c1.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveFirstConsumer() throws Exception {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "testReadAheadWhenAddingConsumers-" + UUID.randomUUID();
        Producer<Integer> producer = this.createProducer(topic, false);
        try {
            Consumer c1 = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("key_shared").subscriptionType(SubscriptionType.Key_Shared).receiverQueueSize(10).consumerName("c1").subscribe();
            try {
                for (int i = 0; i < 10; ++i) {
                    producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                }
                Consumer c2 = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("key_shared").subscriptionType(SubscriptionType.Key_Shared).receiverQueueSize(10).consumerName("c2").subscribe();
                try {
                    int i;
                    for (i = 10; i < 20; ++i) {
                        producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                    }
                    Assert.assertNull((Object)c2.receive(100, TimeUnit.MILLISECONDS));
                    c1.close();
                    for (i = 0; i < 20; ++i) {
                        Message msg = c2.receive();
                        Assert.assertEquals((int)((Integer)msg.getValue()), (int)i);
                        c2.acknowledge(msg);
                    }
                }
                finally {
                    if (Collections.singletonList(c2).get(0) != null) {
                        c2.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(c1).get(0) != null) {
                    c1.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    @Test
    public void testHashRangeConflict() throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "persistent://public/default/testHashRangeConflict-" + UUID.randomUUID().toString();
        String sub = "test";
        Consumer<String> consumer1 = this.createFixedHashRangesConsumer(topic, "test", Range.of((int)0, (int)99), Range.of((int)400, (int)65535));
        Assert.assertTrue((boolean)consumer1.isConnected());
        Consumer<String> consumer2 = this.createFixedHashRangesConsumer(topic, "test", Range.of((int)100, (int)399));
        Assert.assertTrue((boolean)consumer2.isConnected());
        PersistentStickyKeyDispatcherMultipleConsumers dispatcher = (PersistentStickyKeyDispatcherMultipleConsumers)((Topic)this.pulsar.getBrokerService().getTopicReference(topic).get()).getSubscription("test").getDispatcher();
        Assert.assertEquals((int)dispatcher.getConsumers().size(), (int)2);
        try {
            this.createFixedHashRangesConsumer(topic, "test", Range.of((int)0, (int)65535));
            Assert.fail((String)"Should failed with conflict range.");
        }
        catch (PulsarClientException.ConsumerAssignException consumerAssignException) {
            // empty catch block
        }
        try {
            this.createFixedHashRangesConsumer(topic, "test", Range.of((int)1, (int)1));
            Assert.fail((String)"Should failed with conflict range.");
        }
        catch (PulsarClientException.ConsumerAssignException consumerAssignException) {
            // empty catch block
        }
        Assert.assertEquals((int)dispatcher.getConsumers().size(), (int)2);
        consumer1.close();
        Assert.assertEquals((int)dispatcher.getConsumers().size(), (int)1);
        try {
            this.createFixedHashRangesConsumer(topic, "test", Range.of((int)0, (int)65535));
            Assert.fail((String)"Should failed with conflict range.");
        }
        catch (PulsarClientException.ConsumerAssignException consumerAssignException) {
            // empty catch block
        }
        try {
            this.createFixedHashRangesConsumer(topic, "test", Range.of((int)50, (int)100));
            Assert.fail((String)"Should failed with conflict range.");
        }
        catch (PulsarClientException.ConsumerAssignException consumerAssignException) {
            // empty catch block
        }
        try {
            this.createFixedHashRangesConsumer(topic, "test", Range.of((int)399, (int)500));
            Assert.fail((String)"Should failed with conflict range.");
        }
        catch (PulsarClientException.ConsumerAssignException consumerAssignException) {
            // empty catch block
        }
        Consumer<String> consumer3 = this.createFixedHashRangesConsumer(topic, "test", Range.of((int)400, (int)600));
        Assert.assertTrue((boolean)consumer3.isConnected());
        Consumer<String> consumer4 = this.createFixedHashRangesConsumer(topic, "test", Range.of((int)50, (int)99));
        Assert.assertTrue((boolean)consumer4.isConnected());
        Assert.assertEquals((int)dispatcher.getConsumers().size(), (int)3);
        consumer2.close();
        consumer3.close();
        consumer4.close();
        Assert.assertFalse((boolean)dispatcher.isConsumerConnected());
    }

    @Test
    public void testWithMessageCompression() throws Exception {
        String topic = "testWithMessageCompression" + UUID.randomUUID().toString();
        Producer producer = this.pulsarClient.newProducer().topic(topic).compressionType(CompressionType.LZ4).create();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("test").subscriptionType(SubscriptionType.Key_Shared).subscribe();
        int messages = 10;
        for (int i = 0; i < 10; ++i) {
            producer.send((Object)("Hello Pulsar > " + i).getBytes());
        }
        ArrayList<Message> receives = new ArrayList<Message>();
        for (int i = 0; i < 10; ++i) {
            Message received = consumer.receive();
            receives.add(received);
            consumer.acknowledge(received);
        }
        Assert.assertEquals((int)receives.size(), (int)10);
        producer.close();
        consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttachKeyToMessageMetadata() throws PulsarClientException {
        this.conf.setSubscriptionKeySharedEnable(true);
        String topic = "persistent://public/default/key_shared-" + UUID.randomUUID();
        Consumer<Integer> consumer1 = this.createConsumer(topic);
        try {
            Consumer<Integer> consumer2 = this.createConsumer(topic);
            try {
                Consumer<Integer> consumer3 = this.createConsumer(topic);
                try {
                    Producer producer = this.pulsarClient.newProducer(Schema.INT32).topic(topic).create();
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                        }
                        this.receiveAndCheckDistribution(Lists.newArrayList((Object[])new Consumer[]{consumer1, consumer2, consumer3}), 1000);
                    }
                    finally {
                        if (Collections.singletonList(producer).get(0) != null) {
                            producer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContinueDispatchMessagesWhenMessageTTL() throws Exception {
        int defaultTTLSec = 3;
        int totalMessages = 1000;
        this.conf.setTtlDurationDefaultInSeconds(defaultTTLSec);
        String topic = "persistent://public/default/key_shared-" + UUID.randomUUID();
        String subName = "my-sub";
        Consumer consumer1 = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("my-sub").receiverQueueSize(10).subscriptionType(SubscriptionType.Key_Shared).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer(Schema.INT32).topic(topic).create();
            try {
                for (int i = 0; i < totalMessages; ++i) {
                    producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                }
                consumer1.receive();
                consumer1.acknowledge(consumer1.receive());
                Consumer consumer2 = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Key_Shared).subscribe();
                try {
                    Message received = null;
                    try {
                        received = consumer2.receive(1, TimeUnit.SECONDS);
                    }
                    catch (PulsarClientException pulsarClientException) {
                        // empty catch block
                    }
                    Assert.assertNull(received);
                    Consumer consumer3 = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Key_Shared).subscribe();
                    try {
                        try {
                            received = consumer3.receive(1, TimeUnit.SECONDS);
                        }
                        catch (PulsarClientException pulsarClientException) {
                            // empty catch block
                        }
                        Assert.assertNull((Object)received);
                        Optional topicRef = (Optional)this.pulsar.getBrokerService().getTopic(topic, false).get();
                        Assert.assertTrue((boolean)topicRef.isPresent());
                        Thread.sleep((defaultTTLSec - 1) * 1000);
                        ((Topic)topicRef.get()).checkMessageExpiry();
                        for (int i = 0; i < totalMessages; ++i) {
                            producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                        }
                        Assert.assertNotNull((Object)consumer2.receive(1, TimeUnit.SECONDS));
                        Assert.assertNotNull((Object)consumer3.receive(1, TimeUnit.SECONDS));
                    }
                    finally {
                        if (Collections.singletonList(consumer3).get(0) != null) {
                            consumer3.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(consumer2).get(0) != null) {
                        consumer2.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="partitioned")
    public void testOrderingWithConsumerListener(boolean partitioned) throws Exception {
        String topic = "persistent://public/default/key_shared-" + UUID.randomUUID();
        if (partitioned) {
            this.admin.topics().createPartitionedTopic(topic, 3);
        }
        String subName = "my-sub";
        int messages = 1000;
        final List<Message> received = Collections.synchronizedList(new ArrayList(1000));
        final Random random = new Random();
        PulsarClient client = PulsarClient.builder().serviceUrl(this.lookupUrl.toString()).listenerThreads(8).build();
        try {
            Consumer consumer = client.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Key_Shared).messageListener((MessageListener)new MessageListener<Integer>(){

                public void received(Consumer<Integer> consumer, Message<Integer> msg) {
                    try {
                        Thread.sleep(random.nextInt(5));
                        received.add(msg);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }).subscribe();
            Producer producer = client.newProducer(Schema.INT32).topic(topic).create();
            String[] keys = new String[]{"key-1", "key-2", "key-3"};
            for (int i = 0; i < 1000; ++i) {
                producer.newMessage().key(keys[i % 3]).value((Object)i).send();
            }
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)received.size(), (int)1000));
            HashMap<String, Integer> maxValueOfKeys = new HashMap<String, Integer>();
            for (Message msg : received) {
                String key = msg.getKey();
                Integer value = (Integer)msg.getValue();
                if (maxValueOfKeys.containsKey(key)) {
                    Assert.assertTrue((value > (Integer)maxValueOfKeys.get(key) ? 1 : 0) != 0);
                }
                maxValueOfKeys.put(key, value);
                consumer.acknowledge(msg);
            }
            producer.close();
            consumer.close();
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeySharedConsumerWithEncrypted() throws Exception {
        String topic = "persistent://public/default/key_shared-" + UUID.randomUUID();
        int totalMessages = 100;
        Consumer consumer1 = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Key_Shared).cryptoKeyReader((CryptoKeyReader)new EncKeyReader()).subscribe();
        try {
            Consumer consumer2 = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{topic}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Key_Shared).cryptoKeyReader((CryptoKeyReader)new EncKeyReader()).subscribe();
            try {
                ArrayList consumers = Lists.newArrayList((Object[])new Consumer[]{consumer1, consumer2});
                Producer producer = this.pulsarClient.newProducer(Schema.INT32).topic(topic).cryptoKeyReader((CryptoKeyReader)new EncKeyReader()).create();
                try {
                    for (int i = 0; i < 100; ++i) {
                        producer.newMessage().key(String.valueOf(random.nextInt(300))).value((Object)i).send();
                    }
                    ArrayList<Message> receives = new ArrayList<Message>(100);
                    int[] consumerReceivesCount = new int[]{0, 0};
                    for (int i = 0; i < consumers.size(); ++i) {
                        Message received;
                        while ((received = ((Consumer)consumers.get(i)).receive(3, TimeUnit.SECONDS)) != null) {
                            receives.add(received);
                            int current = consumerReceivesCount[i];
                            consumerReceivesCount[i] = current + 1;
                        }
                    }
                    Assert.assertEquals((int)receives.size(), (int)100);
                    Assert.assertEquals((int)(consumerReceivesCount[0] + consumerReceivesCount[1]), (int)100);
                    Assert.assertTrue((consumerReceivesCount[0] > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((consumerReceivesCount[1] > 0 ? 1 : 0) != 0);
                    HashMap maxValueOfKey = new HashMap();
                    receives.forEach(msg -> {
                        if (maxValueOfKey.containsKey(msg.getKey())) {
                            Assert.assertTrue(((Integer)msg.getValue() > (Integer)maxValueOfKey.get(msg.getKey()) ? 1 : 0) != 0);
                        }
                        maxValueOfKey.put(msg.getKey(), msg.getValue());
                    });
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer1).get(0) != null) {
                consumer1.close();
            }
        }
    }

    private Consumer<String> createFixedHashRangesConsumer(String topic, String subscription, Range ... ranges) throws PulsarClientException {
        return this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionType(SubscriptionType.Key_Shared).subscriptionName(subscription).keySharedPolicy((KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(ranges)).subscribe();
    }

    private Producer<Integer> createProducer(String topic, boolean enableBatch) throws PulsarClientException {
        Producer producer = null;
        producer = enableBatch ? this.pulsarClient.newProducer(Schema.INT32).topic(topic).enableBatching(true).maxPendingMessages(2001).batcherBuilder(BatcherBuilder.KEY_BASED).create() : this.pulsarClient.newProducer(Schema.INT32).topic(topic).maxPendingMessages(2001).enableBatching(false).create();
        return producer;
    }

    private Consumer<Integer> createConsumer(String topic) throws PulsarClientException {
        return this.createConsumer(topic, null);
    }

    private Consumer<Integer> createConsumer(String topic, KeySharedPolicy keySharedPolicy) throws PulsarClientException {
        ConsumerBuilder builder = this.pulsarClient.newConsumer(Schema.INT32);
        builder.topic(new String[]{topic}).subscriptionName("key_shared").subscriptionType(SubscriptionType.Key_Shared).ackTimeout(3L, TimeUnit.SECONDS);
        if (keySharedPolicy != null) {
            builder.keySharedPolicy(keySharedPolicy);
        }
        return builder.subscribe();
    }

    private void receive(List<Consumer<?>> consumers) throws PulsarClientException {
        HashMap keyToConsumer = new HashMap();
        for (Consumer<?> c : consumers) {
            Message msg;
            while ((msg = c.receive(100, TimeUnit.MILLISECONDS)) != null) {
                c.acknowledge(msg);
                if (!msg.hasKey()) continue;
                Consumer assignedConsumer = (Consumer)keyToConsumer.get(msg.getKey());
                if (assignedConsumer == null) {
                    keyToConsumer.put(msg.getKey(), c);
                    continue;
                }
                Assert.assertEquals(c, (Object)assignedConsumer);
            }
        }
    }

    private void receiveAndCheckDistribution(List<Consumer<?>> consumers, int expectedTotalMessage) throws PulsarClientException {
        HashMap keyToConsumer = new HashMap();
        HashMap messagesPerConsumer = new HashMap();
        int totalMessages = 0;
        block0: for (Consumer<?> c : consumers) {
            int messagesForThisConsumer = 0;
            while (true) {
                Message msg;
                if ((msg = c.receive(100, TimeUnit.MILLISECONDS)) == null) {
                    messagesPerConsumer.put(c, messagesForThisConsumer);
                    continue block0;
                }
                ++totalMessages;
                ++messagesForThisConsumer;
                c.acknowledge(msg);
                if (!msg.hasKey() && !msg.hasOrderingKey()) continue;
                String key = msg.hasOrderingKey() ? new String(msg.getOrderingKey()) : msg.getKey();
                Consumer assignedConsumer = (Consumer)keyToConsumer.get(key);
                if (assignedConsumer == null) {
                    keyToConsumer.put(key, c);
                    continue;
                }
                Assert.assertEquals(c, (Object)assignedConsumer);
            }
        }
        double PERCENT_ERROR = 0.4;
        double expectedMessagesPerConsumer = totalMessages / consumers.size();
        Assert.assertEquals((int)expectedTotalMessage, (int)totalMessages);
        Iterator iterator = messagesPerConsumer.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            Assert.assertEquals((double)count, (double)expectedMessagesPerConsumer, (double)(expectedMessagesPerConsumer * 0.4));
        }
    }

    private void receiveAndCheck(List<KeyValue<Consumer<Integer>, Integer>> checkList) throws PulsarClientException {
        HashMap<Object, Set> consumerKeys = new HashMap<Object, Set>();
        for (KeyValue<Consumer<Integer>, Integer> check : checkList) {
            if ((Integer)check.getValue() % 2 != 0) {
                throw new IllegalArgumentException();
            }
            int received = 0;
            HashMap<String, Message> lastMessageForKey = new HashMap<String, Message>();
            Integer i = 0;
            while (i < (Integer)check.getValue()) {
                Object message = ((Consumer)check.getKey()).receive();
                if (i % 2 == 0) {
                    ((Consumer)check.getKey()).acknowledge(message);
                }
                Object key = message.hasOrderingKey() ? new String(message.getOrderingKey()) : message.getKey();
                log.info("[{}] Receive message key: {} value: {} messageId: {}", new Object[]{((Consumer)check.getKey()).getConsumerName(), key, message.getValue(), message.getMessageId()});
                if (lastMessageForKey.get(key) == null) {
                    Assert.assertNotNull((Object)message);
                } else {
                    Assert.assertTrue((((Integer)message.getValue()).compareTo((Integer)((Message)lastMessageForKey.get(key)).getValue()) > 0 ? 1 : 0) != 0);
                }
                lastMessageForKey.put((String)key, (Message)message);
                consumerKeys.putIfAbsent(check.getKey(), Sets.newHashSet());
                ((Set)consumerKeys.get(check.getKey())).add(key);
                ++received;
                message = i;
                i = i + 1;
                key = i;
            }
            Assert.assertEquals((int)((Integer)check.getValue()), (int)received);
            int redeliveryCount = (Integer)check.getValue() / 2;
            log.info("[{}] Consumer wait for {} messages redelivery ...", check, (Object)redeliveryCount);
            lastMessageForKey = new HashMap();
            for (int i2 = 0; i2 < redeliveryCount; ++i2) {
                Message message = ((Consumer)check.getKey()).receive();
                ++received;
                ((Consumer)check.getKey()).acknowledge(message);
                String key = message.hasOrderingKey() ? new String(message.getOrderingKey()) : message.getKey();
                log.info("[{}] Receive redeliver message key: {} value: {} messageId: {}", new Object[]{((Consumer)check.getKey()).getConsumerName(), key, message.getValue(), message.getMessageId()});
                if (lastMessageForKey.get(key) == null) {
                    Assert.assertNotNull((Object)message);
                } else {
                    Assert.assertTrue((((Integer)message.getValue()).compareTo((Integer)((Message)lastMessageForKey.get(key)).getValue()) > 0 ? 1 : 0) != 0);
                }
                lastMessageForKey.put(key, message);
            }
            Message noMessages = null;
            try {
                noMessages = ((Consumer)check.getKey()).receive(100, TimeUnit.MILLISECONDS);
            }
            catch (PulsarClientException pulsarClientException) {
                // empty catch block
            }
            Assert.assertNull(noMessages, (String)"redeliver too many messages.");
            Assert.assertEquals((int)((Integer)check.getValue() + redeliveryCount), (int)received);
        }
        HashSet allKeys = Sets.newHashSet();
        consumerKeys.forEach((k, v) -> v.forEach(key -> Assert.assertTrue((boolean)allKeys.add(key), (String)("Key " + key + "is distributed to multiple consumers."))));
    }

    private static class EncKeyReader
    implements CryptoKeyReader {
        EncryptionKeyInfo keyInfo = new EncryptionKeyInfo();

        private EncKeyReader() {
        }

        public EncryptionKeyInfo getPublicKey(String keyName, Map<String, String> keyMeta) {
            String CERT_FILE_PATH = "./src/test/resources/certificate/public-key." + keyName;
            if (Files.isReadable(Paths.get(CERT_FILE_PATH, new String[0]))) {
                try {
                    this.keyInfo.setKey(Files.readAllBytes(Paths.get(CERT_FILE_PATH, new String[0])));
                    return this.keyInfo;
                }
                catch (IOException e) {
                    Assert.fail((String)("Failed to read certificate from " + CERT_FILE_PATH));
                }
            } else {
                Assert.fail((String)("Certificate file " + CERT_FILE_PATH + " is not present or not readable."));
            }
            return null;
        }

        public EncryptionKeyInfo getPrivateKey(String keyName, Map<String, String> keyMeta) {
            String CERT_FILE_PATH = "./src/test/resources/certificate/private-key." + keyName;
            if (Files.isReadable(Paths.get(CERT_FILE_PATH, new String[0]))) {
                try {
                    this.keyInfo.setKey(Files.readAllBytes(Paths.get(CERT_FILE_PATH, new String[0])));
                    return this.keyInfo;
                }
                catch (IOException e) {
                    Assert.fail((String)("Failed to read certificate from " + CERT_FILE_PATH));
                }
            } else {
                Assert.fail((String)("Certificate file " + CERT_FILE_PATH + " is not present or not readable."));
            }
            return null;
        }
    }
}

