/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.admin.ZkAdminPaths;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.MultiTopicsConsumerImpl;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class PartitionCreationTest
extends ProducerConsumerBase {
    @DataProvider(name="topicDomainProvider")
    public Object[][] topicDomainProvider() {
        return new Object[][]{{TopicDomain.persistent}, {TopicDomain.non_persistent}};
    }

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        this.conf.setManagedLedgerCacheEvictionFrequency(0.1);
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test(dataProvider="topicDomainProvider", timeOut=60000L)
    public void testCreateConsumerForPartitionedTopicWhenDisableTopicAutoCreation(TopicDomain domain) throws PulsarAdminException, PulsarClientException {
        this.conf.setAllowAutoTopicCreation(domain.equals((Object)TopicDomain.non_persistent));
        String topic = domain.value() + "://public/default/testCreateConsumerWhenDisableTopicAutoCreation";
        this.admin.topics().createPartitionedTopic(topic, 3);
        Assert.assertNotNull((Object)this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub-1").subscribe());
    }

    @Test(dataProvider="topicDomainProvider", timeOut=60000L)
    public void testCreateConsumerForNonPartitionedTopicWhenDisableTopicAutoCreation(TopicDomain domain) throws PulsarClientException {
        this.conf.setAllowAutoTopicCreation(false);
        String topic = domain.value() + "://public/default/testCreateConsumerForNonPartitionedTopicWhenDisableTopicAutoCreation";
        try {
            Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub-1").subscribe();
            if (domain == TopicDomain.persistent) {
                Assert.fail((String)"should be failed");
            } else {
                Assert.assertNotNull((Object)consumer);
            }
        }
        catch (PulsarClientException.NotFoundException | PulsarClientException.TopicDoesNotExistException throwable) {
            // empty catch block
        }
    }

    @Test(dataProvider="topicDomainProvider", timeOut=60000L)
    public void testCreateConsumerForPartitionedTopicWhenEnableTopicAutoCreation(TopicDomain domain) throws PulsarAdminException, PulsarClientException {
        this.conf.setAllowAutoTopicCreation(true);
        String topic = domain.value() + "://public/default/testCreateConsumerForPartitionedTopicWhenEnableTopicAutoCreation";
        this.admin.topics().createPartitionedTopic(topic, 3);
        Assert.assertNotNull((Object)this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub-1").subscribe());
    }

    @Test(dataProvider="topicDomainProvider", timeOut=60000L)
    public void testCreateConsumerForNonPartitionedTopicWhenEnableTopicAutoCreation(TopicDomain domain) throws PulsarClientException {
        this.conf.setAllowAutoTopicCreation(true);
        String topic = domain.value() + "://public/default/testCreateConsumerForNonPartitionedTopicWhenEnableTopicAutoCreation";
        Assert.assertNotNull((Object)this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub-1").subscribe());
    }

    @Test(timeOut=60000L)
    public void testCreateConsumerForPartitionedTopicUpdateWhenDisableTopicAutoCreation() throws Exception {
        this.conf.setAllowAutoTopicCreation(false);
        String topic = "testCreateConsumerForPartitionedTopicUpdateWhenDisableTopicAutoCreation-" + System.currentTimeMillis();
        this.admin.topics().createPartitionedTopic(topic, 3);
        MultiTopicsConsumerImpl consumer = (MultiTopicsConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub-1").subscribe();
        Assert.assertNotNull((Object)consumer);
        Assert.assertEquals((int)consumer.getConsumers().size(), (int)3);
        consumer.close();
        this.admin.topics().updatePartitionedTopic(topic, 5);
        consumer = (MultiTopicsConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub-1").subscribe();
        Assert.assertNotNull((Object)consumer);
        Assert.assertEquals((int)consumer.getConsumers().size(), (int)5);
    }

    @DataProvider(name="restCreateMissedPartitions")
    public Object[] restCreateMissedPartitions() {
        return new Object[]{true, false};
    }

    @Test(timeOut=60000L, dataProvider="restCreateMissedPartitions")
    public void testCreateMissedPartitions(boolean useRestApi) throws PulsarAdminException, PulsarClientException, MetadataStoreException {
        this.conf.setAllowAutoTopicCreation(false);
        String topic = "testCreateMissedPartitions-useRestApi-" + useRestApi;
        String path = ZkAdminPaths.partitionedTopicPath((TopicName)TopicName.get((String)topic));
        int numPartitions = 3;
        this.pulsar.getPulsarResources().getNamespaceResources().getPartitionedTopicResources().create(path, (Object)new PartitionedTopicMetadata(numPartitions));
        Consumer consumer = null;
        try {
            consumer = (Consumer)this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub-1").subscribeAsync().get(3L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull(consumer);
        if (useRestApi) {
            this.admin.topics().createMissedPartitions(topic);
        } else {
            TopicName topicName = TopicName.get((String)topic);
            for (int i = 0; i < numPartitions; ++i) {
                this.admin.topics().createNonPartitionedTopic(topicName.getPartition(i).toString());
            }
        }
        consumer = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub-1").subscribe();
        Assert.assertNotNull((Object)consumer);
        Assert.assertTrue((boolean)(consumer instanceof MultiTopicsConsumerImpl));
        Assert.assertEquals((int)((MultiTopicsConsumerImpl)consumer).getConsumers().size(), (int)3);
    }
}

