/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;

public abstract class ProducerConsumerBase
extends MockedPulsarServiceBaseTest {
    protected String methodName;
    private static final Random random = new Random();

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod(Method m) throws Exception {
        this.methodName = m.getName();
    }

    protected void producerBaseSetup() throws Exception {
        this.admin.clusters().createCluster("test", new ClusterData(this.pulsar.getWebServiceAddress()));
        this.admin.tenants().createTenant("my-property", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("my-property/my-ns");
        this.admin.namespaces().setNamespaceReplicationClusters("my-property/my-ns", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("public", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("public/default");
        this.admin.namespaces().setNamespaceReplicationClusters("public/default", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    protected <T> void testMessageOrderAndDuplicates(Set<T> messagesReceived, T receivedMessage, T expectedMessage) {
        Assert.assertEquals(receivedMessage, expectedMessage, (String)("Received message " + receivedMessage + " did not match the expected message " + expectedMessage));
        Assert.assertTrue((boolean)messagesReceived.add(receivedMessage), (String)("Received duplicate message " + receivedMessage));
    }

    protected String newTopicName() {
        return "my-property/my-ns/topic-" + Long.toHexString(random.nextLong());
    }
}

