/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.TlsProducerConsumerBase;
import org.apache.pulsar.client.impl.auth.AuthenticationTls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class ProxyProtocolTest
extends TlsProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(ProxyProtocolTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSniProxyProtocol() throws Exception {
        String proxyUrl = this.pulsar.getBrokerServiceUrlTls();
        String brokerServiceUrl = "pulsar+ssl://unresolvable-address:6651";
        String topicName = "persistent://my-property/use/my-ns/my-topic1";
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(brokerServiceUrl).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").enableTls(true).allowTlsInsecureConnection(false).proxyServiceUrl(proxyUrl, ProxyProtocol.SNI).operationTimeout(1000, TimeUnit.MILLISECONDS);
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("tlsCertFile", "./src/test/resources/authentication/tls/client-cert.pem");
        authParams.put("tlsKeyFile", "./src/test/resources/authentication/tls/client-key.pem");
        clientBuilder.authentication(AuthenticationTls.class.getName(), authParams);
        PulsarClient pulsarClient = clientBuilder.build();
        try {
            pulsarClient.newProducer().topic(topicName).create();
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSniProxyProtocolWithInvalidProxyUrl() throws Exception {
        String brokerServiceUrl = "pulsar+ssl://1.1.1.1:6651";
        String proxyHost = "invalid-url";
        String proxyUrl = "pulsar+ssl://" + proxyHost + ":5555";
        String topicName = "persistent://my-property/use/my-ns/my-topic1";
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(brokerServiceUrl).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").enableTls(true).allowTlsInsecureConnection(false).proxyServiceUrl(proxyUrl, ProxyProtocol.SNI).operationTimeout(1000, TimeUnit.MILLISECONDS);
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("tlsCertFile", "./src/test/resources/authentication/tls/client-cert.pem");
        authParams.put("tlsKeyFile", "./src/test/resources/authentication/tls/client-key.pem");
        clientBuilder.authentication(AuthenticationTls.class.getName(), authParams);
        PulsarClient pulsarClient = clientBuilder.build();
        try {
            try {
                pulsarClient.newProducer().topic(topicName).create();
                Assert.fail((String)"should have failed due to invalid url");
            }
            catch (PulsarClientException e) {
                Assert.assertTrue((boolean)e.getMessage().contains(proxyHost));
            }
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSniProxyProtocolWithoutTls() throws Exception {
        String proxyUrl = this.pulsar.getBrokerServiceUrl();
        String brokerServiceUrl = "pulsar+ssl://1.1.1.1:6651";
        String topicName = "persistent://my-property/use/my-ns/my-topic1";
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(brokerServiceUrl).proxyServiceUrl(proxyUrl, ProxyProtocol.SNI).operationTimeout(1000, TimeUnit.MILLISECONDS);
        PulsarClient pulsarClient = clientBuilder.build();
        try {
            try {
                pulsarClient.newProducer().topic(topicName).create();
                Assert.fail((String)"should have failed due to non-tls url");
            }
            catch (PulsarClientException pulsarClientException) {
                // empty catch block
            }
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }
}

