/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import org.apache.pulsar.broker.authentication.AuthenticationProviderTls;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.JacksonConfigurator;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.impl.auth.AuthenticationKeyStoreTls;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.tls.NoopHostnameVerifier;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class AdminApiKeyStoreTlsAuthTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(AdminApiKeyStoreTlsAuthTest.class);
    protected final String BROKER_KEYSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/broker.keystore.jks";
    protected final String BROKER_TRUSTSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/broker.truststore.jks";
    protected final String BROKER_KEYSTORE_PW = "111111";
    protected final String BROKER_TRUSTSTORE_PW = "111111";
    protected final String CLIENT_KEYSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/client.keystore.jks";
    protected final String CLIENT_TRUSTSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/client.truststore.jks";
    protected final String CLIENT_KEYSTORE_PW = "111111";
    protected final String CLIENT_TRUSTSTORE_PW = "111111";
    protected final String CLIENT_KEYSTORE_CN = "clientuser";
    protected final String KEYSTORE_TYPE = "JKS";
    private final String clusterName = "test";
    Set<String> tlsProtocols = Sets.newConcurrentHashSet();

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setLoadBalancerEnabled(true);
        this.conf.setBrokerServicePortTls(Optional.of(0));
        this.conf.setWebServicePortTls(Optional.of(0));
        this.conf.setTlsEnabledWithKeyStore(true);
        this.conf.setTlsKeyStoreType("JKS");
        this.conf.setTlsKeyStore("./src/test/resources/authentication/keystoretls/broker.keystore.jks");
        this.conf.setTlsKeyStorePassword("111111");
        this.conf.setTlsTrustStoreType("JKS");
        this.conf.setTlsTrustStore("./src/test/resources/authentication/keystoretls/client.truststore.jks");
        this.conf.setTlsTrustStorePassword("111111");
        this.conf.setClusterName("test");
        this.conf.setTlsRequireTrustedClientCertOnConnect(true);
        this.tlsProtocols.add("TLSv1.3");
        this.tlsProtocols.add("TLSv1.2");
        this.conf.setTlsProtocols(this.tlsProtocols);
        this.conf.setSuperUserRoles((Set)Sets.newHashSet((Object[])new String[]{"clientuser"}));
        this.conf.setAuthenticationEnabled(true);
        this.conf.setAuthorizationEnabled(true);
        HashSet<String> providers = new HashSet<String>();
        providers.add(AuthenticationProviderTls.class.getName());
        this.conf.setAuthenticationProviders(providers);
        this.conf.setBrokerClientTlsEnabled(true);
        this.conf.setBrokerClientTlsEnabledWithKeyStore(true);
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("keyStoreType", "JKS");
        authParams.put("keyStorePath", "./src/test/resources/authentication/keystoretls/client.keystore.jks");
        authParams.put("keyStorePassword", "111111");
        this.conf.setBrokerClientAuthenticationPlugin(AuthenticationKeyStoreTls.class.getName());
        this.conf.setBrokerClientAuthenticationParameters(AuthenticationKeyStoreTls.mapToString(authParams));
        this.conf.setBrokerClientTlsTrustStore("./src/test/resources/authentication/keystoretls/broker.truststore.jks");
        this.conf.setBrokerClientTlsTrustStorePassword("111111");
        this.conf.setNumExecutorThreadPoolSize(5);
        super.init();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    WebTarget buildWebClient() throws Exception {
        ClientConfig httpConfig = new ClientConfig();
        httpConfig.property("jersey.config.client.followRedirects", (Object)true);
        httpConfig.property("jersey.config.client.async.threadPoolSize", (Object)8);
        httpConfig.register(MultiPartFeature.class);
        ClientBuilder clientBuilder = (ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().withConfig((Configuration)httpConfig).register(JacksonConfigurator.class)).register(JacksonFeature.class);
        SSLContext sslCtx = KeyStoreSSLContext.createClientSslContext((String)"JKS", (String)"./src/test/resources/authentication/keystoretls/client.keystore.jks", (String)"111111", (String)"JKS", (String)"./src/test/resources/authentication/keystoretls/broker.truststore.jks", (String)"111111");
        clientBuilder.sslContext(sslCtx).hostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Client client = clientBuilder.build();
        return client.target(this.brokerUrlTls.toString());
    }

    PulsarAdmin buildAdminClient() throws Exception {
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("keyStorePath", "./src/test/resources/authentication/keystoretls/client.keystore.jks");
        authParams.put("keyStorePassword", "111111");
        return PulsarAdmin.builder().serviceHttpUrl(this.brokerUrlTls.toString()).useKeyStoreTls(true).tlsTrustStorePath("./src/test/resources/authentication/keystoretls/broker.truststore.jks").tlsTrustStorePassword("111111").allowTlsInsecureConnection(false).authentication(AuthenticationKeyStoreTls.class.getName(), authParams).build();
    }

    @Test
    public void testSuperUserCanListTenants() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient();){
            admin.clusters().createCluster("test", new ClusterData(this.brokerUrl.toString()));
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"foobar"), (Set)ImmutableSet.of((Object)"test")));
            Assert.assertEquals((Collection)ImmutableSet.of((Object)"tenant1"), (Collection)admin.tenants().getTenants());
        }
    }

    @Test
    public void testSuperUserCantListNamespaces() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient();){
            admin.clusters().createCluster("test", new ClusterData(this.brokerUrl.toString()));
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"proxy"), (Set)ImmutableSet.of((Object)"test")));
            admin.namespaces().createNamespace("tenant1/ns1");
            Assert.assertTrue((boolean)admin.namespaces().getNamespaces("tenant1").contains("tenant1/ns1"));
        }
    }

    @Test
    public void testAuthorizedUserAsOriginalPrincipal() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient();){
            admin.clusters().createCluster("test", new ClusterData(this.brokerUrl.toString()));
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"proxy", (Object)"user1"), (Set)ImmutableSet.of((Object)"test")));
            admin.namespaces().createNamespace("tenant1/ns1");
        }
        WebTarget root = this.buildWebClient();
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"tenant1/ns1"), (Collection)((Collection)root.path("/admin/v2/namespaces").path("tenant1").request(new String[]{"application/json"}).header("X-Original-Principal", (Object)"user1").get((GenericType)new GenericType<List<String>>(){})));
    }

    @Test
    public void testPersistentList() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        try (PulsarAdmin admin = this.buildAdminClient();){
            admin.clusters().createCluster("test", new ClusterData(this.brokerUrl.toString()));
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"foobar"), (Set)ImmutableSet.of((Object)"test")));
            Assert.assertEquals((Collection)ImmutableSet.of((Object)"tenant1"), (Collection)admin.tenants().getTenants());
            admin.namespaces().createNamespace("tenant1/ns1");
            admin.topics().getList("tenant1/ns1");
        }
        catch (PulsarAdminException ex) {
            ex.printStackTrace();
            AssertJUnit.fail((String)"Should not have thrown an exception");
        }
    }
}

