/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class ConsumerConfigurationTest
extends MockedPulsarServiceBaseTest {
    private static String persistentTopic = "persistent://my-property/use/my-ns/persist";
    private static String nonPersistentTopic = "non-persistent://my-property/use/my-ns/nopersist";

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        this.admin.clusters().createCluster("use", new ClusterData(this.pulsar.getWebServiceAddress()));
        this.admin.tenants().createTenant("my-property", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
        this.admin.namespaces().createNamespace("my-property/use/my-ns");
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testReadCompactPersistentExclusive() throws Exception {
        this.pulsarClient.newConsumer().topic(new String[]{persistentTopic}).subscriptionName("sub1").readCompacted(true).subscriptionType(SubscriptionType.Exclusive).subscribe().close();
    }

    @Test
    public void testReadCompactPersistentFailover() throws Exception {
        this.pulsarClient.newConsumer().topic(new String[]{persistentTopic}).subscriptionName("sub1").readCompacted(true).subscriptionType(SubscriptionType.Failover).subscribe().close();
    }

    @Test(expectedExceptions={PulsarClientException.InvalidConfigurationException.class})
    public void testReadCompactPersistentShared() throws Exception {
        this.pulsarClient.newConsumer().topic(new String[]{persistentTopic}).subscriptionName("sub1").readCompacted(true).subscriptionType(SubscriptionType.Shared).subscribe().close();
    }

    @Test(expectedExceptions={PulsarClientException.InvalidConfigurationException.class})
    public void testReadCompactNonPersistentExclusive() throws Exception {
        this.pulsarClient.newConsumer().topic(new String[]{nonPersistentTopic}).subscriptionName("sub1").readCompacted(true).subscriptionType(SubscriptionType.Exclusive).subscribe().close();
    }
}

