/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.Collections;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.pulsar.broker.ManagedLedgerClientFactory;
import org.apache.pulsar.broker.service.BkEnsemblesTestBase;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"quarantine"})
public class SequenceIdWithErrorTest
extends BkEnsemblesTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckSequenceId() throws Exception {
        this.admin.namespaces().createNamespace("prop/my-test", Collections.singleton("usc"));
        String topicName = "prop/my-test/my-topic";
        int N = 10;
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).build();
        try {
            int i;
            Consumer consumer = client.newConsumer(Schema.STRING).topic(new String[]{topicName}).subscriptionName("sub").subscribe();
            NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(1);
            ManagedLedgerClientFactory clientFactory = new ManagedLedgerClientFactory();
            clientFactory.initialize(this.pulsar.getConfiguration(), (MetadataStore)this.pulsar.getLocalMetadataStore(), this.pulsar.getZkClient(), this.pulsar.getBookKeeperClientFactory(), (EventLoopGroup)eventLoopGroup);
            ManagedLedgerFactory mlFactory = clientFactory.getManagedLedgerFactory();
            ManagedLedger ml = mlFactory.open(TopicName.get((String)topicName).getPersistenceNamingEncoding());
            ml.close();
            clientFactory.close();
            Producer producer = client.newProducer(Schema.STRING).topic(topicName).create();
            for (i = 0; i < N; ++i) {
                producer.send((Object)("Hello-" + i));
            }
            for (i = 0; i < N; ++i) {
                Message msg = consumer.receive();
                Assert.assertEquals((String)((String)msg.getValue()), (String)("Hello-" + i));
                Assert.assertEquals((long)msg.getSequenceId(), (long)i);
                consumer.acknowledge(msg);
            }
            client.close();
            eventLoopGroup.shutdownGracefully().get();
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }
}

