/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class TopicFromMessageTest
extends ProducerConsumerBase {
    private static final long TEST_TIMEOUT = 90000L;
    private static final int BATCHING_MAX_MESSAGES_THRESHOLD = 2;

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test(timeOut=90000L)
    public void testSingleTopicConsumerNoBatchShortName() throws Exception {
        try (Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"topic1"}).subscriptionName("sub1").subscribe();
             Producer producer = this.pulsarClient.newProducer().topic("topic1").enableBatching(false).create();){
            producer.send((Object)"foobar".getBytes());
            Assert.assertEquals((String)consumer.receive().getTopicName(), (String)"persistent://public/default/topic1");
        }
    }

    @Test(timeOut=90000L)
    public void testSingleTopicConsumerNoBatchFullName() throws Exception {
        try (Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"my-property/my-ns/topic1"}).subscriptionName("sub1").subscribe();
             Producer producer = this.pulsarClient.newProducer().topic("my-property/my-ns/topic1").enableBatching(false).create();){
            producer.send((Object)"foobar".getBytes());
            Assert.assertEquals((String)consumer.receive().getTopicName(), (String)"persistent://my-property/my-ns/topic1");
        }
    }

    @Test(timeOut=90000L)
    public void testMultiTopicConsumerNoBatchShortName() throws Exception {
        try (Consumer consumer = this.pulsarClient.newConsumer().topics((List)Lists.newArrayList((Object[])new String[]{"topic1", "topic2"})).subscriptionName("sub1").subscribe();
             Producer producer1 = this.pulsarClient.newProducer().topic("topic1").enableBatching(false).create();
             Producer producer2 = this.pulsarClient.newProducer().topic("topic2").enableBatching(false).create();){
            producer1.send((Object)"foobar".getBytes());
            producer2.send((Object)"foobar".getBytes());
            Assert.assertEquals((String)consumer.receive().getTopicName(), (String)"persistent://public/default/topic1");
            Assert.assertEquals((String)consumer.receive().getTopicName(), (String)"persistent://public/default/topic2");
        }
    }

    @Test(timeOut=90000L)
    public void testSingleTopicConsumerBatchShortName() throws Exception {
        try (Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"topic1"}).subscriptionName("sub1").subscribe();
             Producer producer = this.pulsarClient.newProducer().topic("topic1").enableBatching(true).batchingMaxMessages(2).create();){
            producer.send((Object)"foobar".getBytes());
            Assert.assertEquals((String)consumer.receive().getTopicName(), (String)"persistent://public/default/topic1");
        }
    }

    @Test(timeOut=90000L)
    public void testMultiTopicConsumerBatchShortName() throws Exception {
        try (Consumer consumer = this.pulsarClient.newConsumer().topics((List)Lists.newArrayList((Object[])new String[]{"topic1", "topic2"})).subscriptionName("sub1").subscribe();
             Producer producer1 = this.pulsarClient.newProducer().topic("topic1").enableBatching(true).batchingMaxMessages(2).create();
             Producer producer2 = this.pulsarClient.newProducer().topic("topic2").enableBatching(true).batchingMaxMessages(2).create();){
            producer1.send((Object)"foobar".getBytes());
            producer2.send((Object)"foobar".getBytes());
            Assert.assertEquals((String)consumer.receive().getTopicName(), (String)"persistent://public/default/topic1");
            Assert.assertEquals((String)consumer.receive().getTopicName(), (String)"persistent://public/default/topic2");
        }
    }
}

