/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class ZeroQueueSizeTest
extends BrokerTestBase {
    private static final Logger log = LoggerFactory.getLogger(ZeroQueueSizeTest.class);
    private final int totalMessages = 10;

    @Override
    @BeforeClass
    public void setup() throws Exception {
        this.baseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        this.internalCleanup();
    }

    @Test
    public void validQueueSizeConfig() {
        this.pulsarClient.newConsumer().receiverQueueSize(0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void InvalidQueueSizeConfig() {
        this.pulsarClient.newConsumer().receiverQueueSize(-1);
    }

    @Test(expectedExceptions={PulsarClientException.InvalidConfigurationException.class})
    public void zeroQueueSizeReceiveAsyncInCompatibility() throws PulsarClientException {
        String key = "zeroQueueSizeReceiveAsyncInCompatibility";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscribe();
        consumer.receive(10, TimeUnit.SECONDS);
    }

    @Test(expectedExceptions={PulsarClientException.class})
    public void zeroQueueSizePartitionedTopicInCompatibility() throws PulsarClientException, PulsarAdminException {
        String key = "zeroQueueSizePartitionedTopicInCompatibility";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        int numberOfPartitions = 3;
        this.admin.topics().createPartitionedTopic(topicName, numberOfPartitions);
        this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscribe();
    }

    @Test
    public void zeroQueueSizeNormalConsumer() throws PulsarClientException {
        String key = "nonZeroQueueSizeNormalConsumer";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        String messagePredicate = "my-message-" + key + "-";
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        ConsumerImpl consumer = (ConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscribe();
        for (int i = 0; i < 10; ++i) {
            String message = messagePredicate + i;
            log.info("Producer produced: " + message);
            producer.send((Object)message.getBytes());
        }
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((int)consumer.numMessagesInQueue(), (int)0);
            Message message = consumer.receive();
            Assert.assertEquals((String)new String(message.getData()), (String)(messagePredicate + i));
            Assert.assertEquals((int)consumer.numMessagesInQueue(), (int)0);
            log.info("Consumer received : " + new String(message.getData()));
        }
    }

    @Test
    public void zeroQueueSizeConsumerListener() throws Exception {
        int i;
        String key = "zeroQueueSizeConsumerListener";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        String messagePredicate = "my-message-" + key + "-";
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        ArrayList messages = Lists.newArrayList();
        CountDownLatch latch = new CountDownLatch(10);
        ConsumerImpl consumer = (ConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).messageListener((MessageListener & Serializable)(cons, msg) -> {
            Assert.assertEquals((int)((ConsumerImpl)cons).numMessagesInQueue(), (int)0);
            List list = messages;
            synchronized (list) {
                messages.add(msg);
            }
            log.info("Consumer received: " + new String(msg.getData()));
            latch.countDown();
        }).subscribe();
        for (i = 0; i < 10; ++i) {
            String message = messagePredicate + i;
            log.info("Producer produced: " + message);
            producer.send((Object)message.getBytes());
        }
        latch.await();
        Assert.assertEquals((int)consumer.numMessagesInQueue(), (int)0);
        Assert.assertEquals((int)messages.size(), (int)10);
        for (i = 0; i < messages.size(); ++i) {
            Assert.assertEquals((String)new String(((Message)messages.get(i)).getData()), (String)(messagePredicate + i));
        }
    }

    @Test
    public void zeroQueueSizeSharedSubscription() throws PulsarClientException {
        int i;
        String key = "zeroQueueSizeSharedSubscription";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        String messagePredicate = "my-message-" + key + "-";
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        int numOfSubscribers = 4;
        ConsumerImpl[] consumers = new ConsumerImpl[numOfSubscribers];
        for (i = 0; i < numOfSubscribers; ++i) {
            consumers[i] = (ConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscriptionType(SubscriptionType.Shared).subscribe();
        }
        for (i = 0; i < 10; ++i) {
            String message = messagePredicate + i;
            producer.send((Object)message.getBytes());
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            Assert.assertEquals((int)consumers[i2 % numOfSubscribers].numMessagesInQueue(), (int)0);
            Message message = consumers[i2 % numOfSubscribers].receive();
            Assert.assertEquals((String)new String(message.getData()), (String)(messagePredicate + i2));
            Assert.assertEquals((int)consumers[i2 % numOfSubscribers].numMessagesInQueue(), (int)0);
            log.info("Consumer received : " + new String(message.getData()));
        }
    }

    @Test
    public void zeroQueueSizeFailoverSubscription() throws PulsarClientException {
        int i;
        String key = "zeroQueueSizeFailoverSubscription";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        String messagePredicate = "my-message-" + key + "-";
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        ConsumerImpl consumer1 = (ConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscriptionType(SubscriptionType.Failover).consumerName("consumer-1").subscribe();
        ConsumerImpl consumer2 = (ConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscriptionType(SubscriptionType.Failover).consumerName("consumer-2").subscribe();
        for (int i2 = 0; i2 < 10; ++i2) {
            String message = messagePredicate + i2;
            producer.send((Object)message.getBytes());
        }
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((int)consumer1.numMessagesInQueue(), (int)0);
            Message message = consumer1.receive();
            Assert.assertEquals((String)new String(message.getData()), (String)(messagePredicate + i));
            Assert.assertEquals((int)consumer1.numMessagesInQueue(), (int)0);
            log.info("Consumer received : " + new String(message.getData()));
        }
        consumer1.redeliverUnacknowledgedMessages();
        consumer1.close();
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((int)consumer2.numMessagesInQueue(), (int)0);
            Message message = consumer2.receive();
            Assert.assertEquals((String)new String(message.getData()), (String)(messagePredicate + i));
            Assert.assertEquals((int)consumer2.numMessagesInQueue(), (int)0);
            log.info("Consumer received : " + new String(message.getData()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedZeroQueueSizeBatchMessage() throws PulsarClientException {
        int batchMessageDelayMs = 100;
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns-abc/topic1"}).subscriptionName("my-subscriber-name").subscriptionType(SubscriptionType.Shared).receiverQueueSize(0).subscribe();
        ProducerBuilder producerBuilder = this.pulsarClient.newProducer().topic("persistent://prop-xyz/use/ns-abc/topic1").messageRoutingMode(MessageRoutingMode.SinglePartition);
        if (batchMessageDelayMs != 0) {
            producerBuilder.enableBatching(true).batchingMaxPublishDelay((long)batchMessageDelayMs, TimeUnit.MILLISECONDS).batchingMaxMessages(5);
        } else {
            producerBuilder.enableBatching(false);
        }
        Producer producer = producerBuilder.create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
        }
        try {
            consumer.receiveAsync().handle((ok, e) -> {
                if (e == null) {
                    Assert.fail();
                }
                return null;
            });
        }
        finally {
            consumer.close();
        }
    }

    @Test
    public void testZeroQueueSizeMessageRedelivery() throws PulsarClientException {
        String topic = "persistent://prop/ns-abc/testZeroQueueSizeMessageRedelivery";
        Consumer consumer = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{"persistent://prop/ns-abc/testZeroQueueSizeMessageRedelivery"}).receiverQueueSize(0).subscriptionName("sub").subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).subscribe();
        int messages = 10;
        Producer producer = this.pulsarClient.newProducer(Schema.INT32).topic("persistent://prop/ns-abc/testZeroQueueSizeMessageRedelivery").enableBatching(false).create();
        for (int i = 0; i < 10; ++i) {
            producer.send((Object)i);
        }
        HashSet<Object> receivedMessages = new HashSet<Object>();
        for (int i = 0; i < 20; ++i) {
            receivedMessages.add(consumer.receive().getValue());
        }
        Assert.assertEquals((int)receivedMessages.size(), (int)10);
        consumer.close();
        producer.close();
    }

    @Test
    public void testZeroQueueSizeMessageRedeliveryForListener() throws Exception {
        String topic = "persistent://prop/ns-abc/testZeroQueueSizeMessageRedeliveryForListener";
        int messages = 10;
        CountDownLatch latch = new CountDownLatch(20);
        HashSet receivedMessages = new HashSet();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{"persistent://prop/ns-abc/testZeroQueueSizeMessageRedeliveryForListener"}).receiverQueueSize(0).subscriptionName("sub").subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).messageListener((MessageListener & Serializable)(c, msg) -> {
            try {
                receivedMessages.add(msg.getValue());
            }
            finally {
                latch.countDown();
            }
        }).subscribe();
        Producer producer = this.pulsarClient.newProducer(Schema.INT32).topic("persistent://prop/ns-abc/testZeroQueueSizeMessageRedeliveryForListener").enableBatching(false).create();
        for (int i = 0; i < 10; ++i) {
            producer.send((Object)i);
        }
        latch.await();
        Assert.assertEquals((int)receivedMessages.size(), (int)10);
        consumer.close();
        producer.close();
    }

    @Test
    public void testZeroQueueSizeMessageRedeliveryForAsyncReceive() throws PulsarClientException, ExecutionException, InterruptedException {
        String topic = "persistent://prop/ns-abc/testZeroQueueSizeMessageRedeliveryForAsyncReceive";
        Consumer consumer = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{"persistent://prop/ns-abc/testZeroQueueSizeMessageRedeliveryForAsyncReceive"}).receiverQueueSize(0).subscriptionName("sub").subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).subscribe();
        int messages = 10;
        Producer producer = this.pulsarClient.newProducer(Schema.INT32).topic("persistent://prop/ns-abc/testZeroQueueSizeMessageRedeliveryForAsyncReceive").enableBatching(false).create();
        for (int i = 0; i < 10; ++i) {
            producer.send((Object)i);
        }
        HashSet<Object> receivedMessages = new HashSet<Object>();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(20);
        for (int i = 0; i < 20; ++i) {
            futures.add(consumer.receiveAsync());
        }
        for (CompletableFuture future : futures) {
            receivedMessages.add(((Message)future.get()).getValue());
        }
        Assert.assertEquals((int)receivedMessages.size(), (int)10);
        consumer.close();
        producer.close();
    }

    @Test(timeOut=30000L)
    public void testPauseAndResume() throws Exception {
        String topicName = "persistent://prop/ns-abc/zero-queue-pause-and-resume";
        String subName = "sub";
        AtomicReference<CountDownLatch> latch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        AtomicInteger received = new AtomicInteger();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/zero-queue-pause-and-resume"}).subscriptionName("sub").receiverQueueSize(0).messageListener((MessageListener & Serializable)(c1, msg) -> {
            Assert.assertNotNull((Object)msg, (String)"Message cannot be null");
            c1.acknowledgeAsync(msg);
            received.incrementAndGet();
            ((CountDownLatch)latch.get()).countDown();
        }).subscribe();
        consumer.pause();
        Producer producer = this.pulsarClient.newProducer().topic("persistent://prop/ns-abc/zero-queue-pause-and-resume").enableBatching(false).create();
        for (int i = 0; i < 2; ++i) {
            producer.send((Object)("my-message-" + i).getBytes());
        }
        Assert.assertTrue((boolean)latch.get().await(2L, TimeUnit.SECONDS), (String)"Timed out waiting for message listener acks");
        Thread.sleep(2000L);
        Assert.assertEquals((int)received.intValue(), (int)1, (String)"Consumer received messages while paused");
        latch.set(new CountDownLatch(1));
        consumer.resume();
        Assert.assertTrue((boolean)latch.get().await(2L, TimeUnit.SECONDS), (String)"Timed out waiting for message listener acks");
        consumer.unsubscribe();
        producer.close();
    }

    @Test(timeOut=30000L)
    public void testPauseAndResumeWithUnloading() throws Exception {
        String topicName = "persistent://prop/ns-abc/zero-queue-pause-and-resume-with-unloading";
        String subName = "sub";
        AtomicReference<CountDownLatch> latch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        AtomicInteger received = new AtomicInteger();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/zero-queue-pause-and-resume-with-unloading"}).subscriptionName("sub").receiverQueueSize(0).messageListener((MessageListener & Serializable)(c1, msg) -> {
            Assert.assertNotNull((Object)msg, (String)"Message cannot be null");
            c1.acknowledgeAsync(msg);
            received.incrementAndGet();
            ((CountDownLatch)latch.get()).countDown();
        }).subscribe();
        consumer.pause();
        Producer producer = this.pulsarClient.newProducer().topic("persistent://prop/ns-abc/zero-queue-pause-and-resume-with-unloading").enableBatching(false).create();
        for (int i = 0; i < 2; ++i) {
            producer.send((Object)("my-message-" + i).getBytes());
        }
        Assert.assertTrue((boolean)latch.get().await(2L, TimeUnit.SECONDS), (String)"Timed out waiting for message listener acks");
        this.admin.topics().unload("persistent://prop/ns-abc/zero-queue-pause-and-resume-with-unloading");
        Thread.sleep(2000L);
        Assert.assertEquals((int)received.intValue(), (int)1, (String)"Consumer received messages while paused");
        latch.set(new CountDownLatch(1));
        consumer.resume();
        Assert.assertTrue((boolean)latch.get().await(2L, TimeUnit.SECONDS), (String)"Timed out waiting for message listener acks");
        consumer.unsubscribe();
        producer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L)
    public void testPauseAndResumeNoReconnection() throws Exception {
        int i;
        String topicName = "persistent://prop/ns-abc/zero-queue-pause-and-resume-no-reconnection";
        String subName = "sub";
        Object object = new Object();
        AtomicBoolean running = new AtomicBoolean(false);
        List receivedMessages = Collections.synchronizedList(new ArrayList());
        Consumer consumer = this.pulsarClient.newConsumer(Schema.INT32).topic(new String[]{"persistent://prop/ns-abc/zero-queue-pause-and-resume-no-reconnection"}).subscriptionName("sub").receiverQueueSize(0).messageListener((MessageListener & Serializable)(consumer1, msg) -> {
            Assert.assertNotNull((Object)msg, (String)"Message cannot be null");
            receivedMessages.add(msg.getValue());
            try {
                consumer1.acknowledge(msg);
            }
            catch (PulsarClientException pulsarClientException) {
                // empty catch block
            }
            Object object2 = object;
            synchronized (object2) {
                running.set(false);
                object.notifyAll();
            }
        }).subscribe();
        Producer producer = this.pulsarClient.newProducer(Schema.INT32).topic("persistent://prop/ns-abc/zero-queue-pause-and-resume-no-reconnection").enableBatching(false).create();
        int numMessages = 100;
        for (i = 0; i < 100; ++i) {
            consumer.resume();
            producer.newMessage().value((Object)i).sendAsync();
            Object object2 = object;
            synchronized (object2) {
                running.set(true);
                while (running.get()) {
                    object.wait();
                }
            }
            consumer.pause();
        }
        log.info("Received messages: {}", receivedMessages);
        Assert.assertEquals((int)receivedMessages.size(), (int)100);
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((int)((Integer)receivedMessages.get(i)), (int)i);
        }
    }
}

