/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.discovery.service.server.ServerManager;
import org.apache.pulsar.discovery.service.server.ServiceConfig;
import org.apache.pulsar.discovery.service.web.DiscoveryServiceServlet;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.logging.LoggingFeature;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-discovery"})
public class DiscoveryServiceWebTest
extends ProducerConsumerBase {
    private final Client client = ClientBuilder.newClient((Configuration)new ClientConfig().register(LoggingFeature.class));
    private static final Map<String, MetadataStoreExtended> metadataStoreInstanceCache = Maps.newConcurrentMap();
    private ServerManager server;

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
        this.conf.setAuthorizationEnabled(true);
        this.conf.setAuthenticationEnabled(true);
        ServiceConfig config = new ServiceConfig();
        config.setWebServicePort(Optional.of(0));
        this.server = new ServerManager(config);
        TreeMap<String, String> params = new TreeMap<String, String>();
        String zkServerUrl = "mockZkServerUrl";
        metadataStoreInstanceCache.put(zkServerUrl, this.pulsar.createLocalMetadataStore());
        params.put("zookeeperServers", zkServerUrl);
        this.server.addServlet("/", DiscoveryServiceServletTest.class, params);
        this.server.start();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
        this.server.stop();
        metadataStoreInstanceCache.clear();
    }

    @Test
    public void testRedirectUrlWithServerStarted() throws Exception {
        String serviceUrl = this.server.getServiceUri().toString();
        String putRequestUrl = serviceUrl + "admin/v2/namespaces/p1/n1";
        String postRequestUrl = serviceUrl + "admin/v2/namespaces/p1/n1/replication";
        String getRequestUrl = serviceUrl + "admin/v2/namespaces/p1";
        Assert.assertEquals((String)this.hitBrokerService("POST", postRequestUrl, Lists.newArrayList((Object[])new String[]{"use"})), (String)"Need to authenticate to perform the request");
        Assert.assertEquals((String)this.hitBrokerService("PUT", putRequestUrl, new BundlesData(1)), (String)"Need to authenticate to perform the request");
        Assert.assertEquals((String)this.hitBrokerService("GET", getRequestUrl, null), (String)"Need to authenticate to perform the request");
    }

    public String hitBrokerService(String method, String url, Object data) throws JsonParseException {
        Response response = null;
        try {
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
            if ("PUT".equals(method)) {
                response = invocationBuilder.put(Entity.entity((Object)data, (String)"application/json"));
            } else if ("GET".equals(method)) {
                response = invocationBuilder.get();
            } else if ("POST".equals(method)) {
                response = invocationBuilder.post(Entity.entity((Object)data, (String)"application/json"));
            } else {
                Assert.fail((String)"Unsupported http method");
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
        JsonObject jsonObject = (JsonObject)new Gson().fromJson((String)response.readEntity(String.class), JsonObject.class);
        return jsonObject.get("reason").getAsString();
    }

    public static class DiscoveryServiceServletTest
    extends DiscoveryServiceServlet {
        public MetadataStoreExtended createLocalMetadataStore(String zookeeperServers, int operationimeoutMs) throws MetadataStoreException {
            return (MetadataStoreExtended)metadataStoreInstanceCache.get(zookeeperServers);
        }
    }
}

