/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.jsonwebtoken.SignatureAlgorithm;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authentication.AuthenticationProviderToken;
import org.apache.pulsar.broker.authentication.utils.AuthTokenUtils;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.client.admin.BrokerStats;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.auth.AuthenticationToken;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.runtime.thread.ThreadRuntimeFactory;
import org.apache.pulsar.functions.runtime.thread.ThreadRuntimeFactoryConfig;
import org.apache.pulsar.functions.worker.PulsarFunctionLocalRunTest;
import org.apache.pulsar.functions.worker.PulsarFunctionTestTemporaryDirectory;
import org.apache.pulsar.functions.worker.PulsarWorkerService;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.scheduler.RoundRobinScheduler;
import org.apache.pulsar.io.PulsarFunctionE2ETest;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functions-worker"})
public class PulsarFunctionE2ESecurityTest {
    LocalBookkeeperEnsemble bkEnsemble;
    ServiceConfiguration config;
    WorkerConfig workerConfig;
    URL brokerWebServiceUrl;
    PulsarService pulsar;
    PulsarAdmin superUserAdmin;
    PulsarClient pulsarClient;
    BrokerStats brokerStatsClient;
    PulsarWorkerService functionsWorkerService;
    final String TENANT = "external-repl-prop";
    final String TENANT2 = "tenant2";
    final String NAMESPACE = "test-ns";
    String pulsarFunctionsNamespace = "external-repl-prop/pulsar-function-admin";
    String primaryHost;
    String workerId;
    private SecretKey secretKey;
    private static final String SUBJECT = "my-test-subject";
    private static final String ADMIN_SUBJECT = "superUser";
    private static final String ANONYMOUS_ROLE = "anonymousUser";
    private static final Logger log = LoggerFactory.getLogger(PulsarFunctionE2ETest.class);
    private String adminToken;
    private String brokerServiceUrl;
    private PulsarFunctionTestTemporaryDirectory tempDirectory;

    @DataProvider(name="validRoleName")
    public Object[][] validRoleName() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}};
    }

    @BeforeMethod
    void setup(Method method) throws Exception {
        log.info("--- Setting up method {} ---", (Object)method.getName());
        this.bkEnsemble = new LocalBookkeeperEnsemble(3, 0, () -> 0);
        this.bkEnsemble.start();
        this.config = (ServiceConfiguration)Mockito.spy((Object)new ServiceConfiguration());
        this.config.setClusterName("use");
        HashSet superUsers = Sets.newHashSet((Object[])new String[]{ADMIN_SUBJECT});
        this.config.setSuperUserRoles((Set)superUsers);
        this.config.setWebServicePort(Optional.of(0));
        this.config.setZookeeperServers("127.0.0.1:" + this.bkEnsemble.getZookeeperPort());
        this.config.setBrokerShutdownTimeoutMs(0L);
        this.config.setBrokerServicePort(Optional.of(0));
        this.config.setLoadManagerClassName(SimpleLoadManagerImpl.class.getName());
        this.config.setAdvertisedAddress("localhost");
        this.config.setAllowAutoTopicCreationType("non-partitioned");
        HashSet<String> providers = new HashSet<String>();
        providers.add(AuthenticationProviderToken.class.getName());
        this.config.setAuthenticationEnabled(true);
        this.config.setAuthenticationProviders(providers);
        this.config.setAuthorizationEnabled(true);
        this.config.setAuthorizationProvider(PulsarAuthorizationProvider.class.getName());
        this.config.setAnonymousUserRole(ANONYMOUS_ROLE);
        this.secretKey = AuthTokenUtils.createSecretKey((SignatureAlgorithm)SignatureAlgorithm.HS256);
        Properties properties = new Properties();
        properties.setProperty("tokenSecretKey", AuthTokenUtils.encodeKeyBase64((Key)this.secretKey));
        this.config.setProperties(properties);
        this.adminToken = AuthTokenUtils.createToken((Key)this.secretKey, (String)ADMIN_SUBJECT, Optional.empty());
        this.config.setBrokerClientAuthenticationPlugin(AuthenticationToken.class.getName());
        this.config.setBrokerClientAuthenticationParameters("token:" + this.adminToken);
        this.functionsWorkerService = this.createPulsarFunctionWorker(this.config);
        Optional<PulsarWorkerService> functionWorkerService = Optional.of(this.functionsWorkerService);
        this.pulsar = new PulsarService(this.config, this.workerConfig, functionWorkerService, exitCode -> {});
        this.pulsar.start();
        this.brokerServiceUrl = this.pulsar.getWebServiceAddress();
        this.brokerWebServiceUrl = new URL(this.brokerServiceUrl);
        AuthenticationToken authToken = new AuthenticationToken();
        authToken.configure("token:" + this.adminToken);
        this.superUserAdmin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerServiceUrl).authentication((Authentication)authToken).build());
        this.brokerStatsClient = this.superUserAdmin.brokerStats();
        this.primaryHost = this.pulsar.getWebServiceAddress();
        ClusterData clusterData = new ClusterData(this.brokerWebServiceUrl.toString());
        this.superUserAdmin.clusters().updateCluster(this.config.getClusterName(), clusterData);
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(this.workerConfig.getPulsarServiceUrl()).operationTimeout(1000, TimeUnit.MILLISECONDS);
        if (StringUtils.isNotBlank((CharSequence)this.workerConfig.getBrokerClientAuthenticationPlugin()) && StringUtils.isNotBlank((CharSequence)this.workerConfig.getBrokerClientAuthenticationParameters())) {
            clientBuilder.authentication(this.workerConfig.getBrokerClientAuthenticationPlugin(), this.workerConfig.getBrokerClientAuthenticationParameters());
        }
        if (this.pulsarClient != null) {
            this.pulsarClient.close();
        }
        this.pulsarClient = clientBuilder.build();
        TenantInfo propAdmin = new TenantInfo();
        propAdmin.getAdminRoles().add(ADMIN_SUBJECT);
        propAdmin.setAllowedClusters((Set)Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"use"})));
        this.superUserAdmin.tenants().updateTenant("external-repl-prop", propAdmin);
        String replNamespace = "external-repl-prop/test-ns";
        this.superUserAdmin.namespaces().createNamespace("external-repl-prop/test-ns");
        HashSet clusters = Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"use"}));
        this.superUserAdmin.namespaces().setNamespaceReplicationClusters("external-repl-prop/test-ns", (Set)clusters);
        propAdmin = new TenantInfo();
        propAdmin.setAllowedClusters((Set)Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"use"})));
        this.superUserAdmin.tenants().createTenant("tenant2", propAdmin);
        this.superUserAdmin.namespaces().createNamespace("tenant2/test-ns");
        while (!this.functionsWorkerService.getLeaderService().isLeader()) {
            Thread.sleep(1000L);
        }
    }

    @AfterMethod(alwaysRun=true)
    void shutdown() throws Exception {
        try {
            log.info("--- Shutting down ---");
            this.pulsarClient.close();
            this.superUserAdmin.close();
            this.functionsWorkerService.stop();
            this.pulsar.close();
            this.bkEnsemble.stop();
        }
        finally {
            if (this.tempDirectory != null) {
                this.tempDirectory.delete();
            }
        }
    }

    private PulsarWorkerService createPulsarFunctionWorker(ServiceConfiguration config) {
        System.setProperty("pulsar.functions.java.instance.jar", FutureUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        this.workerConfig = new WorkerConfig();
        this.tempDirectory = PulsarFunctionTestTemporaryDirectory.create(this.getClass().getSimpleName());
        this.tempDirectory.useTemporaryDirectoriesForWorkerConfig(this.workerConfig);
        this.workerConfig.setPulsarFunctionsNamespace(this.pulsarFunctionsNamespace);
        this.workerConfig.setSchedulerClassName(RoundRobinScheduler.class.getName());
        this.workerConfig.setFunctionRuntimeFactoryClassName(ThreadRuntimeFactory.class.getName());
        this.workerConfig.setFunctionRuntimeFactoryConfigs((Map)ObjectMapperFactory.getThreadLocal().convertValue((Object)new ThreadRuntimeFactoryConfig().setThreadGroupName("use"), Map.class));
        this.workerConfig.setPulsarServiceUrl("pulsar://127.0.0.1:" + config.getBrokerServicePort().get());
        this.workerConfig.setPulsarWebServiceUrl("http://127.0.0.1:" + config.getWebServicePort().get());
        this.workerConfig.setFailureCheckFreqMs(100L);
        this.workerConfig.setNumFunctionPackageReplicas(1);
        this.workerConfig.setClusterCoordinationTopicName("coordinate");
        this.workerConfig.setFunctionAssignmentTopicName("assignment");
        this.workerConfig.setFunctionMetadataTopicName("metadata");
        this.workerConfig.setInstanceLivenessCheckFreqMs(100L);
        this.workerConfig.setWorkerPort(Integer.valueOf(0));
        this.workerConfig.setPulsarFunctionsCluster(config.getClusterName());
        String hostname = ServiceConfigurationUtils.getDefaultOrConfiguredAddress((String)config.getAdvertisedAddress());
        this.workerId = "c-" + config.getClusterName() + "-fw-" + hostname + "-" + this.workerConfig.getWorkerPort();
        this.workerConfig.setWorkerHostname(hostname);
        this.workerConfig.setWorkerId(this.workerId);
        this.workerConfig.setBrokerClientAuthenticationPlugin(AuthenticationToken.class.getName());
        this.workerConfig.setBrokerClientAuthenticationParameters(String.format("token:%s", this.adminToken));
        this.workerConfig.setAuthenticationEnabled(config.isAuthenticationEnabled());
        this.workerConfig.setAuthenticationProviders(config.getAuthenticationProviders());
        this.workerConfig.setAuthorizationEnabled(config.isAuthorizationEnabled());
        this.workerConfig.setAuthorizationProvider(config.getAuthorizationProvider());
        PulsarWorkerService workerService = new PulsarWorkerService();
        workerService.init(this.workerConfig, null, false);
        return workerService;
    }

    protected static FunctionConfig createFunctionConfig(String tenant, String namespace, String functionName, String sourceTopic, String sinkTopic, String subscriptionName) {
        FunctionConfig functionConfig = new FunctionConfig();
        functionConfig.setTenant(tenant);
        functionConfig.setNamespace(namespace);
        functionConfig.setName(functionName);
        functionConfig.setParallelism(Integer.valueOf(1));
        functionConfig.setProcessingGuarantees(FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE);
        functionConfig.setSubName(subscriptionName);
        functionConfig.setInputs(Collections.singleton(sourceTopic));
        functionConfig.setAutoAck(Boolean.valueOf(true));
        functionConfig.setClassName("org.apache.pulsar.functions.api.examples.ExclamationFunction");
        functionConfig.setRuntime(FunctionConfig.Runtime.JAVA);
        functionConfig.setOutput(sinkTopic);
        functionConfig.setCleanupSubscription(Boolean.valueOf(true));
        return functionConfig;
    }

    @Test
    public void testAuthorizationWithAnonymousUser() throws Exception {
        String replNamespace = "external-repl-prop/test-ns";
        String sourceTopic = "persistent://external-repl-prop/test-ns/my-topic1";
        String sinkTopic = "persistent://external-repl-prop/test-ns/output";
        String propertyKey = "key";
        String propertyValue = "value";
        String functionName = "PulsarFunction-test";
        String subscriptionName = "test-sub";
        try (PulsarAdmin admin1 = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerServiceUrl).build());){
            String jarFilePathUrl = PulsarFunctionLocalRunTest.getPulsarApiExamplesJar().toURI().toString();
            FunctionConfig functionConfig = PulsarFunctionE2ESecurityTest.createFunctionConfig("external-repl-prop", "test-ns", "PulsarFunction-test", "persistent://external-repl-prop/test-ns/my-topic1", "persistent://external-repl-prop/test-ns/output", "test-sub");
            FunctionConfig functionConfig2 = PulsarFunctionE2ESecurityTest.createFunctionConfig("tenant2", "test-ns", "PulsarFunction-test", "persistent://external-repl-prop/test-ns/my-topic1", "persistent://external-repl-prop/test-ns/output", "test-sub");
            try {
                admin1.functions().createFunctionWithUrl(functionConfig, jarFilePathUrl);
                Assert.fail((String)"client admin shouldn't have permissions to create function");
            }
            catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                // empty catch block
            }
            HashSet<AuthAction> actions = new HashSet<AuthAction>();
            actions.add(AuthAction.functions);
            actions.add(AuthAction.produce);
            actions.add(AuthAction.consume);
            this.superUserAdmin.namespaces().grantPermissionOnNamespace("external-repl-prop/test-ns", ANONYMOUS_ROLE, actions);
            admin1.functions().createFunctionWithUrl(functionConfig, jarFilePathUrl);
            try {
                admin1.functions().createFunctionWithUrl(functionConfig2, jarFilePathUrl);
                Assert.fail((String)"client admin shouldn't have permissions to create function");
            }
            catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    return admin1.functions().getFunctionStatus("external-repl-prop", "test-ns", "PulsarFunction-test").getNumRunning() == 1 && admin1.topics().getStats((String)"persistent://external-repl-prop/test-ns/my-topic1").subscriptions.size() == 1;
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 50, 150L));
            Assert.assertEquals((int)admin1.topics().getStats((String)"persistent://external-repl-prop/test-ns/my-topic1").subscriptions.size(), (int)1);
            try (Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic("persistent://external-repl-prop/test-ns/my-topic1").create();
                 Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{"persistent://external-repl-prop/test-ns/output"}).subscriptionName("sub").subscribe();){
                int totalMsgs = 5;
                for (int i = 0; i < totalMsgs; ++i) {
                    String data = "my-message-" + i;
                    producer.newMessage().property("key", "value").value((Object)data).send();
                }
                MockedPulsarServiceBaseTest.retryStrategically(test -> {
                    try {
                        SubscriptionStats subStats = (SubscriptionStats)admin1.topics().getStats((String)"persistent://external-repl-prop/test-ns/my-topic1").subscriptions.get("test-sub");
                        return subStats.unackedMessages == 0L;
                    }
                    catch (PulsarAdminException e) {
                        return false;
                    }
                }, 50, 150L);
                Message msg = consumer.receive(5, TimeUnit.SECONDS);
                String receivedPropertyValue = msg.getProperty("key");
                Assert.assertEquals((String)"value", (String)receivedPropertyValue);
                Assert.assertNotEquals((Object)((SubscriptionStats)admin1.topics().getStats((String)"persistent://external-repl-prop/test-ns/my-topic1").subscriptions.values().iterator().next()).unackedMessages, (Object)totalMsgs);
                functionConfig.setParallelism(Integer.valueOf(2));
                functionConfig2.setParallelism(Integer.valueOf(2));
                try {
                    admin1.functions().updateFunctionWithUrl(functionConfig2, jarFilePathUrl);
                    Assert.fail((String)"client admin shouldn't have permissions to update function");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().updateFunctionWithUrl(functionConfig, jarFilePathUrl);
                Assert.assertTrue((boolean)MockedPulsarServiceBaseTest.retryStrategically(test -> {
                    try {
                        return admin1.functions().getFunctionStatus("external-repl-prop", "test-ns", "PulsarFunction-test").getNumRunning() == 2;
                    }
                    catch (PulsarAdminException e) {
                        return false;
                    }
                }, 50, 150L));
                try {
                    admin1.functions().getFunction("tenant2", "test-ns", "PulsarFunction-test");
                    Assert.fail((String)"client admin shouldn't have permissions to get function");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().getFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                try {
                    admin1.functions().getFunctionStatus("tenant2", "test-ns", "PulsarFunction-test", 0);
                    Assert.fail((String)"client admin shouldn't have permissions to get function status");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().getFunctionStatus("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
                try {
                    admin1.functions().getFunctionStatus("tenant2", "test-ns", "PulsarFunction-test");
                    Assert.fail((String)"client admin shouldn't have permissions to get function status");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().getFunctionStatus("external-repl-prop", "test-ns", "PulsarFunction-test");
                try {
                    admin1.functions().getFunctionStats("tenant2", "test-ns", "PulsarFunction-test");
                    Assert.fail((String)"client admin shouldn't have permissions to get function stats");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().getFunctionStats("external-repl-prop", "test-ns", "PulsarFunction-test");
                try {
                    admin1.functions().getFunctionStats("tenant2", "test-ns", "PulsarFunction-test", 0);
                    Assert.fail((String)"client admin shouldn't have permissions to get function stats");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().getFunctionStats("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
                try {
                    admin1.functions().getFunctions("tenant2", "test-ns");
                    Assert.fail((String)"client admin shouldn't have permissions to list functions");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().getFunctions("external-repl-prop", "test-ns");
                try {
                    admin1.functions().triggerFunction("tenant2", "test-ns", "PulsarFunction-test", "persistent://external-repl-prop/test-ns/my-topic1", "foo", null);
                    Assert.fail((String)"client admin shouldn't have permissions to trigger function");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().triggerFunction("external-repl-prop", "test-ns", "PulsarFunction-test", "persistent://external-repl-prop/test-ns/my-topic1", "foo", null);
                try {
                    admin1.functions().restartFunction("tenant2", "test-ns", "PulsarFunction-test", 0);
                    Assert.fail((String)"client admin shouldn't have permissions to restart function instance");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().restartFunction("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
                try {
                    admin1.functions().restartFunction("tenant2", "test-ns", "PulsarFunction-test");
                    Assert.fail((String)"client admin shouldn't have permissions to restart function");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().restartFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                try {
                    admin1.functions().stopFunction("tenant2", "test-ns", "PulsarFunction-test", 0);
                    Assert.fail((String)"client admin shouldn't have permissions to stop function");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().stopFunction("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
                try {
                    admin1.functions().stopFunction("tenant2", "test-ns", "PulsarFunction-test");
                    Assert.fail((String)"client admin shouldn't have permissions to restart function");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().stopFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                try {
                    admin1.functions().startFunction("tenant2", "test-ns", "PulsarFunction-test");
                    Assert.fail((String)"client admin shouldn't have permissions to restart function");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().restartFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                try {
                    admin1.functions().restartFunction("tenant2", "test-ns", "PulsarFunction-test");
                    Assert.fail((String)"client admin shouldn't have permissions to restart function");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                admin1.functions().restartFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                try {
                    admin1.functions().deleteFunction("tenant2", "test-ns", "PulsarFunction-test");
                    Assert.fail((String)"client admin shouldn't have permissions to delete function");
                }
                catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                    // empty catch block
                }
                try {
                    admin1.functions().deleteFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                }
                catch (PulsarAdminException e) {
                    admin1.functions().deleteFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                }
                Assert.assertTrue((boolean)MockedPulsarServiceBaseTest.retryStrategically(test -> {
                    try {
                        boolean done;
                        TopicStats stats = admin1.topics().getStats("persistent://external-repl-prop/test-ns/my-topic1");
                        boolean bl = done = stats.subscriptions.size() == 0;
                        if (!done) {
                            log.info("Topic subscription is not cleaned up yet : {}", (Object)stats);
                        }
                        return done;
                    }
                    catch (PulsarAdminException e) {
                        return false;
                    }
                }, 100, 150L));
            }
        }
    }

    @Test
    public void testAuthorization() throws Exception {
        String token1 = AuthTokenUtils.createToken((Key)this.secretKey, (String)SUBJECT, Optional.empty());
        String token2 = AuthTokenUtils.createToken((Key)this.secretKey, (String)"wrong-subject", Optional.empty());
        String replNamespace = "external-repl-prop/test-ns";
        String sourceTopic = "persistent://external-repl-prop/test-ns/my-topic1";
        String sinkTopic = "persistent://external-repl-prop/test-ns/output";
        String propertyKey = "key";
        String propertyValue = "value";
        String functionName = "PulsarFunction-test";
        String subscriptionName = "test-sub";
        AuthenticationToken authToken1 = new AuthenticationToken();
        authToken1.configure("token:" + token1);
        AuthenticationToken authToken2 = new AuthenticationToken();
        authToken2.configure("token:" + token2);
        try (PulsarAdmin admin1 = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerServiceUrl).authentication((Authentication)authToken1).build());
             PulsarAdmin admin2 = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(this.brokerServiceUrl).authentication((Authentication)authToken2).build());){
            String jarFilePathUrl = PulsarFunctionLocalRunTest.getPulsarApiExamplesJar().toURI().toString();
            FunctionConfig functionConfig = PulsarFunctionE2ESecurityTest.createFunctionConfig("external-repl-prop", "test-ns", "PulsarFunction-test", "persistent://external-repl-prop/test-ns/my-topic1", "persistent://external-repl-prop/test-ns/output", "test-sub");
            try {
                admin1.functions().createFunctionWithUrl(functionConfig, jarFilePathUrl);
                Assert.fail((String)"client admin shouldn't have permissions to create function");
            }
            catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                // empty catch block
            }
            HashSet<AuthAction> actions = new HashSet<AuthAction>();
            actions.add(AuthAction.functions);
            actions.add(AuthAction.produce);
            actions.add(AuthAction.consume);
            this.superUserAdmin.namespaces().grantPermissionOnNamespace("external-repl-prop/test-ns", SUBJECT, actions);
            admin1.functions().createFunctionWithUrl(functionConfig, jarFilePathUrl);
            try {
                admin2.functions().createFunctionWithUrl(functionConfig, jarFilePathUrl);
                Assert.fail((String)"client admin shouldn't have permissions to create function");
            }
            catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                // empty catch block
            }
            try {
                admin2.functions().createFunctionWithUrl(PulsarFunctionE2ESecurityTest.createFunctionConfig("tenant2", "test-ns", "PulsarFunction-test", "persistent://external-repl-prop/test-ns/my-topic1", "persistent://external-repl-prop/test-ns/output", "test-sub"), jarFilePathUrl);
                Assert.fail((String)"client admin shouldn't have permissions to create function");
            }
            catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    return admin1.functions().getFunctionStatus("external-repl-prop", "test-ns", "PulsarFunction-test").getNumRunning() == 1 && admin1.topics().getStats((String)"persistent://external-repl-prop/test-ns/my-topic1").subscriptions.size() == 1;
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 50, 150L));
            Assert.assertEquals((int)admin1.topics().getStats((String)"persistent://external-repl-prop/test-ns/my-topic1").subscriptions.size(), (int)1);
            try (Producer producer2 = this.pulsarClient.newProducer(Schema.STRING).topic("persistent://external-repl-prop/test-ns/my-topic1").create();
                 Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{"persistent://external-repl-prop/test-ns/output"}).subscriptionName("sub").subscribe();){
                int totalMsgs = 5;
                for (int i = 0; i < totalMsgs; ++i) {
                    String data = "my-message-" + i;
                    producer2.newMessage().property("key", "value").value((Object)data).send();
                }
                MockedPulsarServiceBaseTest.retryStrategically(test -> {
                    try {
                        SubscriptionStats subStats = (SubscriptionStats)admin1.topics().getStats((String)"persistent://external-repl-prop/test-ns/my-topic1").subscriptions.get("test-sub");
                        return subStats.unackedMessages == 0L;
                    }
                    catch (PulsarAdminException e) {
                        return false;
                    }
                }, 50, 150L);
                Message msg = consumer.receive(5, TimeUnit.SECONDS);
                String receivedPropertyValue = msg.getProperty("key");
                Assert.assertEquals((String)"value", (String)receivedPropertyValue);
                Assert.assertNotEquals((Object)((SubscriptionStats)admin1.topics().getStats((String)"persistent://external-repl-prop/test-ns/my-topic1").subscriptions.values().iterator().next()).unackedMessages, (Object)totalMsgs);
            }
            functionConfig.setParallelism(Integer.valueOf(2));
            try {
                admin2.functions().updateFunctionWithUrl(functionConfig, jarFilePathUrl);
                Assert.fail((String)"client admin shouldn't have permissions to update function");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().updateFunctionWithUrl(functionConfig, jarFilePathUrl);
            Assert.assertTrue((boolean)MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    return admin1.functions().getFunctionStatus("external-repl-prop", "test-ns", "PulsarFunction-test").getNumRunning() == 2;
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 50, 150L));
            try {
                admin2.functions().getFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                Assert.fail((String)"client admin shouldn't have permissions to get function");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().getFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
            try {
                admin2.functions().getFunctionStatus("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
                Assert.fail((String)"client admin shouldn't have permissions to get function status");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().getFunctionStatus("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
            try {
                admin2.functions().getFunctionStatus("external-repl-prop", "test-ns", "PulsarFunction-test");
                Assert.fail((String)"client admin shouldn't have permissions to get function status");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().getFunctionStatus("external-repl-prop", "test-ns", "PulsarFunction-test");
            try {
                admin2.functions().getFunctionStats("external-repl-prop", "test-ns", "PulsarFunction-test");
                Assert.fail((String)"client admin shouldn't have permissions to get function stats");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().getFunctionStats("external-repl-prop", "test-ns", "PulsarFunction-test");
            try {
                admin2.functions().getFunctionStats("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
                Assert.fail((String)"client admin shouldn't have permissions to get function stats");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().getFunctionStats("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
            try {
                admin2.functions().getFunctions("external-repl-prop", "test-ns");
                Assert.fail((String)"client admin shouldn't have permissions to list functions");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().getFunctions("external-repl-prop", "test-ns");
            try {
                admin2.functions().triggerFunction("external-repl-prop", "test-ns", "PulsarFunction-test", "persistent://external-repl-prop/test-ns/my-topic1", "foo", null);
                Assert.fail((String)"client admin shouldn't have permissions to trigger function");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().triggerFunction("external-repl-prop", "test-ns", "PulsarFunction-test", "persistent://external-repl-prop/test-ns/my-topic1", "foo", null);
            try {
                admin2.functions().restartFunction("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
                Assert.fail((String)"client admin shouldn't have permissions to restart function instance");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().restartFunction("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
            try {
                admin2.functions().restartFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                Assert.fail((String)"client admin shouldn't have permissions to restart function");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().restartFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
            try {
                admin2.functions().stopFunction("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
                Assert.fail((String)"client admin shouldn't have permissions to stop function");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().stopFunction("external-repl-prop", "test-ns", "PulsarFunction-test", 0);
            try {
                admin2.functions().stopFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                Assert.fail((String)"client admin shouldn't have permissions to restart function");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().stopFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
            try {
                admin2.functions().startFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                Assert.fail((String)"client admin shouldn't have permissions to restart function");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().restartFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
            try {
                admin2.functions().restartFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                Assert.fail((String)"client admin shouldn't have permissions to restart function");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            admin1.functions().restartFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
            try {
                admin2.functions().deleteFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
                Assert.fail((String)"client admin shouldn't have permissions to delete function");
            }
            catch (PulsarAdminException.NotAuthorizedException producer2) {
                // empty catch block
            }
            try {
                admin1.functions().deleteFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
            }
            catch (PulsarAdminException e) {
                admin1.functions().deleteFunction("external-repl-prop", "test-ns", "PulsarFunction-test");
            }
            Assert.assertTrue((boolean)MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    boolean done;
                    TopicStats stats = admin1.topics().getStats("persistent://external-repl-prop/test-ns/my-topic1");
                    boolean bl = done = stats.subscriptions.size() == 0;
                    if (!done) {
                        log.info("Topic subscription is not cleaned up yet : {}", (Object)stats);
                    }
                    return done;
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 50, 150L));
        }
    }
}

