/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.schema;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.schema.Schemas;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"schema"})
public class PartitionedTopicSchemaTest
extends MockedPulsarServiceBaseTest {
    private static final String PARTITIONED_TOPIC = "public/default/partitioned-schema-topic";
    private static final int MESSAGE_COUNT_PER_PARTITION = 12;
    private static final int TOPIC_PARTITION = 3;

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.isTcpLookup = true;
        super.internalSetup();
        this.admin.clusters().createCluster("test", new ClusterData(this.pulsar.getWebServiceAddress()));
        this.admin.tenants().createTenant("my-property", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("my-property/my-ns");
        this.admin.namespaces().setNamespaceReplicationClusters("my-property/my-ns", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("public", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("public/default");
        this.admin.namespaces().setNamespaceReplicationClusters("public/default", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.topics().createPartitionedTopic(PARTITIONED_TOPIC, 3);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Consumer consumer = this.pulsarClient.newConsumer(Schema.AUTO_CONSUME()).topic(new String[]{PARTITIONED_TOPIC}).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscriptionName("test").subscribe();
        consumer.close();
        Producer producer = this.pulsarClient.newProducer(Schema.JSON(Schemas.PersonFour.class)).topic(PARTITIONED_TOPIC).enableBatching(false).roundRobinRouterBatchingPartitionSwitchFrequency(1).create();
        try {
            for (int i = 0; i < 36; ++i) {
                Schemas.PersonFour person = new Schemas.PersonFour();
                person.setId(i);
                person.setName("user-" + i);
                person.setAge(18);
                producer.newMessage().value((Object)person).send();
            }
            consumer = this.pulsarClient.newConsumer(Schema.AUTO_CONSUME()).topic(new String[]{TopicName.get((String)PARTITIONED_TOPIC).getPartition(1).toString()}).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscriptionName("test").subscribe();
            int receiveMsgCount = 0;
            for (int i = 0; i < 12; ++i) {
                Message message = consumer.receive();
                Assert.assertNotNull((Object)message);
                ++receiveMsgCount;
            }
            Assert.assertEquals((int)12, (int)receiveMsgCount);
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }
}

