/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.stats.client;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ServerErrorException;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BrokerStatsImpl;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stats"})
public class PulsarBrokerStatsClientTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(PulsarBrokerStatsClientTest.class);

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testServiceException() throws Exception {
        URL url = new URL("http://localhost:15000");
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(url.toString()).build();
        BrokerStatsImpl client = (BrokerStatsImpl)Mockito.spy((Object)admin.brokerStats());
        try {
            client.getLoadReport();
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
        try {
            client.getPendingBookieOpsStats();
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
        try {
            client.getBrokerResourceAvailability("prop/cluster/ns");
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)(client.getApiException((Throwable)new ClientErrorException(403)) instanceof PulsarAdminException.NotAuthorizedException));
        Assert.assertTrue((boolean)(client.getApiException((Throwable)new ClientErrorException(404)) instanceof PulsarAdminException.NotFoundException));
        Assert.assertTrue((boolean)(client.getApiException((Throwable)new ClientErrorException(409)) instanceof PulsarAdminException.ConflictException));
        Assert.assertTrue((boolean)(client.getApiException((Throwable)new ClientErrorException(412)) instanceof PulsarAdminException.PreconditionFailedException));
        Assert.assertTrue((boolean)(client.getApiException((Throwable)new ClientErrorException(400)) instanceof PulsarAdminException));
        Assert.assertTrue((boolean)(client.getApiException((Throwable)new ServerErrorException(500)) instanceof PulsarAdminException.ServerSideErrorException));
        Assert.assertTrue((boolean)(client.getApiException((Throwable)new ServerErrorException(503)) instanceof PulsarAdminException));
        log.info("Client: -- {}", (Object)client);
        admin.close();
    }

    @Test
    public void testTopicInternalStats() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        String topicName = "persistent://my-property/my-ns/my-topic1";
        String subscriptionName = "my-subscriber-name";
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").acknowledgmentGroupTime(0L, TimeUnit.SECONDS).subscribe();
        Producer producer = this.pulsarClient.newProducer().topic("persistent://my-property/my-ns/my-topic1").create();
        int numberOfMsgs = 1000;
        for (int i = 0; i < 1000; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
        }
        int count = 0;
        for (int i = 0; i < 1000; ++i) {
            Message msg = consumer.receive(5, TimeUnit.SECONDS);
            if (msg == null || count++ % 2 != 0) continue;
            consumer.acknowledge(msg);
        }
        PersistentTopic topic = (PersistentTopic)this.pulsar.getBrokerService().getOrCreateTopic("persistent://my-property/my-ns/my-topic1").get();
        PersistentTopicInternalStats internalStats = (PersistentTopicInternalStats)topic.getInternalStats(true).get();
        Assert.assertNotNull((Object)((PersistentTopicInternalStats.LedgerInfo)internalStats.ledgers.get((int)0)).metadata);
        Assert.assertTrue((boolean)((PersistentTopicInternalStats.LedgerInfo)internalStats.ledgers.get((int)0)).underReplicated);
        PersistentTopicInternalStats.CursorStats cursor = (PersistentTopicInternalStats.CursorStats)internalStats.cursors.get("my-subscriber-name");
        Assert.assertEquals((long)cursor.numberOfEntriesSinceFirstNotAckedMessage, (long)1000L);
        Assert.assertTrue((cursor.totalNonContiguousDeletedMessagesRange > 0 && cursor.totalNonContiguousDeletedMessagesRange < 500 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cursor.subscriptionHavePendingRead);
        Assert.assertFalse((boolean)cursor.subscriptionHavePendingReplayRead);
        producer.close();
        consumer.close();
        log.info("-- Exiting {} test --", (Object)this.methodName);
    }
}

