/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.util.Collections;
import java.util.Optional;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class PulsarServiceTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(PulsarServiceTest.class);
    private boolean useListenerName = false;

    @Override
    protected void setup() throws Exception {
        super.internalSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
        this.useListenerName = false;
        this.resetConfig();
    }

    @Override
    protected void doInitConf() throws Exception {
        super.doInitConf();
        if (this.useListenerName) {
            this.conf.setAdvertisedAddress(null);
            this.conf.setBrokerServicePortTls(Optional.of(6651));
            this.conf.setBrokerServicePort(Optional.of(6660));
            this.conf.setWebServicePort(Optional.of(8081));
            this.conf.setWebServicePortTls(Optional.of(8082));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWorkerService() throws Exception {
        ServiceConfiguration configuration = new ServiceConfiguration();
        configuration.setZookeeperServers("localhost");
        configuration.setClusterName("clusterName");
        configuration.setFunctionsWorkerEnabled(true);
        configuration.setBrokerShutdownTimeoutMs(0L);
        WorkerService expectedWorkerService = (WorkerService)Mockito.mock(WorkerService.class);
        PulsarService pulsarService = (PulsarService)Mockito.spy((Object)new PulsarService(configuration, new WorkerConfig(), Optional.of(expectedWorkerService), exitCode -> {}));
        try {
            WorkerService actualWorkerService = pulsarService.getWorkerService();
            AssertJUnit.assertSame((Object)expectedWorkerService, (Object)actualWorkerService);
        }
        finally {
            if (Collections.singletonList(pulsarService).get(0) != null) {
                pulsarService.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWorkerServiceException() throws Exception {
        ServiceConfiguration configuration = new ServiceConfiguration();
        configuration.setZookeeperServers("localhost");
        configuration.setClusterName("clusterName");
        configuration.setFunctionsWorkerEnabled(false);
        configuration.setBrokerShutdownTimeoutMs(0L);
        PulsarService pulsarService = new PulsarService(configuration, new WorkerConfig(), Optional.empty(), exitCode -> {});
        try {
            String errorMessage = "Pulsar Function Worker is not enabled, probably functionsWorkerEnabled is set to false";
            try {
                pulsarService.getWorkerService();
            }
            catch (UnsupportedOperationException e) {
                Assert.assertEquals((String)e.getMessage(), (String)errorMessage);
            }
        }
        finally {
            if (Collections.singletonList(pulsarService).get(0) != null) {
                pulsarService.close();
            }
        }
    }

    @Test
    public void testAppliedAdvertised() throws Exception {
        this.useListenerName = true;
        this.conf.setAdvertisedListeners("internal:pulsar://127.0.0.1:6650, internal:pulsar+ssl://127.0.0.1:6651");
        this.conf.setInternalListenerName("internal");
        this.setup();
        Assert.assertEquals((String)this.pulsar.getAdvertisedAddress(), (String)"127.0.0.1");
        Assert.assertNull((Object)this.pulsar.getConfiguration().getAdvertisedAddress());
        Assert.assertEquals((Object)this.conf, (Object)this.pulsar.getConfiguration());
        this.cleanup();
        this.resetConfig();
        this.setup();
        Assert.assertEquals((String)this.pulsar.getAdvertisedAddress(), (String)"localhost");
        Assert.assertEquals((Object)this.conf, (Object)this.pulsar.getConfiguration());
        Assert.assertEquals((String)this.pulsar.brokerUrlTls(this.conf), (String)("pulsar+ssl://localhost:" + this.pulsar.getBrokerListenPortTls().get()));
        Assert.assertEquals((String)this.pulsar.brokerUrl(this.conf), (String)("pulsar://localhost:" + this.pulsar.getBrokerListenPort().get()));
        Assert.assertEquals((String)this.pulsar.webAddress(this.conf), (String)("http://localhost:" + this.pulsar.getWebService().getListenPortHTTP().get()));
        Assert.assertEquals((String)this.pulsar.webAddressTls(this.conf), (String)("https://localhost:" + this.pulsar.getWebService().getListenPortHTTPS().get()));
    }
}

