/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.UriInfo;
import org.apache.pulsar.broker.admin.MockServletContext;
import org.apache.pulsar.broker.admin.v2.PersistentTopics;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.awaitility.Awaitility;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminApiGetLastMessageIdTest
extends MockedPulsarServiceBaseTest {
    private PersistentTopics persistentTopics;
    private final String testTenant = "my-tenant";
    private final String testLocalCluster = "use";
    private final String testNamespace = "my-namespace";
    protected Field uriField;
    protected UriInfo uriInfo;

    @BeforeClass
    public void initPersistentTopics() throws Exception {
        this.uriField = PulsarWebResource.class.getDeclaredField("uri");
        this.uriField.setAccessible(true);
        this.uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
    }

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("prop", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("prop/ns-abc");
        this.admin.namespaces().setNamespaceReplicationClusters("prop/ns-abc", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.persistentTopics = (PersistentTopics)Mockito.spy((Object)new PersistentTopics());
        this.persistentTopics.setServletContext((ServletContext)new MockServletContext());
        this.persistentTopics.setPulsar(this.pulsar);
        ((PersistentTopics)Mockito.doReturn((Object)this.mockZooKeeper).when((Object)this.persistentTopics)).localZk();
        ((PersistentTopics)Mockito.doReturn((Object)false).when((Object)this.persistentTopics)).isRequestHttps();
        ((PersistentTopics)Mockito.doReturn(null).when((Object)this.persistentTopics)).originalPrincipal();
        ((PersistentTopics)Mockito.doReturn((Object)"test").when((Object)this.persistentTopics)).clientAppId();
        ((PersistentTopics)Mockito.doReturn((Object)"persistent").when((Object)this.persistentTopics)).domain();
        ((PersistentTopics)Mockito.doNothing().when((Object)this.persistentTopics)).validateAdminAccessForTenant(this.testTenant);
        ((PersistentTopics)Mockito.doReturn((Object)Mockito.mock(AuthenticationDataHttps.class)).when((Object)this.persistentTopics)).clientAuthData();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testGetLastMessageId() throws Exception {
        String message;
        int i;
        final MessageId[] id = new MessageId[]{null};
        MessageId messageId = null;
        AsyncResponse asyncResponse = new AsyncResponse(){

            public boolean resume(Object response) {
                id[0] = (MessageId)response;
                return false;
            }

            public boolean resume(Throwable response) {
                return false;
            }

            public boolean cancel() {
                return false;
            }

            public boolean cancel(int retryAfter) {
                return false;
            }

            public boolean cancel(Date retryAfter) {
                return false;
            }

            public boolean isSuspended() {
                return false;
            }

            public boolean isCancelled() {
                return false;
            }

            public boolean isDone() {
                return false;
            }

            public boolean setTimeout(long time, TimeUnit unit) {
                return false;
            }

            public void setTimeoutHandler(TimeoutHandler handler) {
            }

            public Collection<Class<?>> register(Class<?> callback) {
                return null;
            }

            public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) {
                return null;
            }

            public Collection<Class<?>> register(Object callback) {
                return null;
            }

            public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) {
                return null;
            }
        };
        try {
            this.persistentTopics.getLastMessageId(asyncResponse, "my-tenant", "my-namespace", "my-topic", true);
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Topic not found", (String)e.getMessage());
        }
        String key = "legendtkl";
        String topicName = "persistent://prop/ns-abc/my-topic";
        String messagePredicate = "my-message-" + key + "-";
        int numberOfMessages = 30;
        Producer producer = this.pulsarClient.newProducer().topic("persistent://prop/ns-abc/my-topic").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (i = 0; i < 30; ++i) {
            message = messagePredicate + i;
            producer.send((Object)message.getBytes());
        }
        this.persistentTopics.getLastMessageId(asyncResponse, "prop", "ns-abc", "my-topic", true);
        while (id[0] == null) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((((MessageIdImpl)id[0]).getLedgerId() >= 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)29L, (long)((MessageIdImpl)id[0]).getEntryId());
        messageId = id[0];
        for (i = 0; i < 30; ++i) {
            message = messagePredicate + i;
            producer.send((Object)message.getBytes());
        }
        this.persistentTopics.getLastMessageId(asyncResponse, "prop", "ns-abc", "my-topic", true);
        while (id[0] == messageId) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((((MessageIdImpl)id[0]).getLedgerId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)59L, (long)((MessageIdImpl)id[0]).getEntryId());
    }

    @Test
    public void testGetLastMessageIdWhenTopicWithoutData() throws Exception {
        String topic = "persistent://prop/ns-abc/testGetLastMessageIdWhenTopicWithoutData-" + UUID.randomUUID();
        Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
        int messages = 10;
        for (int i = 0; i < 10; ++i) {
            producer.send((Object)("Message - " + i));
        }
        this.admin.topics().unload(topic);
        Topic topicRef = (Topic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topic).get()).get();
        ((PersistentTopic)topicRef).getManagedLedger().trimConsumedLedgersInBackground(new CompletableFuture());
        Awaitility.await().untilAsserted(() -> {
            PersistentTopicInternalStats stats = this.admin.topics().getInternalStats(topic);
            Assert.assertEquals((int)stats.ledgers.size(), (int)1);
        });
        Reader reader = this.pulsarClient.newReader(Schema.STRING).topic(topic).startMessageId(MessageId.earliest).create();
        boolean hasMessage = reader.hasMessageAvailable();
        Assert.assertFalse((boolean)hasMessage);
        MessageId messageId = this.admin.topics().getLastMessageId(topic);
        Assert.assertEquals((String)messageId.toString(), (String)"-1:-1:-1");
    }
}

