/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.StringSchema;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaInfoWithVersion;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminApiSchemaTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdminApiSchemaTest.class);
    final String cluster = "test";
    private final String schemaCompatibilityNamespace = "schematest/test-schema-compatibility-ns";
    private static final Map<String, String> PROPS = new HashMap<String, String>();

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("schematest", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("schematest/test", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().createNamespace("schematest/test/test", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().createNamespace("schematest/test-schema-compatibility-ns", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @DataProvider(name="schemas")
    public Object[][] schemas() {
        return new Object[][]{{Schema.BOOL}, {Schema.INT8}, {Schema.INT16}, {Schema.INT32}, {Schema.INT64}, {StringSchema.utf8()}, {new StringSchema(StandardCharsets.US_ASCII)}, {Schema.FLOAT}, {Schema.DOUBLE}, {Schema.DATE}, {Schema.TIME}, {Schema.TIMESTAMP}, {Schema.INSTANT}, {Schema.LOCAL_DATE}, {Schema.LOCAL_TIME}, {Schema.LOCAL_DATE_TIME}, {Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).withProperties(PROPS).build())}, {Schema.JSON((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).withProperties(PROPS).build())}, {Schema.KeyValue((Schema)StringSchema.utf8(), (Schema)new StringSchema(StandardCharsets.US_ASCII))}};
    }

    @DataProvider(name="version")
    public Object[][] versions() {
        return new Object[][]{{ApiVersion.V1}, {ApiVersion.V2}};
    }

    @Test(dataProvider="schemas")
    public void testSchemaInfoApi(Schema<?> schema) throws Exception {
        this.testSchemaInfoApi(schema, "schematest/test/test-" + schema.getSchemaInfo().getType());
    }

    @Test(dataProvider="schemas")
    public void testSchemaInfoWithVersionApi(Schema<?> schema) throws Exception {
        this.testSchemaInfoWithVersionApi(schema, "schematest/test/test-" + schema.getSchemaInfo().getType());
    }

    private <T> void testSchemaInfoApi(Schema<T> schema, String topicName) throws Exception {
        SchemaInfo si = schema.getSchemaInfo();
        this.admin.schemas().createSchema(topicName, si);
        log.info("Upload schema to topic {} : {}", (Object)topicName, (Object)si);
        SchemaInfo readSi = this.admin.schemas().getSchemaInfo(topicName);
        log.info("Read schema of topic {} : {}", (Object)topicName, (Object)readSi);
        org.testng.Assert.assertEquals((Object)readSi, (Object)si);
        readSi = this.admin.schemas().getSchemaInfo(topicName + "-partition-0");
        log.info("Read schema of topic {} : {}", (Object)topicName, (Object)readSi);
        org.testng.Assert.assertEquals((Object)readSi, (Object)si);
    }

    @Test(dataProvider="version")
    public void testPostSchemaCompatibilityStrategy(ApiVersion version) throws PulsarAdminException {
        String namespace = String.format("%s%s%s", "schematest", ApiVersion.V1.equals((Object)version) ? "/test/" : "/", "test");
        String topicName = "persistent://" + namespace + "/testStrategyChange";
        SchemaInfo fooSchemaInfo = Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withAlwaysAllowNull(false).withPojo(Foo.class).build()).getSchemaInfo();
        this.admin.schemas().createSchema(topicName, fooSchemaInfo);
        this.admin.namespaces().setSchemaAutoUpdateCompatibilityStrategy(namespace, SchemaAutoUpdateCompatibilityStrategy.Backward);
        SchemaInfo foo1SchemaInfo = Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withAlwaysAllowNull(false).withPojo(Foo1.class).build()).getSchemaInfo();
        try {
            this.admin.schemas().createSchema(topicName, foo1SchemaInfo);
            org.testng.Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException.ConflictException e) {
            org.testng.Assert.assertTrue((boolean)e.getMessage().contains("HTTP 409"));
        }
        namespace = "schematest/testnotfound";
        topicName = namespace + "/testStrategyChange";
        try {
            this.admin.schemas().createSchema(topicName, fooSchemaInfo);
            org.testng.Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException.NotFoundException e) {
            org.testng.Assert.assertTrue((boolean)e.getMessage().contains("HTTP 404"));
        }
    }

    private <T> void testSchemaInfoWithVersionApi(Schema<T> schema, String topicName) throws Exception {
        SchemaInfo si = schema.getSchemaInfo();
        this.admin.schemas().createSchema(topicName, si);
        log.info("Upload schema to topic {} : {}", (Object)topicName, (Object)si);
        SchemaInfoWithVersion readSi = this.admin.schemas().getSchemaInfoWithVersion(topicName);
        log.info("Read schema of topic {} : {}", (Object)topicName, (Object)readSi);
        org.testng.Assert.assertEquals((Object)readSi.getSchemaInfo(), (Object)si);
        org.testng.Assert.assertEquals((long)readSi.getVersion(), (long)0L);
        readSi = this.admin.schemas().getSchemaInfoWithVersion(topicName + "-partition-0");
        log.info("Read schema of topic {} : {}", (Object)topicName, (Object)readSi);
        org.testng.Assert.assertEquals((Object)readSi.getSchemaInfo(), (Object)si);
        org.testng.Assert.assertEquals((long)readSi.getVersion(), (long)0L);
    }

    @Test(dataProvider="version")
    public void createKeyValueSchema(ApiVersion version) throws Exception {
        String namespace = String.format("%s%s%s", "schematest", ApiVersion.V1.equals((Object)version) ? "/test/" : "/", "test");
        String topicName = "persistent://" + namespace + "/test-key-value-schema";
        Schema keyValueSchema = Schema.KeyValue((Schema)Schema.AVRO(Foo.class), (Schema)Schema.AVRO(Foo.class));
        this.admin.schemas().createSchema(topicName, keyValueSchema.getSchemaInfo());
        SchemaInfo schemaInfo = this.admin.schemas().getSchemaInfo(topicName);
        org.testng.Assert.assertEquals((Object)keyValueSchema.getSchemaInfo(), (Object)schemaInfo);
    }

    @Test
    void getTopicIntervalStateIncludeSchemaStoreLedger() throws PulsarAdminException {
        String topicName = "persistent://schematest/test/get-schema-ledger-info";
        this.admin.topics().createNonPartitionedTopic(topicName);
        this.admin.topics().createSubscription(topicName, "test", MessageId.earliest);
        Schema schema = Schema.AVRO(Foo.class);
        this.admin.schemas().createSchema(topicName, schema.getSchemaInfo());
        final long ledgerId = 1L;
        final long entryId = 10L;
        final long length = 10L;
        ((MockedPulsarServiceBaseTest.NonClosableMockBookKeeper)((Object)Mockito.doReturn(CompletableFuture.completedFuture(new LedgerMetadata(){

            public long getLedgerId() {
                return ledgerId;
            }

            public int getEnsembleSize() {
                return 0;
            }

            public int getWriteQuorumSize() {
                return 0;
            }

            public int getAckQuorumSize() {
                return 0;
            }

            public long getLastEntryId() {
                return entryId;
            }

            public long getLength() {
                return length;
            }

            public boolean hasPassword() {
                return false;
            }

            public byte[] getPassword() {
                return new byte[0];
            }

            public DigestType getDigestType() {
                return null;
            }

            public long getCtime() {
                return 0L;
            }

            public boolean isClosed() {
                return false;
            }

            public Map<String, byte[]> getCustomMetadata() {
                return null;
            }

            public List<BookieId> getEnsembleAt(long entryId2) {
                return null;
            }

            public NavigableMap<Long, ? extends List<BookieId>> getAllEnsembles() {
                return null;
            }

            public LedgerMetadata.State getState() {
                return null;
            }

            public String toSafeString() {
                return "test";
            }

            public int getMetadataFormatVersion() {
                return 0;
            }

            public long getCToken() {
                return 0L;
            }
        })).when((Object)this.mockBookKeeper))).getLedgerMetadata(ArgumentMatchers.anyLong());
        PersistentTopicInternalStats persistentTopicInternalStats = this.admin.topics().getInternalStats(topicName);
        List list = persistentTopicInternalStats.schemaLedgers;
        org.testng.Assert.assertEquals((int)list.size(), (int)1);
        ManagedLedgerInternalStats.LedgerInfo ledgerInfo = (ManagedLedgerInternalStats.LedgerInfo)list.get(0);
        org.testng.Assert.assertEquals((long)ledgerInfo.ledgerId, (long)ledgerId);
        org.testng.Assert.assertEquals((long)ledgerInfo.entries, (long)(entryId + 1L));
        org.testng.Assert.assertEquals((long)ledgerInfo.size, (long)length);
    }

    @Test
    public void testGetSchemaCompatibilityStrategy() throws PulsarAdminException {
        org.testng.Assert.assertEquals((Object)this.admin.namespaces().getSchemaCompatibilityStrategy("schematest/test-schema-compatibility-ns"), (Object)SchemaCompatibilityStrategy.UNDEFINED);
    }

    @Test
    public void testGetSchemaAutoUpdateCompatibilityStrategy() throws PulsarAdminException {
        Assert.assertNull((Object)this.admin.namespaces().getSchemaAutoUpdateCompatibilityStrategy("schematest/test-schema-compatibility-ns"));
    }

    @Test
    public void testGetSchemaCompatibilityStrategyWhenSetSchemaAutoUpdateCompatibilityStrategy() throws PulsarAdminException {
        org.testng.Assert.assertEquals((Object)this.admin.namespaces().getSchemaCompatibilityStrategy("schematest/test-schema-compatibility-ns"), (Object)SchemaCompatibilityStrategy.UNDEFINED);
        this.admin.namespaces().setSchemaAutoUpdateCompatibilityStrategy("schematest/test-schema-compatibility-ns", SchemaAutoUpdateCompatibilityStrategy.Forward);
        Awaitility.await().untilAsserted(() -> org.testng.Assert.assertEquals((Object)SchemaAutoUpdateCompatibilityStrategy.Forward, (Object)this.admin.namespaces().getSchemaAutoUpdateCompatibilityStrategy("schematest/test-schema-compatibility-ns")));
        org.testng.Assert.assertEquals((Object)this.admin.namespaces().getSchemaCompatibilityStrategy("schematest/test-schema-compatibility-ns"), (Object)SchemaCompatibilityStrategy.UNDEFINED);
        this.admin.namespaces().setSchemaCompatibilityStrategy("schematest/test-schema-compatibility-ns", SchemaCompatibilityStrategy.BACKWARD);
        Awaitility.await().untilAsserted(() -> org.testng.Assert.assertEquals((Object)SchemaCompatibilityStrategy.BACKWARD, (Object)this.admin.namespaces().getSchemaCompatibilityStrategy("schematest/test-schema-compatibility-ns")));
    }

    @Test
    public void testGetSchemaCompatibilityStrategyWhenSetBrokerLevelAndSchemaAutoUpdateCompatibilityStrategy() throws PulsarAdminException {
        this.pulsar.getConfiguration().setSchemaCompatibilityStrategy(SchemaCompatibilityStrategy.FORWARD);
        org.testng.Assert.assertEquals((Object)this.admin.namespaces().getSchemaCompatibilityStrategy("schematest/test-schema-compatibility-ns"), (Object)SchemaCompatibilityStrategy.UNDEFINED);
        this.admin.namespaces().setSchemaAutoUpdateCompatibilityStrategy("schematest/test-schema-compatibility-ns", SchemaAutoUpdateCompatibilityStrategy.AlwaysCompatible);
        Awaitility.await().untilAsserted(() -> org.testng.Assert.assertEquals((Object)this.admin.namespaces().getSchemaCompatibilityStrategy("schematest/test-schema-compatibility-ns"), (Object)SchemaCompatibilityStrategy.UNDEFINED));
    }

    static {
        PROPS.put("key1", "value1");
    }

    public static class Foo1 {
        int intField;
        String file1;
    }

    public static class Foo {
        int intField;
    }

    static enum ApiVersion {
        V1,
        V2;

    }
}

