/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.util.Codec;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminResourceTest
extends BrokerTestBase {
    @Override
    @BeforeClass
    public void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    private static AdminResource mockResource() {
        return new AdminResource(){

            protected String domain() {
                return "persistent";
            }
        };
    }

    @Test
    public void testValidatePartitionedTopicNameSuccess() {
        String tenant = "test-tenant";
        String namespace = "test-namespace";
        String topic = Codec.encode((String)"test-topic");
        AdminResource resource = AdminResourceTest.mockResource();
        resource.validatePartitionedTopicName(tenant, namespace, topic);
    }

    @Test
    public void testValidatePartitionedTopicNameInvalid() {
        String tenant = "test-tenant";
        String namespace = "test-namespace";
        String topic = Codec.encode((String)"test-topic-partition-0");
        AdminResource resource = AdminResourceTest.mockResource();
        try {
            resource.validatePartitionedTopicName(tenant, namespace, topic);
            Assert.fail((String)"Should fail validation on invalid partitioned topic");
        }
        catch (RestException re) {
            Assert.assertEquals((int)Response.Status.PRECONDITION_FAILED.getStatusCode(), (int)re.getResponse().getStatus());
        }
    }

    @Test
    public void testValidatePartitionedTopicMetadata() throws Exception {
        String tenant = "prop";
        String namespace = "ns-abc";
        String partitionedTopic = "partitionedTopic";
        String nonPartitionedTopic = "notPartitionedTopic";
        int partitions = 3;
        String completePartitionedTopic = tenant + "/" + namespace + "/" + partitionedTopic;
        String completeNonPartitionedTopic = tenant + "/" + namespace + "/" + nonPartitionedTopic;
        this.admin.topics().createNonPartitionedTopic(completeNonPartitionedTopic);
        this.admin.topics().createPartitionedTopic(completePartitionedTopic, partitions);
        AdminResource resource = AdminResourceTest.mockResource();
        resource.setPulsar(this.pulsar);
        resource.validatePartitionedTopicName(tenant, namespace, Codec.encode((String)partitionedTopic));
        resource.validatePartitionedTopicMetadata(tenant, namespace, Codec.encode((String)partitionedTopic));
        resource.validatePartitionedTopicName(tenant, namespace, Codec.encode((String)nonPartitionedTopic));
        try {
            resource.validatePartitionedTopicMetadata(tenant, namespace, Codec.encode((String)nonPartitionedTopic));
            Assert.fail((String)"Should fail validation on non-partitioned topic");
        }
        catch (RestException re) {
            Assert.assertEquals((int)Response.Status.CONFLICT.getStatusCode(), (int)re.getResponse().getStatus());
        }
    }
}

