/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import java.util.Optional;
import java.util.Set;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.common.policies.data.BookiesClusterInfo;
import org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BookiesApiTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(BookiesApiTest.class);

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testBasic() throws Exception {
        BookiesRackConfiguration conf = this.admin.bookies().getBookiesRackInfo();
        Assert.assertTrue((boolean)conf.isEmpty());
        String bookie0 = "127.0.0.1:3181";
        String bookie1 = "127.0.0.2:3181";
        try {
            this.admin.bookies().getBookieRackInfo(bookie0);
            Assert.fail((String)"should not reach here");
        }
        catch (PulsarAdminException pae) {
            Assert.assertEquals((int)404, (int)pae.getStatusCode());
        }
        BookieInfo newInfo0 = BookieInfo.builder().rack("/rack1").hostname("127.0.0.1").build();
        BookieInfo newInfo1 = BookieInfo.builder().rack("/rack1").hostname("127.0.0.2").build();
        this.admin.bookies().updateBookieRackInfo(bookie0, "default", newInfo0);
        BookieInfo readInfo0 = this.admin.bookies().getBookieRackInfo(bookie0);
        Assert.assertEquals((Object)newInfo0, (Object)readInfo0);
        conf = this.admin.bookies().getBookiesRackInfo();
        Assert.assertEquals((int)1, (int)conf.size());
        Assert.assertEquals(Optional.of(newInfo0), (Object)conf.getBookie(bookie0));
        this.admin.bookies().updateBookieRackInfo(bookie1, "default", newInfo1);
        BookieInfo readInfo1 = this.admin.bookies().getBookieRackInfo(bookie1);
        Assert.assertEquals((Object)newInfo1, (Object)readInfo1);
        conf = this.admin.bookies().getBookiesRackInfo();
        Assert.assertEquals((int)1, (int)conf.size());
        Assert.assertEquals(Optional.of(newInfo0), (Object)conf.getBookie(bookie0));
        Assert.assertEquals(Optional.of(newInfo1), (Object)conf.getBookie(bookie1));
        this.admin.bookies().deleteBookieRackInfo(bookie0);
        try {
            this.admin.bookies().getBookieRackInfo(bookie0);
            Assert.fail((String)"should not reach here");
        }
        catch (PulsarAdminException pae) {
            Assert.assertEquals((int)404, (int)pae.getStatusCode());
        }
        Assert.assertEquals((Object)newInfo1, (Object)this.admin.bookies().getBookieRackInfo(bookie1));
        this.admin.bookies().deleteBookieRackInfo(bookie1);
        try {
            this.admin.bookies().getBookieRackInfo(bookie1);
            Assert.fail((String)"should not reach here");
        }
        catch (PulsarAdminException pae) {
            Assert.assertEquals((int)404, (int)pae.getStatusCode());
        }
        conf = this.admin.bookies().getBookiesRackInfo();
        Assert.assertTrue((boolean)conf.isEmpty());
        BookiesClusterInfo bookies = this.admin.bookies().getBookies();
        log.info("bookies info {}", (Object)bookies);
        Assert.assertEquals((int)bookies.getBookies().size(), (int)((Set)((Versioned)this.pulsar.getBookKeeperClient().getMetadataClientDriver().getRegistrationClient().getAllBookies().get()).getValue()).size());
    }
}

