/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.auth;

import java.io.IOException;
import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(MockAuthenticationProvider.class);

    public void close() throws IOException {
    }

    public void initialize(ServiceConfiguration config) throws IOException {
    }

    public String getAuthMethodName() {
        return "mock";
    }

    public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
        String principal = "unknown";
        if (authData.hasDataFromHttp()) {
            principal = authData.getHttpHeader("mockuser");
        } else if (authData.hasDataFromCommand()) {
            principal = authData.getCommandData();
        }
        String[] parts = principal.split("\\.");
        if (parts.length == 2) {
            switch (parts[0]) {
                case "pass": {
                    return principal;
                }
                case "fail": {
                    throw new AuthenticationException("Do not pass");
                }
                case "error": {
                    throw new RuntimeException("Error in authn");
                }
            }
        }
        throw new IllegalArgumentException("Not a valid principle. Should be [pass|fail|error].[pass|fail|error], found " + principal);
    }
}

