/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed;

import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.time.Clock;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.broker.delayed.InMemoryDelayedDeliveryTracker;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class InMemoryDeliveryTrackerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        PersistentDispatcherMultipleConsumers dispatcher = (PersistentDispatcherMultipleConsumers)Mockito.mock(PersistentDispatcherMultipleConsumers.class);
        Timer timer = (Timer)Mockito.mock(Timer.class);
        AtomicLong clockTime = new AtomicLong();
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).then(x -> clockTime.get());
        InMemoryDelayedDeliveryTracker tracker = new InMemoryDelayedDeliveryTracker(dispatcher, timer, 1L, clock);
        try {
            Assert.assertFalse((boolean)tracker.hasMessageAvailable());
            Assert.assertTrue((boolean)tracker.addMessage(2L, 2L, 20L));
            Assert.assertTrue((boolean)tracker.addMessage(1L, 1L, 10L));
            Assert.assertTrue((boolean)tracker.addMessage(3L, 3L, 30L));
            Assert.assertTrue((boolean)tracker.addMessage(5L, 5L, 50L));
            Assert.assertTrue((boolean)tracker.addMessage(4L, 4L, 40L));
            Assert.assertFalse((boolean)tracker.hasMessageAvailable());
            Assert.assertEquals((long)tracker.getNumberOfDelayedMessages(), (long)5L);
            Assert.assertEquals((Set)tracker.getScheduledMessages(10), Collections.emptySet());
            clockTime.set(15L);
            Assert.assertFalse((boolean)tracker.addMessage(6L, 6L, 10L));
            Assert.assertEquals((long)tracker.getNumberOfDelayedMessages(), (long)5L);
            Assert.assertTrue((boolean)tracker.hasMessageAvailable());
            Set scheduled = tracker.getScheduledMessages(10);
            Assert.assertEquals((int)scheduled.size(), (int)1);
            clockTime.set(60L);
            Assert.assertEquals((long)tracker.getNumberOfDelayedMessages(), (long)4L);
            Assert.assertTrue((boolean)tracker.hasMessageAvailable());
            scheduled = tracker.getScheduledMessages(1);
            Assert.assertEquals((int)scheduled.size(), (int)1);
            Assert.assertEquals((long)tracker.getNumberOfDelayedMessages(), (long)3L);
            Assert.assertTrue((boolean)tracker.hasMessageAvailable());
            scheduled = tracker.getScheduledMessages(3);
            Assert.assertEquals((int)scheduled.size(), (int)3);
            Assert.assertEquals((long)tracker.getNumberOfDelayedMessages(), (long)0L);
            Assert.assertFalse((boolean)tracker.hasMessageAvailable());
            Assert.assertEquals((Set)tracker.getScheduledMessages(10), Collections.emptySet());
        }
        finally {
            if (Collections.singletonList(tracker).get(0) != null) {
                tracker.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithTimer() throws Exception {
        PersistentDispatcherMultipleConsumers dispatcher = (PersistentDispatcherMultipleConsumers)Mockito.mock(PersistentDispatcherMultipleConsumers.class);
        Timer timer = (Timer)Mockito.mock(Timer.class);
        AtomicLong clockTime = new AtomicLong();
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).then(x -> clockTime.get());
        TreeMap tasks = new TreeMap();
        Mockito.when((Object)timer.newTimeout((TimerTask)Mockito.any(), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any()))).then(invocation -> {
            TimerTask task = (TimerTask)invocation.getArgument(0, TimerTask.class);
            long timeout = (Long)invocation.getArgument(1, Long.class);
            TimeUnit unit = (TimeUnit)((Object)((Object)invocation.getArgument(2, TimeUnit.class)));
            long scheduleAt = clockTime.get() + unit.toMillis(timeout);
            tasks.put(scheduleAt, task);
            Timeout t = (Timeout)Mockito.mock(Timeout.class);
            Mockito.when((Object)t.cancel()).then(i -> {
                tasks.remove(scheduleAt, task);
                return null;
            });
            return t;
        });
        InMemoryDelayedDeliveryTracker tracker = new InMemoryDelayedDeliveryTracker(dispatcher, timer, 1L, clock);
        try {
            Assert.assertTrue((boolean)tasks.isEmpty());
            Assert.assertTrue((boolean)tracker.addMessage(2L, 2L, 20L));
            Assert.assertEquals((int)tasks.size(), (int)1);
            Assert.assertEquals((long)((Long)tasks.firstKey()), (long)20L);
            Assert.assertTrue((boolean)tracker.addMessage(1L, 1L, 10L));
            Assert.assertEquals((int)tasks.size(), (int)1);
            Assert.assertEquals((long)((Long)tasks.firstKey()), (long)10L);
            Assert.assertTrue((boolean)tracker.addMessage(3L, 3L, 30L));
            Assert.assertEquals((int)tasks.size(), (int)1);
            Assert.assertEquals((long)((Long)tasks.firstKey()), (long)10L);
            clockTime.set(15L);
            TimerTask task = (TimerTask)tasks.pollFirstEntry().getValue();
            Timeout cancelledTimeout = (Timeout)Mockito.mock(Timeout.class);
            Mockito.when((Object)cancelledTimeout.isCancelled()).thenReturn((Object)true);
            task.run(cancelledTimeout);
            Mockito.verifyZeroInteractions((Object[])new Object[]{dispatcher});
            task.run((Timeout)Mockito.mock(Timeout.class));
            ((PersistentDispatcherMultipleConsumers)Mockito.verify((Object)dispatcher)).readMoreEntries();
        }
        finally {
            if (Collections.singletonList(tracker).get(0) != null) {
                tracker.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddWithinTickTime() {
        PersistentDispatcherMultipleConsumers dispatcher = (PersistentDispatcherMultipleConsumers)Mockito.mock(PersistentDispatcherMultipleConsumers.class);
        Timer timer = (Timer)Mockito.mock(Timer.class);
        AtomicLong clockTime = new AtomicLong();
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).then(x -> clockTime.get());
        InMemoryDelayedDeliveryTracker tracker = new InMemoryDelayedDeliveryTracker(dispatcher, timer, 100L, clock);
        try {
            clockTime.set(0L);
            Assert.assertFalse((boolean)tracker.addMessage(1L, 1L, 10L));
            Assert.assertFalse((boolean)tracker.addMessage(2L, 2L, 99L));
            Assert.assertTrue((boolean)tracker.addMessage(3L, 3L, 100L));
            Assert.assertTrue((boolean)tracker.addMessage(4L, 4L, 200L));
            Assert.assertEquals((long)tracker.getNumberOfDelayedMessages(), (long)2L);
        }
        finally {
            if (Collections.singletonList(tracker).get(0) != null) {
                tracker.close();
            }
        }
    }
}

