/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.intercept.BrokerInterceptorWithClassLoader;
import org.apache.pulsar.broker.intercept.BrokerInterceptors;
import org.apache.pulsar.broker.intercept.CounterBrokerInterceptor;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BrokerInterceptorTest
extends ProducerConsumerBase {
    private static final String listenerName1 = "listener1";
    private BrokerInterceptor listener1;
    private NarClassLoader ncl1;
    private static final String listenerName2 = "listener2";
    private BrokerInterceptor listener2;
    private NarClassLoader ncl2;
    private Map<String, BrokerInterceptorWithClassLoader> listenerMap;
    private BrokerInterceptors listeners;

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setDisableBrokerInterceptors(false);
        this.listener1 = (BrokerInterceptor)Mockito.mock(BrokerInterceptor.class);
        this.ncl1 = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        this.listener2 = (BrokerInterceptor)Mockito.mock(BrokerInterceptor.class);
        this.ncl2 = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        this.listenerMap = new HashMap<String, BrokerInterceptorWithClassLoader>();
        this.listenerMap.put(listenerName1, new BrokerInterceptorWithClassLoader(this.listener1, this.ncl1));
        this.listenerMap.put(listenerName2, new BrokerInterceptorWithClassLoader(this.listener2, this.ncl2));
        this.listeners = new BrokerInterceptors(this.listenerMap);
        this.enableBrokerInterceptor = true;
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    protected void cleanup() throws Exception {
        this.teardown();
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        this.listeners.close();
        ((BrokerInterceptor)Mockito.verify((Object)this.listener1, (VerificationMode)Mockito.times((int)1))).close();
        ((BrokerInterceptor)Mockito.verify((Object)this.listener2, (VerificationMode)Mockito.times((int)1))).close();
        ((NarClassLoader)Mockito.verify((Object)this.ncl1, (VerificationMode)Mockito.times((int)1))).close();
        ((NarClassLoader)Mockito.verify((Object)this.ncl2, (VerificationMode)Mockito.times((int)1))).close();
        super.internalCleanup();
    }

    @Test
    public void testInitialize() throws Exception {
        this.listeners.initialize(this.pulsar);
        ((BrokerInterceptor)Mockito.verify((Object)this.listener1, (VerificationMode)Mockito.times((int)1))).initialize((PulsarService)ArgumentMatchers.same((Object)this.pulsar));
        ((BrokerInterceptor)Mockito.verify((Object)this.listener2, (VerificationMode)Mockito.times((int)1))).initialize((PulsarService)ArgumentMatchers.same((Object)this.pulsar));
    }

    @Test
    public void testWebserviceRequest() throws PulsarAdminException {
        BrokerInterceptor listener = this.pulsar.getBrokerInterceptor();
        Assert.assertTrue((boolean)(listener instanceof CounterBrokerInterceptor));
        this.admin.namespaces().createNamespace("public/test", 4);
        Assert.assertTrue((((CounterBrokerInterceptor)listener).getCount() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testPulsarCommand() throws PulsarClientException {
        BrokerInterceptor listener = this.pulsar.getBrokerInterceptor();
        Assert.assertTrue((boolean)(listener instanceof CounterBrokerInterceptor));
        this.pulsarClient.newProducer(Schema.BOOL).topic("test").create();
        Assert.assertTrue((((CounterBrokerInterceptor)listener).getCount() >= 2 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeforeSendMessage() throws PulsarClientException {
        BrokerInterceptor listener = this.pulsar.getBrokerInterceptor();
        Assert.assertTrue((boolean)(listener instanceof CounterBrokerInterceptor));
        Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic("test-before-send-message").create();
        try {
            Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{"test-before-send-message"}).subscriptionName("test").subscribe();
            producer.send((Object)"hello world");
            Message msg = consumer.receive();
            Assert.assertEquals((String)((String)msg.getValue()), (String)"hello world");
            Assert.assertEquals((int)((CounterBrokerInterceptor)listener).getBeforeSendCount(), (int)1);
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    @Test
    public void asyncResponseFilterTest() throws Exception {
        Assert.assertTrue((boolean)(this.pulsar.getBrokerInterceptor() instanceof CounterBrokerInterceptor));
        CounterBrokerInterceptor interceptor = (CounterBrokerInterceptor)this.pulsar.getBrokerInterceptor();
        interceptor.clearResponseList();
        OkHttpClient client = new OkHttpClient();
        String url = "http://127.0.0.1:" + this.conf.getWebServicePort().get() + "/admin/v3/test/asyncGet/my-topic/1000";
        Request request = new Request.Builder().url(url).get().build();
        Call call = client.newCall(request);
        final CompletableFuture future = new CompletableFuture();
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                future.complete(response);
            }
        });
        future.get();
        CounterBrokerInterceptor.ResponseEvent responseEvent = interceptor.getResponseList().get(0);
        Assert.assertEquals((String)responseEvent.getRequestUri(), (String)"/admin/v3/test/asyncGet/my-topic/1000");
        Assert.assertEquals((int)responseEvent.getResponseStatus(), (int)javax.ws.rs.core.Response.noContent().build().getStatus());
    }
}

