/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;

public class LoadBalancerTestingUtils {
    public static NamespaceBundle[] makeBundles(NamespaceBundleFactory nsFactory, String property, String cluster, String namespace, int numBundles) {
        NamespaceBundle[] result = new NamespaceBundle[numBundles];
        NamespaceName namespaceName = NamespaceName.get((String)property, (String)cluster, (String)namespace);
        for (int i = 0; i < numBundles - 1; ++i) {
            long lower = NamespaceBundles.FULL_UPPER_BOUND * (long)i / (long)numBundles;
            long upper = NamespaceBundles.FULL_UPPER_BOUND * (long)(i + 1) / (long)numBundles;
            result[i] = nsFactory.getBundle(namespaceName, Range.range((Comparable)Long.valueOf(lower), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(upper), (BoundType)BoundType.OPEN));
        }
        result[numBundles - 1] = nsFactory.getBundle(namespaceName, Range.range((Comparable)Long.valueOf(NamespaceBundles.FULL_UPPER_BOUND * (long)(numBundles - 1) / (long)numBundles), (BoundType)BoundType.CLOSED, (Comparable)NamespaceBundles.FULL_UPPER_BOUND, (BoundType)BoundType.CLOSED));
        return result;
    }
}

