/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.namespace.OwnerShipForCurrentServerTestBase;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class OwnerShipCacheForCurrentServerTest
extends OwnerShipForCurrentServerTestBase {
    private static final String TENANT = "ownership";
    private static final String NAMESPACE = "ownership/ns1";
    private static final String TOPIC_TEST = "ownership/ns1/test";

    @BeforeMethod
    protected void setup() throws Exception {
        this.internalSetup();
        String[] brokerServiceUrlArr = this.getPulsarServiceList().get(0).getBrokerServiceUrl().split(":");
        String webServicePort = brokerServiceUrlArr[brokerServiceUrlArr.length - 1];
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl("http://localhost:" + webServicePort).build());
        this.admin.tenants().createTenant(TENANT, (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NAMESPACE);
        this.admin.topics().createNonPartitionedTopic(TOPIC_TEST);
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() {
        super.internalCleanup();
    }

    @Test
    public void testOwnershipForCurrentServer() throws Exception {
        NamespaceService[] namespaceServices = new NamespaceService[this.getPulsarServiceList().size()];
        for (int i = 0; i < this.getPulsarServiceList().size(); ++i) {
            namespaceServices[i] = this.getPulsarServiceList().get(i).getNamespaceService();
            NamespaceBundle bundle = namespaceServices[i].getBundle(TopicName.get((String)TOPIC_TEST));
            Assert.assertEquals((String)((NamespaceEphemeralData)((Optional)namespaceServices[i].getOwnerAsync(bundle).get()).get()).getNativeUrl(), (String)((NamespaceEphemeralData)((Optional)namespaceServices[i].getOwnerAsync(bundle).get()).get()).getNativeUrl());
        }
    }
}

