/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.protocol;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.pulsar.broker.protocol.MockProtocolHandler;
import org.apache.pulsar.broker.protocol.ProtocolHandler;
import org.apache.pulsar.broker.protocol.ProtocolHandlerDefinition;
import org.apache.pulsar.broker.protocol.ProtocolHandlerMetadata;
import org.apache.pulsar.broker.protocol.ProtocolHandlerUtils;
import org.apache.pulsar.broker.protocol.ProtocolHandlerWithClassLoader;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockObjectFactory;
import org.testng.AssertJUnit;
import org.testng.IObjectFactory;
import org.testng.annotations.ObjectFactory;
import org.testng.annotations.Test;

@PrepareForTest(value={ProtocolHandlerUtils.class, NarClassLoader.class})
@PowerMockIgnore(value={"org.apache.logging.log4j.*"})
@Test(groups={"broker"})
public class ProtocolHandlerUtilsTest {
    @ObjectFactory
    public IObjectFactory getObjectFactory() {
        return new PowerMockObjectFactory();
    }

    @Test
    public void testLoadProtocolHandler() throws Exception {
        ProtocolHandlerDefinition def = new ProtocolHandlerDefinition();
        def.setHandlerClass(MockProtocolHandler.class.getName());
        def.setDescription("test-protocol-handler");
        String archivePath = "/path/to/protocol/handler/nar";
        ProtocolHandlerMetadata metadata = new ProtocolHandlerMetadata();
        metadata.setDefinition(def);
        metadata.setArchivePath(Paths.get(archivePath, new String[0]));
        NarClassLoader mockLoader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        Mockito.when((Object)mockLoader.getServiceDefinition((String)ArgumentMatchers.eq((Object)"pulsar-protocol-handler.yml"))).thenReturn((Object)ObjectMapperFactory.getThreadLocalYaml().writeValueAsString((Object)def));
        Class<MockProtocolHandler> handlerClass = MockProtocolHandler.class;
        Mockito.when((Object)mockLoader.loadClass((String)ArgumentMatchers.eq((Object)MockProtocolHandler.class.getName()))).thenReturn(handlerClass);
        PowerMockito.mockStatic(NarClassLoader.class, (Class[])new Class[0]);
        PowerMockito.when((Object)NarClassLoader.getFromArchive((File)((File)ArgumentMatchers.any(File.class)), (Set)((Set)ArgumentMatchers.any(Set.class)), (ClassLoader)((ClassLoader)ArgumentMatchers.any(ClassLoader.class)), (String)((String)ArgumentMatchers.any(String.class)))).thenReturn((Object)mockLoader);
        ProtocolHandlerWithClassLoader returnedPhWithCL = ProtocolHandlerUtils.load((ProtocolHandlerMetadata)metadata, (String)"");
        ProtocolHandler returnedPh = returnedPhWithCL.getHandler();
        AssertJUnit.assertSame((Object)mockLoader, (Object)returnedPhWithCL.getClassLoader());
        AssertJUnit.assertTrue((boolean)(returnedPh instanceof MockProtocolHandler));
    }

    @Test
    public void testLoadProtocolHandlerBlankHandlerClass() throws Exception {
        ProtocolHandlerDefinition def = new ProtocolHandlerDefinition();
        def.setDescription("test-protocol-handler");
        String archivePath = "/path/to/protocol/handler/nar";
        ProtocolHandlerMetadata metadata = new ProtocolHandlerMetadata();
        metadata.setDefinition(def);
        metadata.setArchivePath(Paths.get(archivePath, new String[0]));
        NarClassLoader mockLoader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        Mockito.when((Object)mockLoader.getServiceDefinition((String)ArgumentMatchers.eq((Object)"pulsar-protocol-handler.yml"))).thenReturn((Object)ObjectMapperFactory.getThreadLocalYaml().writeValueAsString((Object)def));
        Class<MockProtocolHandler> handlerClass = MockProtocolHandler.class;
        Mockito.when((Object)mockLoader.loadClass((String)ArgumentMatchers.eq((Object)MockProtocolHandler.class.getName()))).thenReturn(handlerClass);
        PowerMockito.mockStatic(NarClassLoader.class, (Class[])new Class[0]);
        PowerMockito.when((Object)NarClassLoader.getFromArchive((File)((File)ArgumentMatchers.any(File.class)), (Set)((Set)ArgumentMatchers.any(Set.class)), (ClassLoader)((ClassLoader)ArgumentMatchers.any(ClassLoader.class)), (String)((String)ArgumentMatchers.any(String.class)))).thenReturn((Object)mockLoader);
        try {
            ProtocolHandlerUtils.load((ProtocolHandlerMetadata)metadata, (String)"");
            AssertJUnit.fail((String)"Should not reach here");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadProtocolHandlerWrongHandlerClass() throws Exception {
        ProtocolHandlerDefinition def = new ProtocolHandlerDefinition();
        def.setHandlerClass(Runnable.class.getName());
        def.setDescription("test-protocol-handler");
        String archivePath = "/path/to/protocol/handler/nar";
        ProtocolHandlerMetadata metadata = new ProtocolHandlerMetadata();
        metadata.setDefinition(def);
        metadata.setArchivePath(Paths.get(archivePath, new String[0]));
        NarClassLoader mockLoader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        Mockito.when((Object)mockLoader.getServiceDefinition((String)ArgumentMatchers.eq((Object)"pulsar-protocol-handler.yml"))).thenReturn((Object)ObjectMapperFactory.getThreadLocalYaml().writeValueAsString((Object)def));
        Class<Runnable> handlerClass = Runnable.class;
        Mockito.when((Object)mockLoader.loadClass((String)ArgumentMatchers.eq((Object)Runnable.class.getName()))).thenReturn(handlerClass);
        PowerMockito.mockStatic(NarClassLoader.class, (Class[])new Class[0]);
        PowerMockito.when((Object)NarClassLoader.getFromArchive((File)((File)ArgumentMatchers.any(File.class)), (Set)((Set)ArgumentMatchers.any(Set.class)), (ClassLoader)((ClassLoader)ArgumentMatchers.any(ClassLoader.class)), (String)((String)ArgumentMatchers.any(String.class)))).thenReturn((Object)mockLoader);
        try {
            ProtocolHandlerUtils.load((ProtocolHandlerMetadata)metadata, (String)"");
            AssertJUnit.fail((String)"Should not reach here");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

