/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class PartitionKeyTest
extends BrokerTestBase {
    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test(timeOut=10000L)
    public void testPartitionKey() throws Exception {
        String topicName = "persistent://prop/use/ns-abc/testPartitionKey";
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/use/ns-abc/testPartitionKey"}).subscriptionName("my-subscription").subscribe();
        Producer producerWithBatches = this.pulsarClient.newProducer().topic("persistent://prop/use/ns-abc/testPartitionKey").enableBatching(true).create();
        Producer producerWithoutBatches = this.pulsarClient.newProducer().topic("persistent://prop/use/ns-abc/testPartitionKey").create();
        producerWithBatches.newMessage().key("key-1").value((Object)"msg-1".getBytes()).sendAsync();
        producerWithBatches.newMessage().key("key-2").value((Object)"msg-2".getBytes()).send();
        producerWithoutBatches.newMessage().key("key-3").value((Object)"msg-3".getBytes()).sendAsync();
        for (int i = 1; i <= 3; ++i) {
            Message msg = consumer.receive();
            Assert.assertTrue((boolean)msg.hasKey());
            Assert.assertEquals((String)msg.getKey(), (String)("key-" + i));
            Assert.assertEquals((byte[])msg.getData(), (byte[])("msg-" + i).getBytes());
            consumer.acknowledge(msg);
        }
    }
}

