/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.broker.service.PrecisPublishLimiter;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PrecisPublishLimiterTest {
    @Test
    void shouldResetMsgLimitAfterUpdate() {
        PrecisPublishLimiter precisPublishLimiter = new PrecisPublishLimiter(new PublishRate(), () -> {});
        precisPublishLimiter.update(new PublishRate(1, 1L));
        Assert.assertFalse((boolean)precisPublishLimiter.tryAcquire(99, 99L));
        precisPublishLimiter.update(new PublishRate(-1, 100L));
        Assert.assertTrue((boolean)precisPublishLimiter.tryAcquire(99, 99L));
    }

    @Test
    void shouldResetBytesLimitAfterUpdate() {
        PrecisPublishLimiter precisPublishLimiter = new PrecisPublishLimiter(new PublishRate(), () -> {});
        precisPublishLimiter.update(new PublishRate(1, 1L));
        Assert.assertFalse((boolean)precisPublishLimiter.tryAcquire(99, 99L));
        precisPublishLimiter.update(new PublishRate(100, -1L));
        Assert.assertTrue((boolean)precisPublishLimiter.tryAcquire(99, 99L));
    }

    @Test
    void shouldCloseResources() throws Exception {
        for (int i = 0; i < 20000; ++i) {
            PrecisPublishLimiter precisPublishLimiter = new PrecisPublishLimiter(new PublishRate(100, 100L), () -> {});
            precisPublishLimiter.tryAcquire(99, 99L);
            precisPublishLimiter.close();
        }
    }
}

