/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.ReplicatorTestBase;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

@Test(groups={"broker"})
public class ReplicatorTlsTest
extends ReplicatorTestBase {
    private static final Logger log = LoggerFactory.getLogger(ReplicatorTlsTest.class);

    @Override
    @BeforeClass(timeOut=300000L)
    public void setup() throws Exception {
        this.config1.setBrokerClientTlsEnabled(true);
        this.config2.setBrokerClientTlsEnabled(true);
        this.config3.setBrokerClientTlsEnabled(true);
        super.setup();
    }

    @Override
    @AfterClass(alwaysRun=true, timeOut=300000L)
    public void cleanup() throws Exception {
        super.cleanup();
    }

    @Test
    public void testReplicationClient() throws Exception {
        log.info("--- Starting ReplicatorTlsTest::testReplicationClient ---");
        for (BrokerService ns : Lists.newArrayList((Object[])new BrokerService[]{this.ns1, this.ns2, this.ns3})) {
            ns.getReplicationClients().forEach((cluster, client) -> {
                Assert.assertTrue((boolean)((PulsarClientImpl)client).getConfiguration().isUseTls());
                Assert.assertEquals((String)((PulsarClientImpl)client).getConfiguration().getTlsTrustCertsFilePath(), (String)"./src/test/resources/certificate/server.crt");
            });
        }
    }
}

