/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.service.persistent.ReplicatedSubscriptionSnapshotCache;
import org.apache.pulsar.common.api.proto.ReplicatedSubscriptionsSnapshot;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ReplicatedSubscriptionSnapshotCacheTest {
    @Test
    public void testSnapshotCache() {
        ReplicatedSubscriptionSnapshotCache cache = new ReplicatedSubscriptionSnapshotCache("my-subscription", 10);
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(0L, 0L)));
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(100L, 0L)));
        ReplicatedSubscriptionsSnapshot s1 = new ReplicatedSubscriptionsSnapshot().setSnapshotId("snapshot-1");
        s1.setLocalMessageId().setLedgerId(1L).setEntryId(1L);
        ReplicatedSubscriptionsSnapshot s2 = new ReplicatedSubscriptionsSnapshot().setSnapshotId("snapshot-2");
        s2.setLocalMessageId().setLedgerId(2L).setEntryId(2L);
        ReplicatedSubscriptionsSnapshot s5 = new ReplicatedSubscriptionsSnapshot().setSnapshotId("snapshot-5");
        s5.setLocalMessageId().setLedgerId(5L).setEntryId(5L);
        ReplicatedSubscriptionsSnapshot s7 = new ReplicatedSubscriptionsSnapshot().setSnapshotId("snapshot-7");
        s7.setLocalMessageId().setLedgerId(7L).setEntryId(7L);
        cache.addNewSnapshot(s1);
        cache.addNewSnapshot(s2);
        cache.addNewSnapshot(s5);
        cache.addNewSnapshot(s7);
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(0L, 0L)));
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(1L, 0L)));
        ReplicatedSubscriptionsSnapshot snapshot = cache.advancedMarkDeletePosition(new PositionImpl(1L, 1L));
        Assert.assertNotNull((Object)snapshot);
        Assert.assertEquals((String)snapshot.getSnapshotId(), (String)"snapshot-1");
        snapshot = cache.advancedMarkDeletePosition(new PositionImpl(5L, 6L));
        Assert.assertNotNull((Object)snapshot);
        Assert.assertEquals((String)snapshot.getSnapshotId(), (String)"snapshot-5");
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(2L, 2L)));
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(5L, 5L)));
    }

    @Test
    public void testSnapshotCachePruning() {
        ReplicatedSubscriptionSnapshotCache cache = new ReplicatedSubscriptionSnapshotCache("my-subscription", 3);
        ReplicatedSubscriptionsSnapshot s1 = new ReplicatedSubscriptionsSnapshot().setSnapshotId("snapshot-1");
        s1.setLocalMessageId().setLedgerId(1L).setEntryId(1L);
        ReplicatedSubscriptionsSnapshot s2 = new ReplicatedSubscriptionsSnapshot().setSnapshotId("snapshot-2");
        s2.setLocalMessageId().setLedgerId(2L).setEntryId(2L);
        ReplicatedSubscriptionsSnapshot s3 = new ReplicatedSubscriptionsSnapshot().setSnapshotId("snapshot-3");
        s3.setLocalMessageId().setLedgerId(3L).setEntryId(3L);
        ReplicatedSubscriptionsSnapshot s4 = new ReplicatedSubscriptionsSnapshot().setSnapshotId("snapshot-4");
        s4.setLocalMessageId().setLedgerId(4L).setEntryId(4L);
        cache.addNewSnapshot(s1);
        cache.addNewSnapshot(s2);
        cache.addNewSnapshot(s3);
        cache.addNewSnapshot(s4);
        Assert.assertNull((Object)cache.advancedMarkDeletePosition(new PositionImpl(1L, 1L)));
        ReplicatedSubscriptionsSnapshot snapshot = cache.advancedMarkDeletePosition(new PositionImpl(2L, 2L));
        Assert.assertNotNull((Object)snapshot);
        Assert.assertEquals((String)snapshot.getSnapshotId(), (String)"snapshot-2");
        snapshot = cache.advancedMarkDeletePosition(new PositionImpl(5L, 5L));
        Assert.assertNotNull((Object)snapshot);
        Assert.assertEquals((String)snapshot.getSnapshotId(), (String)"snapshot-4");
    }
}

