/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema.validator;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.schema.SchemaRegistryService;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.broker.service.schema.validator.SchemaRegistryServiceWithSchemaDataValidator;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class SchemaRegistryServiceWithSchemaDataValidatorTest {
    private SchemaRegistryService underlyingService;
    private SchemaRegistryServiceWithSchemaDataValidator service;

    @BeforeMethod
    public void setup() {
        this.underlyingService = (SchemaRegistryService)Mockito.mock(SchemaRegistryService.class);
        this.service = SchemaRegistryServiceWithSchemaDataValidator.of((SchemaRegistryService)this.underlyingService);
    }

    @Test
    public void testGetLatestSchema() {
        String schemaId = "test-schema-id";
        CompletableFuture getFuture = new CompletableFuture();
        Mockito.when((Object)this.underlyingService.getSchema((String)Mockito.eq((Object)schemaId))).thenReturn(getFuture);
        Assert.assertSame(getFuture, (Object)this.service.getSchema(schemaId));
        ((SchemaRegistryService)Mockito.verify((Object)this.underlyingService, (VerificationMode)Mockito.times((int)1))).getSchema((String)Mockito.eq((Object)schemaId));
    }

    @Test
    public void testGetSchemaByVersion() {
        String schemaId = "test-schema-id";
        CompletableFuture getFuture = new CompletableFuture();
        Mockito.when((Object)this.underlyingService.getSchema((String)Mockito.eq((Object)schemaId), (SchemaVersion)Mockito.any(SchemaVersion.class))).thenReturn(getFuture);
        Assert.assertSame(getFuture, (Object)this.service.getSchema(schemaId, SchemaVersion.Latest));
        ((SchemaRegistryService)Mockito.verify((Object)this.underlyingService, (VerificationMode)Mockito.times((int)1))).getSchema((String)Mockito.eq((Object)schemaId), (SchemaVersion)Mockito.same((Object)SchemaVersion.Latest));
    }

    @Test
    public void testDeleteSchema() {
        String schemaId = "test-schema-id";
        String user = "test-user";
        CompletableFuture deleteFuture = new CompletableFuture();
        Mockito.when((Object)this.underlyingService.deleteSchema((String)Mockito.eq((Object)schemaId), (String)Mockito.eq((Object)user))).thenReturn(deleteFuture);
        Assert.assertSame(deleteFuture, (Object)this.service.deleteSchema(schemaId, user));
        ((SchemaRegistryService)Mockito.verify((Object)this.underlyingService, (VerificationMode)Mockito.times((int)1))).deleteSchema((String)Mockito.eq((Object)schemaId), (String)Mockito.eq((Object)user));
    }

    @Test
    public void testIsCompatibleWithGoodSchemaData() {
        String schemaId = "test-schema-id";
        SchemaCompatibilityStrategy strategy = SchemaCompatibilityStrategy.FULL;
        CompletableFuture future = new CompletableFuture();
        Mockito.when((Object)this.underlyingService.isCompatible((String)Mockito.eq((Object)schemaId), (SchemaData)Mockito.any(SchemaData.class), (SchemaCompatibilityStrategy)Mockito.eq((Object)strategy))).thenReturn(future);
        SchemaData schemaData = SchemaData.builder().type(SchemaType.BOOLEAN).data(new byte[0]).build();
        Assert.assertSame(future, (Object)this.service.isCompatible(schemaId, schemaData, strategy));
        ((SchemaRegistryService)Mockito.verify((Object)this.underlyingService, (VerificationMode)Mockito.times((int)1))).isCompatible((String)Mockito.eq((Object)schemaId), (SchemaData)Mockito.same((Object)schemaData), (SchemaCompatibilityStrategy)Mockito.eq((Object)strategy));
    }

    @Test
    public void testIsCompatibleWithBadSchemaData() {
        String schemaId = "test-schema-id";
        SchemaCompatibilityStrategy strategy = SchemaCompatibilityStrategy.FULL;
        CompletableFuture future = new CompletableFuture();
        Mockito.when((Object)this.underlyingService.isCompatible((String)Mockito.eq((Object)schemaId), (SchemaData)Mockito.any(SchemaData.class), (SchemaCompatibilityStrategy)Mockito.eq((Object)strategy))).thenReturn(future);
        SchemaData schemaData = SchemaData.builder().type(SchemaType.BOOLEAN).data(new byte[10]).build();
        try {
            this.service.isCompatible(schemaId, schemaData, strategy).get();
            Assert.fail((String)"Should fail isCompatible check");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidSchemaDataException));
        }
        ((SchemaRegistryService)Mockito.verify((Object)this.underlyingService, (VerificationMode)Mockito.times((int)0))).isCompatible((String)Mockito.eq((Object)schemaId), (SchemaData)Mockito.same((Object)schemaData), (SchemaCompatibilityStrategy)Mockito.eq((Object)strategy));
    }

    @Test
    public void testPutSchemaIfAbsentWithGoodSchemaData() {
        String schemaId = "test-schema-id";
        SchemaCompatibilityStrategy strategy = SchemaCompatibilityStrategy.FULL;
        CompletableFuture future = new CompletableFuture();
        Mockito.when((Object)this.underlyingService.putSchemaIfAbsent((String)Mockito.eq((Object)schemaId), (SchemaData)Mockito.any(SchemaData.class), (SchemaCompatibilityStrategy)Mockito.eq((Object)strategy))).thenReturn(future);
        SchemaData schemaData = SchemaData.builder().type(SchemaType.BOOLEAN).data(new byte[0]).build();
        Assert.assertSame(future, (Object)this.service.putSchemaIfAbsent(schemaId, schemaData, strategy));
        ((SchemaRegistryService)Mockito.verify((Object)this.underlyingService, (VerificationMode)Mockito.times((int)1))).putSchemaIfAbsent((String)Mockito.eq((Object)schemaId), (SchemaData)Mockito.same((Object)schemaData), (SchemaCompatibilityStrategy)Mockito.eq((Object)strategy));
    }

    @Test
    public void testPutSchemaIfAbsentWithBadSchemaData() {
        String schemaId = "test-schema-id";
        SchemaCompatibilityStrategy strategy = SchemaCompatibilityStrategy.FULL;
        CompletableFuture future = new CompletableFuture();
        Mockito.when((Object)this.underlyingService.putSchemaIfAbsent((String)Mockito.eq((Object)schemaId), (SchemaData)Mockito.any(SchemaData.class), (SchemaCompatibilityStrategy)Mockito.eq((Object)strategy))).thenReturn(future);
        SchemaData schemaData = SchemaData.builder().type(SchemaType.BOOLEAN).data(new byte[10]).build();
        try {
            this.service.putSchemaIfAbsent(schemaId, schemaData, strategy).get();
            Assert.fail((String)"Should fail putSchemaIfAbsent");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidSchemaDataException));
        }
        ((SchemaRegistryService)Mockito.verify((Object)this.underlyingService, (VerificationMode)Mockito.times((int)0))).putSchemaIfAbsent((String)Mockito.eq((Object)schemaId), (SchemaData)Mockito.same((Object)schemaData), (SchemaCompatibilityStrategy)Mockito.eq((Object)strategy));
    }
}

