/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.Map;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.stats.BookieClientStatsGenerator;
import org.apache.pulsar.common.stats.JvmMetrics;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BookieClientsStatsGeneratorTest
extends BrokerTestBase {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testBookieClientStatsGenerator() throws Exception {
        Map stats = BookieClientStatsGenerator.generate((PulsarService)super.getPulsar());
        Assert.assertTrue((boolean)stats.isEmpty());
    }

    @Test
    public void testJvmDirectMemoryUsedMetric() {
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 0, 1, 8192, 11, 64, 32, 8, true);
        int allocateMemory = 17777216;
        long directMemory1 = JvmMetrics.getJvmDirectMemoryUsed();
        ByteBuf buf2 = allocator.directBuffer(allocateMemory, allocateMemory);
        long directMemory2 = JvmMetrics.getJvmDirectMemoryUsed();
        Assert.assertEquals((long)directMemory2, (long)(directMemory1 + (long)allocateMemory));
        ByteBuf buf3 = allocator.directBuffer(allocateMemory, allocateMemory);
        long directMemory3 = JvmMetrics.getJvmDirectMemoryUsed();
        Assert.assertEquals((long)directMemory3, (long)(directMemory2 + (long)allocateMemory));
        buf3.release();
        directMemory3 = JvmMetrics.getJvmDirectMemoryUsed();
        Assert.assertEquals((long)directMemory3, (long)directMemory2);
        buf2.release();
        directMemory2 = JvmMetrics.getJvmDirectMemoryUsed();
        Assert.assertEquals((long)directMemory2, (long)directMemory1);
    }
}

