/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.PulsarMockLedgerHandle;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.stats.metrics.ManagedCursorMetrics;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.stats.Metrics;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"quarantine"})
public class ManagedCursorMetricsTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeClass(alwaysRun=true)
    protected void setup() throws Exception {
        super.internalSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    public void testManagedCursorMetrics() throws Exception {
        String subName = "my-sub";
        String topicName = "persistent://my-namespace/use/my-ns/my-topic1";
        int messageSize = 10;
        ManagedCursorMetrics metrics = new ManagedCursorMetrics(this.pulsar);
        List metricsList = metrics.generate();
        Assert.assertTrue((boolean)metricsList.isEmpty());
        metricsList = metrics.generate();
        Assert.assertTrue((boolean)metricsList.isEmpty());
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-namespace/use/my-ns/my-topic1"}).subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).subscriptionName("my-sub").subscribe();
        Producer producer = this.pulsarClient.newProducer().topic("persistent://my-namespace/use/my-ns/my-topic1").create();
        for (PulsarMockLedgerHandle ledgerHandle : this.mockBookKeeper.getLedgerMap().values()) {
            ledgerHandle.close();
        }
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
            consumer.acknowledge(consumer.receive().getMessageId());
        }
        metricsList = metrics.generate();
        Assert.assertFalse((boolean)metricsList.isEmpty());
        Assert.assertNotEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_persistLedgerSucceed"), (Object)0L);
        Assert.assertNotEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_persistLedgerErrors"), (Object)0L);
        Assert.assertNotEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_persistZookeeperSucceed"), (Object)0L);
        Assert.assertEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_persistZookeeperErrors"), (Object)0L);
        Assert.assertEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_nonContiguousDeletedMessagesRange"), (Object)0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorReadWriteMetrics() throws Exception {
        String subName = "read-write";
        String topicName = "persistent://my-namespace/use/my-ns/read-write";
        int messageSize = 10;
        ManagedCursorMetrics metrics = new ManagedCursorMetrics(this.pulsar);
        List metricsList = metrics.generate();
        Assert.assertTrue((boolean)metricsList.isEmpty());
        metricsList = metrics.generate();
        Assert.assertTrue((boolean)metricsList.isEmpty());
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-namespace/use/my-ns/read-write"}).subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).subscriptionName("read-write").subscribe();
        try {
            Consumer consumer2 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-namespace/use/my-ns/read-write"}).subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).subscriptionName("read-write-2").subscribe();
            try {
                Producer producer = this.pulsarClient.newProducer().topic("persistent://my-namespace/use/my-ns/read-write").create();
                try {
                    for (PulsarMockLedgerHandle ledgerHandle : this.mockBookKeeper.getLedgerMap().values()) {
                        ledgerHandle.close();
                    }
                    for (int i = 0; i < 10; ++i) {
                        String message = "my-message-" + i;
                        producer.send((Object)message.getBytes());
                        if (i % 2 == 0) {
                            consumer.acknowledge(consumer.receive().getMessageId());
                            continue;
                        }
                        consumer2.acknowledge(consumer.receive().getMessageId());
                    }
                    metricsList = metrics.generate();
                    Assert.assertEquals((int)metricsList.size(), (int)3);
                    Assert.assertEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_writeLedgerSize"), (Object)26L);
                    Assert.assertEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_writeLedgerLogicalSize"), (Object)13L);
                    Assert.assertEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_readLedgerSize"), (Object)0L);
                    Assert.assertEquals(((Metrics)metricsList.get(1)).getMetrics().get("brk_ml_cursor_writeLedgerSize"), (Object)26L);
                    Assert.assertEquals(((Metrics)metricsList.get(1)).getMetrics().get("brk_ml_cursor_writeLedgerLogicalSize"), (Object)13L);
                    Assert.assertEquals(((Metrics)metricsList.get(1)).getMetrics().get("brk_ml_cursor_readLedgerSize"), (Object)0L);
                    Assert.assertEquals(((Metrics)metricsList.get(2)).getMetrics().get("brk_ml_cursor_writeLedgerSize"), (Object)52L);
                    Assert.assertEquals(((Metrics)metricsList.get(2)).getMetrics().get("brk_ml_cursor_writeLedgerLogicalSize"), (Object)26L);
                    Assert.assertEquals(((Metrics)metricsList.get(2)).getMetrics().get("brk_ml_cursor_readLedgerSize"), (Object)0L);
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer2).get(0) != null) {
                    consumer2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }
}

