/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.naming.AuthenticationException;
import org.apache.commons.io.IOUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProviderToken;
import org.apache.pulsar.broker.authentication.utils.AuthTokenUtils;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentMessageExpiryMonitor;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsGenerator;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.compaction.Compactor;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"flaky"})
public class PrometheusMetricsTest
extends BrokerTestBase {
    @Override
    @BeforeMethod(alwaysRun=true)
    protected void setup() throws Exception {
        super.baseSetup();
        AuthenticationProviderToken.resetMetrics();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricsTopicCount() throws Exception {
        int i;
        String ns1 = "prop/ns-abc1";
        String ns2 = "prop/ns-abc2";
        this.admin.namespaces().createNamespace(ns1);
        this.admin.namespaces().createNamespace(ns2);
        String baseTopic1 = "persistent://" + ns1 + "/testMetricsTopicCount";
        String baseTopic2 = "persistent://" + ns2 + "/testMetricsTopicCount";
        for (i = 0; i < 6; ++i) {
            this.admin.topics().createNonPartitionedTopic(baseTopic1 + UUID.randomUUID());
        }
        for (i = 0; i < 3; ++i) {
            this.admin.topics().createNonPartitionedTopic(baseTopic2 + UUID.randomUUID());
        }
        Thread.sleep(100L);
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        try {
            PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)false, (OutputStream)statsOut);
            String metricsStr = statsOut.toString();
            Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
            Collection metric = metrics.get((Object)"pulsar_topics_count");
            metric.forEach(item -> {
                if (ns1.equals(item.tags.get("namespace"))) {
                    Assert.assertEquals((double)item.value, (double)6.0);
                }
                if (ns2.equals(item.tags.get("namespace"))) {
                    Assert.assertEquals((double)item.value, (double)3.0);
                }
            });
        }
        finally {
            if (Collections.singletonList(statsOut).get(0) != null) {
                statsOut.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricsAvgMsgSize2() throws Exception {
        String ns1 = "prop/ns-abc1";
        this.admin.namespaces().createNamespace(ns1, 1);
        String baseTopic1 = "persistent://" + ns1 + "/testMetricsTopicCount";
        String topicName = baseTopic1 + UUID.randomUUID();
        org.apache.pulsar.client.api.Producer producer = this.pulsarClient.newProducer().producerName("my-pub").topic(topicName).create();
        PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.pulsar.getBrokerService().getTopic(topicName, false).get()).get();
        Producer producerInServer = (Producer)persistentTopic.getProducers().get("my-pub");
        producerInServer.getStats().msgRateIn = 10.0;
        producerInServer.getStats().msgThroughputIn = 100.0;
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        try {
            PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)true, (OutputStream)statsOut);
            String metricsStr = statsOut.toString();
            Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
            Assert.assertTrue((boolean)metrics.containsKey((Object)"pulsar_average_msg_size"));
            Assert.assertEquals((int)metrics.get((Object)"pulsar_average_msg_size").size(), (int)1);
            Collection avgMsgSizes = metrics.get((Object)"pulsar_average_msg_size");
            avgMsgSizes.forEach(item -> {
                if (ns1.equals(item.tags.get("namespace"))) {
                    Assert.assertEquals((double)item.value, (double)10.0);
                }
            });
            producer.close();
        }
        finally {
            if (Collections.singletonList(statsOut).get(0) != null) {
                statsOut.close();
            }
        }
    }

    @Test
    public void testPerTopicStats() throws Exception {
        int i;
        org.apache.pulsar.client.api.Producer p1 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        org.apache.pulsar.client.api.Producer p2 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic2").create();
        Consumer c1 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic1"}).subscriptionName("test").subscribe();
        Consumer c2 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic2"}).subscriptionName("test").subscribe();
        int messages = 10;
        for (i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            p1.send((Object)message.getBytes());
            p2.send((Object)message.getBytes());
        }
        for (i = 0; i < 10; ++i) {
            c1.acknowledge(c1.receive());
            c2.acknowledge(c2.receive());
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        metrics.entries().forEach(e -> System.out.println((String)e.getKey() + ": " + e.getValue()));
        List cm = (List)metrics.get((Object)"pulsar_storage_write_latency_le_1");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"pulsar_producers_count");
        Assert.assertEquals((int)cm.size(), (int)3);
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)2)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)2)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"topic_load_times_count");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
        cm = (List)metrics.get((Object)"pulsar_in_bytes_total");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"pulsar_in_messages_total");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"pulsar_out_bytes_total");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("subscription"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("subscription"), (String)"test");
        cm = (List)metrics.get((Object)"pulsar_out_messages_total");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("subscription"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("subscription"), (String)"test");
        p1.close();
        p2.close();
        c1.close();
        c2.close();
    }

    @Test
    public void testPerTopicExpiredStat() throws Exception {
        int i;
        String ns = "prop/ns-abc1";
        this.admin.namespaces().createNamespace(ns);
        String topic1 = "persistent://" + ns + "/testPerTopicExpiredStat1";
        String topic2 = "persistent://" + ns + "/testPerTopicExpiredStat2";
        List<String> topicList = Arrays.asList(topic2, topic1);
        org.apache.pulsar.client.api.Producer p1 = this.pulsarClient.newProducer().topic(topic1).create();
        org.apache.pulsar.client.api.Producer p2 = this.pulsarClient.newProducer().topic(topic2).create();
        String subName = "test";
        for (String topic : topicList) {
            this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("test").subscribe().close();
        }
        int messages = 10;
        for (int i2 = 0; i2 < 10; ++i2) {
            String message = "my-message-" + i2;
            p1.send((Object)message.getBytes());
            p2.send((Object)message.getBytes());
        }
        p1.close();
        p2.close();
        for (String topic : topicList) {
            PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topic).get()).get();
            persistentTopic.getBrokerService().getPulsar().getConfiguration().setTtlDurationDefaultInSeconds(-1);
        }
        this.pulsar.getBrokerService().forEachTopic(Topic::checkMessageExpiry);
        PersistentSubscription sub = (PersistentSubscription)((Topic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topic1).get()).get()).getSubscription("test");
        PersistentSubscription sub2 = (PersistentSubscription)((Topic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topic2).get()).get()).getSubscription("test");
        Awaitility.await().until(() -> sub.getExpiredMessageRate() != 0.0);
        Awaitility.await().until(() -> sub2.getExpiredMessageRate() != 0.0);
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        List cm = (List)metrics.get((Object)"pulsar_subscription_last_expire_timestamp");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)topic2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)ns);
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)topic1);
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)ns);
        Field field = PersistentSubscription.class.getDeclaredField("lastExpireTimestamp");
        field.setAccessible(true);
        for (int i3 = 0; i3 < topicList.size(); ++i3) {
            PersistentSubscription subscription = (PersistentSubscription)((Topic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topicList.get(i3)).get()).get()).getSubscription("test");
            Assert.assertEquals((long)((Long)field.get(subscription)), (long)((long)((Metric)cm.get((int)i3)).value));
        }
        cm = (List)metrics.get((Object)"pulsar_subscription_msg_rate_expired");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)topic2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)ns);
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)topic1);
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)ns);
        field = PersistentSubscription.class.getDeclaredField("expiryMonitor");
        field.setAccessible(true);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        nf.setRoundingMode(RoundingMode.DOWN);
        for (i = 0; i < topicList.size(); ++i) {
            PersistentSubscription subscription = (PersistentSubscription)((Topic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topicList.get(i)).get()).get()).getSubscription("test");
            PersistentMessageExpiryMonitor monitor = (PersistentMessageExpiryMonitor)field.get(subscription);
            Assert.assertEquals((double)Double.valueOf(nf.format(monitor.getMessageExpiryRate())), (double)((Metric)cm.get((int)i)).value);
        }
        cm = (List)metrics.get((Object)"pulsar_subscription_total_msg_expired");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)topic2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)ns);
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)topic1);
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)ns);
        for (i = 0; i < topicList.size(); ++i) {
            Assert.assertEquals((long)10L, (long)((long)((Metric)cm.get((int)i)).value));
        }
    }

    @Test
    public void testPerNamespaceStats() throws Exception {
        int i;
        org.apache.pulsar.client.api.Producer p1 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        org.apache.pulsar.client.api.Producer p2 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic2").create();
        Consumer c1 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic1"}).subscriptionName("test").subscribe();
        Consumer c2 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic2"}).subscriptionName("test").subscribe();
        int messages = 10;
        for (i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            p1.send((Object)message.getBytes());
            p2.send((Object)message.getBytes());
        }
        for (i = 0; i < 10; ++i) {
            c1.acknowledge(c1.receive());
            c2.acknowledge(c2.receive());
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)false, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        metrics.entries().forEach(e -> System.out.println((String)e.getKey() + ": " + e.getValue()));
        List cm = (List)metrics.get((Object)"pulsar_storage_write_latency_le_1");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertNull((Object)((Metric)cm.get((int)0)).tags.get("topic"));
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"pulsar_producers_count");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertNull((Object)((Metric)cm.get((int)1)).tags.get("topic"));
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"pulsar_in_bytes_total");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"pulsar_in_messages_total");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"pulsar_out_bytes_total");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        cm = (List)metrics.get((Object)"pulsar_out_messages_total");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        p1.close();
        p2.close();
        c1.close();
        c2.close();
    }

    @Test
    public void testPerProducerStats() throws Exception {
        int i;
        org.apache.pulsar.client.api.Producer p1 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").producerName("producer1").create();
        org.apache.pulsar.client.api.Producer p2 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic2").producerName("producer2").create();
        Consumer c1 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic1"}).subscriptionName("Test").subscribe();
        Consumer c2 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic2"}).subscriptionName("Test").subscribe();
        int messages = 10;
        for (i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            p1.send((Object)message.getBytes());
            p2.send((Object)message.getBytes());
        }
        for (i = 0; i < 10; ++i) {
            c1.acknowledge(c1.receive());
            c2.acknowledge(c2.receive());
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)true, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        metrics.entries().forEach(e -> System.out.println((String)e.getKey() + ": " + e.getValue()));
        List cm = (List)metrics.get((Object)"pulsar_producer_msg_rate_in");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("producer_name"), (String)"producer2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("producer_id"), (String)"1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("producer_name"), (String)"producer1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("producer_id"), (String)"0");
        cm = (List)metrics.get((Object)"pulsar_producer_msg_throughput_in");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("producer_name"), (String)"producer2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("producer_id"), (String)"1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("producer_name"), (String)"producer1");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("producer_id"), (String)"0");
        p1.close();
        p2.close();
        c1.close();
        c2.close();
    }

    @Test
    public void testPerConsumerStats() throws Exception {
        int i;
        org.apache.pulsar.client.api.Producer p1 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        org.apache.pulsar.client.api.Producer p2 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic2").create();
        Consumer c1 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic1"}).subscriptionName("test").subscribe();
        Consumer c2 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic2"}).subscriptionName("test").subscribe();
        int messages = 10;
        for (i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            p1.send((Object)message.getBytes());
            p2.send((Object)message.getBytes());
        }
        for (i = 0; i < 10; ++i) {
            c1.acknowledge(c1.receive());
            c2.acknowledge(c2.receive());
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)true, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        metrics.entries().forEach(e -> System.out.println((String)e.getKey() + ": " + e.getValue()));
        List cm = (List)metrics.get((Object)"pulsar_out_bytes_total");
        Assert.assertEquals((int)cm.size(), (int)4);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("subscription"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("subscription"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("consumer_id"), (String)"1");
        Assert.assertEquals((String)((Metric)cm.get((int)2)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)2)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)2)).tags.get("subscription"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)3)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)3)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)3)).tags.get("subscription"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)3)).tags.get("consumer_id"), (String)"0");
        cm = (List)metrics.get((Object)"pulsar_out_messages_total");
        Assert.assertEquals((int)cm.size(), (int)4);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("subscription"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic2");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("subscription"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)1)).tags.get("consumer_id"), (String)"1");
        Assert.assertEquals((String)((Metric)cm.get((int)2)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)2)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)2)).tags.get("subscription"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)3)).tags.get("namespace"), (String)"my-property/use/my-ns");
        Assert.assertEquals((String)((Metric)cm.get((int)3)).tags.get("topic"), (String)"persistent://my-property/use/my-ns/my-topic1");
        Assert.assertEquals((String)((Metric)cm.get((int)3)).tags.get("subscription"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)3)).tags.get("consumer_id"), (String)"0");
        p1.close();
        p2.close();
        c1.close();
        c2.close();
    }

    @Test(invocationCount=2)
    public void testDuplicateMetricTypeDefinitions() throws Exception {
        org.apache.pulsar.client.api.Producer p1 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        org.apache.pulsar.client.api.Producer p2 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic2").create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            p1.send((Object)message.getBytes());
            p2.send((Object)message.getBytes());
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)false, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        HashMap typeDefs = new HashMap();
        HashMap metricNames = new HashMap();
        Pattern typePattern = Pattern.compile("^#\\s+TYPE\\s+(\\w+)\\s+(\\w+)");
        Pattern metricNamePattern = Pattern.compile("^(\\w+)\\{.+");
        Splitter.on((String)"\n").split((CharSequence)metricsStr).forEach(line -> {
            if (line.isEmpty()) {
                return;
            }
            if (line.startsWith("#")) {
                Matcher typeMatcher = typePattern.matcher((CharSequence)line);
                Preconditions.checkArgument((boolean)typeMatcher.matches());
                String metricName = typeMatcher.group(1);
                String type = typeMatcher.group(2);
                if (!typeDefs.containsKey(metricName)) {
                    typeDefs.put(metricName, type);
                } else {
                    Assert.fail((String)("Duplicate type definition found for TYPE definition " + metricName));
                    System.out.println(metricsStr);
                }
                if (metricNames.containsKey(metricName)) {
                    System.out.println(metricsStr);
                    Assert.fail((String)("TYPE definition for " + metricName + " appears after first sample"));
                }
            } else {
                Matcher metricMatcher = metricNamePattern.matcher((CharSequence)line);
                Preconditions.checkArgument((boolean)metricMatcher.matches());
                String metricName = metricMatcher.group(1);
                metricNames.put(metricName, metricName);
            }
        });
        for (String metricName : metricNames.keySet()) {
            String summaryMetricName;
            if (typeDefs.containsKey(metricName)) continue;
            if (metricName.endsWith("_sum")) {
                summaryMetricName = metricName.substring(0, metricName.indexOf("_sum"));
                if (typeDefs.containsKey(summaryMetricName)) continue;
                Assert.fail((String)("Metric " + metricName + " does not have a corresponding summary type definition"));
                continue;
            }
            if (metricName.endsWith("_count")) {
                summaryMetricName = metricName.substring(0, metricName.indexOf("_count"));
                if (typeDefs.containsKey(summaryMetricName)) continue;
                Assert.fail((String)("Metric " + metricName + " does not have a corresponding summary type definition"));
                continue;
            }
            if (metricName.endsWith("_bucket")) {
                summaryMetricName = metricName.substring(0, metricName.indexOf("_bucket"));
                if (typeDefs.containsKey(summaryMetricName)) continue;
                Assert.fail((String)("Metric " + metricName + " does not have a corresponding summary type definition"));
                continue;
            }
            Assert.fail((String)("Metric " + metricName + " does not have a type definition"));
        }
        p1.close();
        p2.close();
    }

    @Test
    public void testManagedLedgerCacheStats() throws Exception {
        org.apache.pulsar.client.api.Producer p1 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        org.apache.pulsar.client.api.Producer p2 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic2").create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            p1.send((Object)message.getBytes());
            p2.send((Object)message.getBytes());
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)false, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        metrics.entries().forEach(e -> System.out.println((String)e.getKey() + ": " + e.getValue()));
        List cm = (List)metrics.get((Object)"pulsar_ml_cache_evictions");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
        cm = (List)metrics.get((Object)"pulsar_ml_cache_hits_rate");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
        p1.close();
        p2.close();
    }

    @Test
    public void testManagedLedgerStats() throws Exception {
        org.apache.pulsar.client.api.Producer p1 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        org.apache.pulsar.client.api.Producer p2 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic2").create();
        org.apache.pulsar.client.api.Producer p3 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns2/my-topic1").create();
        org.apache.pulsar.client.api.Producer p4 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns2/my-topic2").create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            p1.send((Object)message.getBytes());
            p2.send((Object)message.getBytes());
            p3.send((Object)message.getBytes());
            p4.send((Object)message.getBytes());
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)false, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        metrics.entries().forEach(e -> System.out.println((String)e.getKey() + ": " + e.getValue()));
        HashMap typeDefs = new HashMap();
        HashMap metricNames = new HashMap();
        Pattern typePattern = Pattern.compile("^#\\s+TYPE\\s+(\\w+)\\s+(\\w+)");
        Pattern metricNamePattern = Pattern.compile("^(\\w+)\\{.+");
        Splitter.on((String)"\n").split((CharSequence)metricsStr).forEach(line -> {
            if (line.isEmpty()) {
                return;
            }
            if (line.startsWith("#")) {
                Matcher typeMatcher = typePattern.matcher((CharSequence)line);
                Preconditions.checkArgument((boolean)typeMatcher.matches());
                String metricName = typeMatcher.group(1);
                String type = typeMatcher.group(2);
                if (!typeDefs.containsKey(metricName)) {
                    typeDefs.put(metricName, type);
                } else {
                    Assert.fail((String)("Duplicate type definition found for TYPE definition " + metricName));
                }
                if (metricNames.containsKey(metricName)) {
                    Assert.fail((String)("TYPE definition for " + metricName + " appears after first sample"));
                }
            } else {
                Matcher metricMatcher = metricNamePattern.matcher((CharSequence)line);
                Preconditions.checkArgument((boolean)metricMatcher.matches());
                String metricName = metricMatcher.group(1);
                metricNames.put(metricName, metricName);
            }
        });
        List cm = (List)metrics.get((Object)"pulsar_ml_AddEntryBytesRate");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
        String ns = ((Metric)cm.get((int)0)).tags.get("namespace");
        Assert.assertTrue((ns.equals("my-property/use/my-ns") || ns.equals("my-property/use/my-ns2") ? 1 : 0) != 0);
        cm = (List)metrics.get((Object)"pulsar_ml_AddEntryMessagesRate");
        Assert.assertEquals((int)cm.size(), (int)2);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
        ns = ((Metric)cm.get((int)0)).tags.get("namespace");
        Assert.assertTrue((ns.equals("my-property/use/my-ns") || ns.equals("my-property/use/my-ns2") ? 1 : 0) != 0);
        p1.close();
        p2.close();
        p3.close();
        p4.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagedLedgerBookieClientStats() throws Exception {
        org.apache.pulsar.client.api.Producer p1 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        try {
            org.apache.pulsar.client.api.Producer p2 = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic2").create();
            try {
                for (int i = 0; i < 10; ++i) {
                    String message = "my-message-" + i;
                    p1.send((Object)message.getBytes());
                    p2.send((Object)message.getBytes());
                }
                ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
                PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)false, (boolean)false, (boolean)false, (OutputStream)statsOut);
                String metricsStr = statsOut.toString();
                Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
                metrics.entries().forEach(e -> System.out.println((String)e.getKey() + ": " + e.getValue()));
                List cm = (List)metrics.get((Object)"pulsar_managedLedger_client_bookkeeper_ml_scheduler_completed_tasks_0");
                Assert.assertEquals((int)cm.size(), (int)1);
                Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
                cm = (List)metrics.get((Object)"pulsar_managedLedger_client_bookkeeper_ml_scheduler_queue_0");
                Assert.assertEquals((int)cm.size(), (int)1);
                Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
                cm = (List)metrics.get((Object)"pulsar_managedLedger_client_bookkeeper_ml_scheduler_total_tasks_0");
                Assert.assertEquals((int)cm.size(), (int)1);
                Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
                cm = (List)metrics.get((Object)"pulsar_managedLedger_client_bookkeeper_ml_workers_completed_tasks_0");
                Assert.assertEquals((int)cm.size(), (int)0);
                cm = (List)metrics.get((Object)"pulsar_managedLedger_client_bookkeeper_ml_workers_task_execution_count");
                Assert.assertEquals((int)cm.size(), (int)0);
            }
            finally {
                if (Collections.singletonList(p2).get(0) != null) {
                    p2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(p1).get(0) != null) {
                p1.close();
            }
        }
    }

    @Test
    public void testAuthMetrics() throws IOException, AuthenticationException {
        SecretKey secretKey = AuthTokenUtils.createSecretKey((SignatureAlgorithm)SignatureAlgorithm.HS256);
        AuthenticationProviderToken provider = new AuthenticationProviderToken();
        Properties properties = new Properties();
        properties.setProperty("tokenSecretKey", AuthTokenUtils.encodeKeyBase64((Key)secretKey));
        ServiceConfiguration conf = new ServiceConfiguration();
        conf.setProperties(properties);
        provider.initialize(conf);
        String authExceptionMessage = "";
        try {
            provider.authenticate(new AuthenticationDataSource(){});
            Assert.fail((String)"Should have failed");
        }
        catch (AuthenticationException e) {
            authExceptionMessage = e.getMessage();
        }
        final String token = AuthTokenUtils.createToken((Key)secretKey, (String)"subject", Optional.empty());
        String subject = provider.authenticate(new AuthenticationDataSource(){

            public boolean hasDataFromCommand() {
                return true;
            }

            public String getCommandData() {
                return token;
            }
        });
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)false, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        List cm = (List)metrics.get((Object)"pulsar_authentication_success_count");
        boolean haveSucceed = false;
        for (Metric metric : cm) {
            if (!Objects.equals(metric.tags.get("auth_method"), "token") || !Objects.equals(metric.tags.get("provider_name"), provider.getClass().getSimpleName())) continue;
            haveSucceed = true;
        }
        Assert.assertTrue((boolean)haveSucceed);
        cm = (List)metrics.get((Object)"pulsar_authentication_failures_count");
        boolean haveFailed = false;
        for (Metric metric : cm) {
            if (!Objects.equals(metric.tags.get("auth_method"), "token") || !Objects.equals(metric.tags.get("reason"), authExceptionMessage) || !Objects.equals(metric.tags.get("provider_name"), provider.getClass().getSimpleName())) continue;
            haveFailed = true;
        }
        Assert.assertTrue((boolean)haveFailed);
    }

    @Test
    public void testExpiredTokenMetrics() throws Exception {
        SecretKey secretKey = AuthTokenUtils.createSecretKey((SignatureAlgorithm)SignatureAlgorithm.HS256);
        AuthenticationProviderToken provider = new AuthenticationProviderToken();
        Properties properties = new Properties();
        properties.setProperty("tokenSecretKey", AuthTokenUtils.encodeKeyBase64((Key)secretKey));
        ServiceConfiguration conf = new ServiceConfiguration();
        conf.setProperties(properties);
        provider.initialize(conf);
        Date expiredDate = new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L));
        final String expiredToken = AuthTokenUtils.createToken((Key)secretKey, (String)"subject", Optional.of(expiredDate));
        try {
            provider.authenticate(new AuthenticationDataSource(){

                public boolean hasDataFromCommand() {
                    return true;
                }

                public String getCommandData() {
                    return expiredToken;
                }
            });
            Assert.fail((String)"Should have failed");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)false, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        List cm = (List)metrics.get((Object)"pulsar_expired_token_count");
        Assert.assertEquals((int)cm.size(), (int)1);
        provider.close();
    }

    @Test
    public void testExpiringTokenMetrics() throws Exception {
        int[] tokenRemainTime;
        SecretKey secretKey = AuthTokenUtils.createSecretKey((SignatureAlgorithm)SignatureAlgorithm.HS256);
        AuthenticationProviderToken provider = new AuthenticationProviderToken();
        Properties properties = new Properties();
        properties.setProperty("tokenSecretKey", AuthTokenUtils.encodeKeyBase64((Key)secretKey));
        ServiceConfiguration conf = new ServiceConfiguration();
        conf.setProperties(properties);
        provider.initialize(conf);
        for (int remainTime : tokenRemainTime = new int[]{3, 7, 40, 100, 400}) {
            Date expiredDate = new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(remainTime));
            final String expiringToken = AuthTokenUtils.createToken((Key)secretKey, (String)"subject", Optional.of(expiredDate));
            provider.authenticate(new AuthenticationDataSource(){

                public boolean hasDataFromCommand() {
                    return true;
                }

                public String getCommandData() {
                    return expiringToken;
                }
            });
        }
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)false, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        Metric countMetric = (Metric)((List)metrics.get((Object)"pulsar_expiring_token_minutes_count")).get(0);
        Assert.assertEquals((double)countMetric.value, (double)tokenRemainTime.length);
        List cm = (List)metrics.get((Object)"pulsar_expiring_token_minutes_bucket");
        Assert.assertEquals((int)cm.size(), (int)5);
        cm.forEach(e -> {
            switch (e.tags.get("le")) {
                case "5.0": {
                    Assert.assertEquals((double)e.value, (double)1.0);
                    break;
                }
                case "10.0": {
                    Assert.assertEquals((double)e.value, (double)2.0);
                    break;
                }
                case "60.0": {
                    Assert.assertEquals((double)e.value, (double)3.0);
                    break;
                }
                case "240.0": {
                    Assert.assertEquals((double)e.value, (double)4.0);
                    break;
                }
                default: {
                    Assert.assertEquals((double)e.value, (double)5.0);
                }
            }
        });
        provider.close();
    }

    @Test
    public void testParsingWithPositiveInfinityValue() {
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics("pulsar_broker_publish_latency{cluster=\"test\",quantile=\"0.0\"} +Inf");
        List cm = (List)metrics.get((Object)"pulsar_broker_publish_latency");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("quantile"), (String)"0.0");
        Assert.assertEquals((double)((Metric)cm.get((int)0)).value, (double)Double.POSITIVE_INFINITY);
    }

    @Test
    public void testParsingWithNegativeInfinityValue() {
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics("pulsar_broker_publish_latency{cluster=\"test\",quantile=\"0.0\"} -Inf");
        List cm = (List)metrics.get((Object)"pulsar_broker_publish_latency");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("quantile"), (String)"0.0");
        Assert.assertEquals((double)((Metric)cm.get((int)0)).value, (double)Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testManagedCursorPersistStats() throws Exception {
        String subName = "my-sub";
        String topicName = "persistent://my-namespace/use/my-ns/my-topic1";
        int messageSize = 10;
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-namespace/use/my-ns/my-topic1"}).subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).subscriptionName("my-sub").subscribe();
        org.apache.pulsar.client.api.Producer producer = this.pulsarClient.newProducer().topic("persistent://my-namespace/use/my-ns/my-topic1").create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
            consumer.acknowledge(consumer.receive().getMessageId());
        }
        this.pulsar.getConfiguration().setExposeManagedCursorMetricsInPrometheus(true);
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        List cm = (List)metrics.get((Object)"pulsar_ml_cursor_persistLedgerSucceed");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cluster"), (String)"test");
        Assert.assertEquals((String)((Metric)cm.get((int)0)).tags.get("cursor_name"), (String)"my-sub");
        this.pulsar.getConfiguration().setExposeManagedCursorMetricsInPrometheus(false);
        ByteArrayOutputStream statsOut2 = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)false, (OutputStream)statsOut2);
        String metricsStr2 = statsOut2.toString();
        Multimap<String, Metric> metrics2 = PrometheusMetricsTest.parseMetrics(metricsStr2);
        List cm2 = (List)metrics2.get((Object)"pulsar_ml_cursor_persistLedgerSucceed");
        Assert.assertEquals((int)cm2.size(), (int)0);
        producer.close();
        consumer.close();
    }

    @Test
    public void testBrokerConnection() throws Exception {
        String topicName = "persistent://my-namespace/use/my-ns/my-topic1";
        org.apache.pulsar.client.api.Producer producer = this.pulsarClient.newProducer().topic("persistent://my-namespace/use/my-ns/my-topic1").create();
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        List cm = (List)metrics.get((Object)"pulsar_connection_created_total_count");
        this.compareBrokerConnectionStateCount(cm, 1.0);
        cm = (List)metrics.get((Object)"pulsar_connection_create_success_count");
        this.compareBrokerConnectionStateCount(cm, 1.0);
        cm = (List)metrics.get((Object)"pulsar_connection_closed_total_count");
        this.compareBrokerConnectionStateCount(cm, 0.0);
        cm = (List)metrics.get((Object)"pulsar_active_connections");
        this.compareBrokerConnectionStateCount(cm, 1.0);
        this.pulsarClient.close();
        statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)false, (OutputStream)statsOut);
        metricsStr = statsOut.toString();
        metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        cm = (List)metrics.get((Object)"pulsar_connection_closed_total_count");
        this.compareBrokerConnectionStateCount(cm, 1.0);
        this.pulsar.getConfiguration().setAuthenticationEnabled(true);
        this.replacePulsarClient(PulsarClient.builder().serviceUrl(this.lookupUrl.toString()).operationTimeout(1, TimeUnit.MILLISECONDS));
        try {
            this.pulsarClient.newProducer().topic("persistent://my-namespace/use/my-ns/my-topic1").create();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PulsarClientException.AuthenticationException));
        }
        this.pulsarClient.close();
        statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)false, (OutputStream)statsOut);
        metricsStr = statsOut.toString();
        metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        cm = (List)metrics.get((Object)"pulsar_connection_closed_total_count");
        this.compareBrokerConnectionStateCount(cm, 2.0);
        cm = (List)metrics.get((Object)"pulsar_connection_create_fail_count");
        this.compareBrokerConnectionStateCount(cm, 1.0);
        cm = (List)metrics.get((Object)"pulsar_connection_create_success_count");
        this.compareBrokerConnectionStateCount(cm, 1.0);
        cm = (List)metrics.get((Object)"pulsar_active_connections");
        this.compareBrokerConnectionStateCount(cm, 0.0);
        cm = (List)metrics.get((Object)"pulsar_connection_created_total_count");
        this.compareBrokerConnectionStateCount(cm, 2.0);
    }

    private void compareBrokerConnectionStateCount(List<Metric> cm, double count) {
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)cm.get((int)0).tags.get("cluster"), (String)"test");
        Assert.assertEquals((String)cm.get((int)0).tags.get("broker"), (String)"localhost");
        Assert.assertEquals((double)cm.get((int)0).value, (double)count);
    }

    @Test
    void testParseMetrics() throws IOException {
        String sampleMetrics = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("prometheus_metrics_sample.txt"), (Charset)StandardCharsets.UTF_8);
        PrometheusMetricsTest.parseMetrics(sampleMetrics);
    }

    @Test
    public void testCompaction() throws Exception {
        String topicName = "persistent://my-namespace/use/my-ns/my-compaction1";
        org.apache.pulsar.client.api.Producer producer = this.pulsarClient.newProducer().topic("persistent://my-namespace/use/my-ns/my-compaction1").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)false, (OutputStream)statsOut);
        String metricsStr = statsOut.toString();
        Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        List cm = (List)metrics.get((Object)"pulsar_compaction_removed_event_count");
        Assert.assertEquals((int)cm.size(), (int)0);
        cm = (List)metrics.get((Object)"pulsar_compaction_succeed_count");
        Assert.assertEquals((int)cm.size(), (int)0);
        cm = (List)metrics.get((Object)"pulsar_compaction_failed_count");
        Assert.assertEquals((int)cm.size(), (int)0);
        cm = (List)metrics.get((Object)"pulsar_compaction_duration_time_in_mills");
        Assert.assertEquals((int)cm.size(), (int)0);
        cm = (List)metrics.get((Object)"pulsar_compaction_read_throughput");
        Assert.assertEquals((int)cm.size(), (int)0);
        cm = (List)metrics.get((Object)"pulsar_compaction_write_throughput");
        Assert.assertEquals((int)cm.size(), (int)0);
        cm = (List)metrics.get((Object)"pulsar_compaction_compacted_entries_count");
        Assert.assertEquals((int)cm.size(), (int)0);
        cm = (List)metrics.get((Object)"pulsar_compaction_compacted_entries_size");
        Assert.assertEquals((int)cm.size(), (int)0);
        int numMessages = 1000;
        int maxKeys = 10;
        Random r = new Random(0L);
        for (int j = 0; j < 1000; ++j) {
            int keyIndex = r.nextInt(10);
            String key = "key" + keyIndex;
            byte[] data = ("my-message-" + key + "-" + j).getBytes();
            producer.newMessage().key(key).value((Object)data).send();
        }
        ScheduledExecutorService compactionScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("compactor").setDaemon(true).build());
        Compactor compactor = this.pulsar.getCompactor(true);
        compactor.compact("persistent://my-namespace/use/my-ns/my-compaction1").get();
        statsOut = new ByteArrayOutputStream();
        PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)false, (OutputStream)statsOut);
        metricsStr = statsOut.toString();
        metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
        cm = (List)metrics.get((Object)"pulsar_compaction_removed_event_count");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((double)((Metric)cm.get((int)0)).value, (double)990.0);
        cm = (List)metrics.get((Object)"pulsar_compaction_succeed_count");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((double)((Metric)cm.get((int)0)).value, (double)1.0);
        cm = (List)metrics.get((Object)"pulsar_compaction_failed_count");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((double)((Metric)cm.get((int)0)).value, (double)0.0);
        cm = (List)metrics.get((Object)"pulsar_compaction_duration_time_in_mills");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertTrue((((Metric)cm.get((int)0)).value > 0.0 ? 1 : 0) != 0);
        cm = (List)metrics.get((Object)"pulsar_compaction_read_throughput");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertTrue((((Metric)cm.get((int)0)).value > 0.0 ? 1 : 0) != 0);
        cm = (List)metrics.get((Object)"pulsar_compaction_write_throughput");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertTrue((((Metric)cm.get((int)0)).value > 0.0 ? 1 : 0) != 0);
        cm = (List)metrics.get((Object)"pulsar_compaction_compacted_entries_count");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((double)((Metric)cm.get((int)0)).value, (double)10.0);
        cm = (List)metrics.get((Object)"pulsar_compaction_compacted_entries_size");
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((double)((Metric)cm.get((int)0)).value, (double)870.0);
        this.pulsarClient.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitTopicAndPartitionLabel() throws Exception {
        int i;
        String ns1 = "prop/ns-abc1";
        String ns2 = "prop/ns-abc2";
        this.admin.namespaces().createNamespace(ns1);
        this.admin.namespaces().createNamespace(ns2);
        String baseTopic1 = "persistent://" + ns1 + "/testMetricsTopicCount";
        String baseTopic2 = "persistent://" + ns2 + "/testMetricsTopicCount";
        for (i = 0; i < 6; ++i) {
            this.admin.topics().createNonPartitionedTopic(baseTopic1 + UUID.randomUUID());
        }
        for (i = 0; i < 3; ++i) {
            this.admin.topics().createPartitionedTopic(baseTopic2 + UUID.randomUUID(), 3);
        }
        Consumer consumer1 = this.pulsarClient.newConsumer().topicsPattern("persistent://" + ns1 + "/.*").subscriptionName("sub").subscribe();
        Consumer consumer2 = this.pulsarClient.newConsumer().topicsPattern("persistent://" + ns2 + "/.*").subscriptionName("sub").subscribe();
        ByteArrayOutputStream statsOut = new ByteArrayOutputStream();
        try {
            PrometheusMetricsGenerator.generate((PulsarService)this.pulsar, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (OutputStream)statsOut);
            String metricsStr = statsOut.toString();
            Multimap<String, Metric> metrics = PrometheusMetricsTest.parseMetrics(metricsStr);
            Collection metric = metrics.get((Object)"pulsar_consumers_count");
            Assert.assertTrue((metric.size() >= 15 ? 1 : 0) != 0);
            metric.forEach(item -> {
                if (ns1.equals(item.tags.get("namespace"))) {
                    Assert.assertEquals((String)item.tags.get("partition"), (String)"-1");
                }
                if (ns2.equals(item.tags.get("namespace"))) {
                    System.out.println(item);
                    Assert.assertTrue((Integer.parseInt(item.tags.get("partition")) >= 0 ? 1 : 0) != 0);
                }
            });
            consumer1.close();
            consumer2.close();
        }
        finally {
            if (Collections.singletonList(statsOut).get(0) != null) {
                statsOut.close();
            }
        }
    }

    private void compareCompactionStateCount(List<Metric> cm, double count) {
        Assert.assertEquals((int)cm.size(), (int)1);
        Assert.assertEquals((String)cm.get((int)0).tags.get("cluster"), (String)"test");
        Assert.assertEquals((String)cm.get((int)0).tags.get("broker"), (String)"localhost");
        Assert.assertEquals((double)cm.get((int)0).value, (double)count);
    }

    public static Multimap<String, Metric> parseMetrics(String metrics) {
        ArrayListMultimap parsed = ArrayListMultimap.create();
        Pattern pattern = Pattern.compile("^(\\w+)\\{([^\\}]+)\\}\\s([+-]?[\\d\\w\\.-]+)(\\s(\\d+))?$");
        Pattern tagsPattern = Pattern.compile("(\\w+)=\"([^\"]+)\"(,\\s?)?");
        Splitter.on((String)"\n").split((CharSequence)metrics).forEach(arg_0 -> PrometheusMetricsTest.lambda$parseMetrics$15(pattern, tagsPattern, (Multimap)parsed, arg_0));
        return parsed;
    }

    private static /* synthetic */ void lambda$parseMetrics$15(Pattern pattern, Pattern tagsPattern, Multimap parsed, String line) {
        if (line.isEmpty() || line.startsWith("#")) {
            return;
        }
        Matcher matcher = pattern.matcher(line);
        Assert.assertTrue((boolean)matcher.matches(), (String)("line " + line + " does not match pattern " + pattern));
        String name = matcher.group(1);
        Metric m = new Metric();
        String numericValue = matcher.group(3);
        m.value = numericValue.equalsIgnoreCase("-Inf") ? Double.NEGATIVE_INFINITY : (numericValue.equalsIgnoreCase("+Inf") ? Double.POSITIVE_INFINITY : Double.parseDouble(numericValue));
        String tags = matcher.group(2);
        Matcher tagsMatcher = tagsPattern.matcher(tags);
        while (tagsMatcher.find()) {
            String tag = tagsMatcher.group(1);
            String value = tagsMatcher.group(2);
            m.tags.put(tag, value);
        }
        parsed.put((Object)name, (Object)m);
    }

    static class Metric {
        Map<String, String> tags = new TreeMap<String, String>();
        double value;

        Metric() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tags", this.tags).add("value", this.value).toString();
        }
    }
}

