/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.systopic.NamespaceEventsSystemTopicFactory;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.TopicPoliciesSystemTopicClient;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.util.FutureUtil;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class PartitionedSystemTopicTest
extends BrokerTestBase {
    static final int PARTITIONS = 5;

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.resetConfig();
        this.conf.setAllowAutoTopicCreation(false);
        this.conf.setAllowAutoTopicCreationType("partitioned");
        this.conf.setDefaultNumPartitions(5);
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTopicLevelPoliciesEnabled(true);
        super.baseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testAutoCreatedPartitionedSystemTopic() throws Exception {
        String ns = "prop/ns-test";
        this.admin.namespaces().createNamespace("prop/ns-test", 2);
        NamespaceEventsSystemTopicFactory systemTopicFactory = new NamespaceEventsSystemTopicFactory(this.pulsarClient);
        TopicPoliciesSystemTopicClient systemTopicClientForNamespace = systemTopicFactory.createTopicPoliciesSystemTopicClient(NamespaceName.get((String)"prop/ns-test"));
        SystemTopicClient.Reader reader = systemTopicClientForNamespace.newReader();
        int partitions = this.admin.topics().getPartitionedTopicMetadata((String)String.format((String)"persistent://%s/%s", (Object[])new Object[]{"prop/ns-test", "__change_events"})).partitions;
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicList("prop/ns-test").size(), (int)1);
        Assert.assertEquals((int)partitions, (int)5);
        Assert.assertEquals((int)this.admin.topics().getList("prop/ns-test").size(), (int)5);
    }

    @Test(timeOut=60000L)
    public void testConsumerCreationWhenEnablingTopicPolicy() throws Exception {
        String topic;
        String tenant = "tenant-" + RandomStringUtils.randomAlphabetic((int)4).toLowerCase();
        this.admin.tenants().createTenant(tenant, (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        int namespaceCount = 30;
        for (int i = 0; i < namespaceCount; ++i) {
            String ns = tenant + "/ns-" + i;
            this.admin.namespaces().createNamespace(ns, 4);
            topic = ns + "/t1";
            this.admin.topics().createPartitionedTopic(topic, 2);
        }
        ArrayList<CompletableFuture> futureList = new ArrayList<CompletableFuture>();
        for (int i = 0; i < namespaceCount; ++i) {
            topic = tenant + "/ns-" + i + "/t1";
            futureList.add(this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub").subscribeAsync());
        }
        FutureUtil.waitForAll(futureList).get();
    }
}

