/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.broker.transaction.pendingack.impl.MLPendingAckStore;
import org.apache.pulsar.broker.transaction.pendingack.impl.MLPendingAckStoreProvider;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionTest
extends TransactionTestBase {
    private static final Logger log = LoggerFactory.getLogger(TransactionTest.class);
    private static final String TENANT = "tnx";
    private static final String NAMESPACE1 = "tnx/ns1";
    private static final int NUM_BROKERS = 1;
    private static final int NUM_PARTITIONS = 1;

    @BeforeMethod
    protected void setup() throws Exception {
        this.setBrokerCount(1);
        this.internalSetup();
        String[] brokerServiceUrlArr = this.getPulsarServiceList().get(0).getBrokerServiceUrl().split(":");
        String webServicePort = brokerServiceUrlArr[brokerServiceUrlArr.length - 1];
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl("http://localhost:" + webServicePort).build());
        this.admin.tenants().createTenant(TENANT, (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NAMESPACE1);
        this.admin.tenants().createTenant(NamespaceName.SYSTEM_NAMESPACE.getTenant(), (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NamespaceName.SYSTEM_NAMESPACE.toString());
        this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), 1);
        this.pulsarClient.close();
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsarServiceList().get(0).getBrokerServiceUrl()).statsInterval(0L, TimeUnit.SECONDS).enableTransaction(true).build();
        this.waitForCoordinatorToBeAvailable(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void brokerNotInitTxnManagedLedgerTopic() throws Exception {
        String subName = "test";
        String topicName = TopicName.get((String)"tnx/ns1/test").toString();
        Consumer<byte[]> consumer = this.getConsumer(topicName, subName);
        try {
            consumer.close();
            Awaitility.await().until(() -> {
                try {
                    this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            });
            this.admin.namespaces().unload(NamespaceName.SYSTEM_NAMESPACE.toString());
            this.admin.namespaces().unload(NAMESPACE1);
            Consumer<byte[]> consumer1 = this.getConsumer(topicName, subName);
            try {
                Awaitility.await().until(() -> {
                    try {
                        this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                });
                ConcurrentOpenHashMap topics = this.getPulsarServiceList().get(0).getBrokerService().getTopics();
                Assert.assertNull((Object)topics.get((Object)(TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)NamespaceName.SYSTEM_NAMESPACE, (String)"__transaction_log_").toString() + 0)));
                Assert.assertNull((Object)topics.get((Object)TopicName.TRANSACTION_COORDINATOR_ASSIGN.getPartition(0).toString()));
                Assert.assertNull((Object)topics.get((Object)MLPendingAckStore.getTransactionPendingAckStoreSuffix((String)topicName, (String)subName)));
            }
            finally {
                if (Collections.singletonList(consumer1).get(0) != null) {
                    consumer1.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    public Consumer<byte[]> getConsumer(String topicName, String subName) throws PulsarClientException {
        return this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subName).subscriptionType(SubscriptionType.Shared).enableBatchIndexAcknowledgment(true).subscribe();
    }

    @Test
    public void testGetTxnID() throws Exception {
        Transaction transaction = (Transaction)this.pulsarClient.newTransaction().build().get();
        TxnID txnID = transaction.getTxnID();
        Assert.assertEquals((long)txnID.getLeastSigBits(), (long)0L);
        Assert.assertEquals((long)txnID.getMostSigBits(), (long)0L);
        transaction.abort();
        transaction = (Transaction)this.pulsarClient.newTransaction().build().get();
        txnID = transaction.getTxnID();
        Assert.assertEquals((long)txnID.getLeastSigBits(), (long)1L);
        Assert.assertEquals((long)txnID.getMostSigBits(), (long)0L);
    }

    @Test
    public void testSubscriptionRecreateTopic() throws PulsarAdminException, NoSuchFieldException, IllegalAccessException, PulsarClientException {
        String topic = "persistent://pulsar/system/testReCreateTopic";
        String subName = "sub_testReCreateTopic";
        int retentionSizeInMbSetTo = 5;
        int retentionSizeInMbSetTopic = 6;
        int retentionSizeInMinutesSetTo = 5;
        int retentionSizeInMinutesSetTopic = 6;
        this.admin.topics().createNonPartitionedTopic(topic);
        PulsarService pulsarService = super.getPulsarServiceList().get(0);
        pulsarService.getBrokerService().getTopics().clear();
        ManagedLedgerFactory managedLedgerFactory = pulsarService.getBrokerService().getManagedLedgerFactory();
        Field field = ManagedLedgerFactoryImpl.class.getDeclaredField("ledgers");
        field.setAccessible(true);
        ConcurrentHashMap ledgers = (ConcurrentHashMap)field.get(managedLedgerFactory);
        ledgers.remove(TopicName.get((String)topic).getPersistenceNamingEncoding());
        try {
            this.admin.topics().createNonPartitionedTopic(topic);
            Assert.fail();
        }
        catch (PulsarAdminException.ConflictException e) {
            log.info("Cann`t create topic again");
        }
        this.admin.topics().setRetention(topic, new RetentionPolicies(retentionSizeInMinutesSetTopic, retentionSizeInMbSetTopic));
        this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName(subName).subscribe();
        pulsarService.getBrokerService().getTopicIfExists(topic).thenAccept(option -> {
            if (!option.isPresent()) {
                log.error("Failed o get Topic named: {}", (Object)topic);
                Assert.fail();
            }
            PersistentTopic originPersistentTopic = (PersistentTopic)option.get();
            String pendingAckTopicName = MLPendingAckStore.getTransactionPendingAckStoreSuffix((String)originPersistentTopic.getName(), (String)subName);
            try {
                this.admin.topics().setRetention(pendingAckTopicName, new RetentionPolicies(retentionSizeInMinutesSetTo, retentionSizeInMbSetTo));
            }
            catch (PulsarAdminException e) {
                log.error("Failed to get./setRetention of topic with Exception:" + (Object)((Object)e));
                Assert.fail();
            }
            PersistentSubscription subscription = originPersistentTopic.getSubscription(subName);
            subscription.getPendingAckManageLedger().thenAccept(managedLedger -> {
                long retentionSize = managedLedger.getConfig().getRetentionSizeInMB();
                if (!originPersistentTopic.getTopicPolicies().isPresent()) {
                    log.error("Failed to getTopicPolicies of :" + originPersistentTopic);
                    Assert.fail();
                }
                TopicPolicies topicPolicies = (TopicPolicies)originPersistentTopic.getTopicPolicies().get();
                Assert.assertEquals((long)retentionSizeInMbSetTopic, (long)retentionSize);
                MLPendingAckStoreProvider mlPendingAckStoreProvider = new MLPendingAckStoreProvider();
                CompletableFuture future = mlPendingAckStoreProvider.newPendingAckStore(subscription);
                future.thenAccept(pendingAckStore -> ((MLPendingAckStore)pendingAckStore).getManagedLedger().thenAccept(managedLedger1 -> Assert.assertEquals((long)managedLedger1.getConfig().getRetentionSizeInMB(), (long)retentionSizeInMbSetTo)));
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTransactionSystemTopic() throws Exception {
        String subName = "test";
        String topicName = TopicName.get((String)"tnx/ns1/testCreateTransactionSystemTopic").toString();
        try {
            Consumer<byte[]> consumer = this.getConsumer(topicName, subName);
            try {
                Transaction transaction = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(10L, TimeUnit.SECONDS).build().get();
                consumer.acknowledgeAsync((MessageId)new MessageIdImpl(10L, 10L, 10), transaction).get();
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof PulsarClientException.TransactionConflictException));
        }
        topicName = MLPendingAckStore.getTransactionPendingAckStoreSuffix((String)topicName, (String)subName);
        List list = this.admin.topics().getList(NAMESPACE1);
        Assert.assertEquals((int)list.size(), (int)3);
        list.forEach(topic -> Assert.assertFalse((boolean)topic.contains("__transaction_pending_ack")));
        try {
            Consumer<byte[]> consumer = this.getConsumer(topicName, subName);
            try {
                FileAssert.fail();
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        catch (PulsarClientException.NotAllowedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Can not create transaction system topic"));
        }
        try {
            this.admin.topics().getSubscriptions(topicName);
            FileAssert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((String)e.getMessage(), (String)("Can not create transaction system topic " + topicName));
        }
        try {
            this.admin.topics().createPartitionedTopic(topicName, 3);
            FileAssert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Cannot create topic in system topic format!");
        }
        try {
            this.admin.topics().createNonPartitionedTopic(topicName);
            FileAssert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Cannot create topic in system topic format!");
        }
    }
}

