/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.transaction.buffer.TransactionBuffer;
import org.apache.pulsar.broker.transaction.buffer.TransactionBufferProvider;
import org.apache.pulsar.broker.transaction.buffer.TransactionBufferReader;
import org.apache.pulsar.broker.transaction.buffer.TransactionEntry;
import org.apache.pulsar.broker.transaction.buffer.TransactionMeta;
import org.apache.pulsar.broker.transaction.buffer.exceptions.TransactionNotFoundException;
import org.apache.pulsar.broker.transaction.buffer.exceptions.TransactionNotSealedException;
import org.apache.pulsar.broker.transaction.buffer.exceptions.TransactionStatusException;
import org.apache.pulsar.broker.transaction.buffer.impl.InMemTransactionBufferProvider;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.transaction.coordinator.proto.TxnStatus;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionBufferTest {
    private final TxnID txnId = new TxnID(1234L, 2345L);
    private final String providerClassName;
    private final TransactionBufferProvider provider;
    private TransactionBuffer buffer;

    @DataProvider(name="providers")
    public static Object[][] providers() {
        return new Object[][]{{InMemTransactionBufferProvider.class.getName()}};
    }

    @Factory(dataProvider="providers")
    public TransactionBufferTest(String providerClassName) throws Exception {
        this.providerClassName = providerClassName;
        this.provider = TransactionBufferProvider.newProvider((String)providerClassName);
    }

    @BeforeMethod
    public void setup() throws Exception {
        PersistentTopic persistentTopic = (PersistentTopic)Mockito.mock(PersistentTopic.class);
        this.buffer = this.provider.newTransactionBuffer((Topic)persistentTopic, new CompletableFuture());
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        this.buffer.closeAsync();
    }

    @Test
    public void testOpenReaderOnNonExistentTxn() throws Exception {
        try {
            this.buffer.openTransactionBufferReader(this.txnId, 0L).get();
            Assert.fail((String)"Should fail to open reader if a transaction doesn't exist");
        }
        catch (ExecutionException ee) {
            Assert.assertTrue((boolean)(ee.getCause() instanceof TransactionNotFoundException));
        }
    }

    @Test
    public void testOpenReaderOnAnOpenTxn() throws Exception {
        int numEntries = 10;
        this.appendEntries(this.txnId, 10, 0L);
        TransactionMeta txnMeta = (TransactionMeta)this.buffer.getTransactionMeta(this.txnId).get();
        Assert.assertEquals((Object)this.txnId, (Object)txnMeta.id());
        Assert.assertEquals((Object)TxnStatus.OPEN, (Object)txnMeta.status());
        try {
            this.buffer.openTransactionBufferReader(this.txnId, 0L).get();
            Assert.fail((String)"Should fail to open a reader on an OPEN transaction");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TransactionNotSealedException));
        }
    }

    @Test(enabled=false)
    public void testOpenReaderOnCommittedTxn() throws Exception {
        int numEntries = 10;
        this.appendEntries(this.txnId, 10, 0L);
        TransactionMeta txnMeta = (TransactionMeta)this.buffer.getTransactionMeta(this.txnId).get();
        Assert.assertEquals((Object)this.txnId, (Object)txnMeta.id());
        Assert.assertEquals((Object)TxnStatus.OPEN, (Object)txnMeta.status());
        this.buffer.commitTxn(this.txnId, Long.MIN_VALUE);
        txnMeta = (TransactionMeta)this.buffer.getTransactionMeta(this.txnId).get();
        Assert.assertEquals((Object)this.txnId, (Object)txnMeta.id());
        Assert.assertEquals((Object)TxnStatus.COMMITTED, (Object)txnMeta.status());
        try (TransactionBufferReader reader = (TransactionBufferReader)this.buffer.openTransactionBufferReader(this.txnId, 0L).get();){
            List txnEntries = (List)reader.readNext(10).get();
            this.verifyAndReleaseEntries(txnEntries, this.txnId, 0L, 10);
        }
    }

    @Test
    public void testCommitNonExistentTxn() throws Exception {
        try {
            this.buffer.commitTxn(this.txnId, Long.MIN_VALUE).get();
            Assert.fail((String)"Should fail to commit a transaction if it doesn't exist");
        }
        catch (ExecutionException ee) {
            Assert.assertTrue((boolean)(ee.getCause() instanceof TransactionNotFoundException));
        }
    }

    @Test
    public void testCommitTxn() throws Exception {
        int numEntries = 10;
        this.appendEntries(this.txnId, 10, 0L);
        TransactionMeta txnMeta = (TransactionMeta)this.buffer.getTransactionMeta(this.txnId).get();
        Assert.assertEquals((Object)this.txnId, (Object)txnMeta.id());
        Assert.assertEquals((Object)TxnStatus.OPEN, (Object)txnMeta.status());
        this.buffer.commitTxn(this.txnId, Long.MIN_VALUE);
        txnMeta = (TransactionMeta)this.buffer.getTransactionMeta(this.txnId).get();
        Assert.assertEquals((Object)this.txnId, (Object)txnMeta.id());
        Assert.assertEquals((Object)TxnStatus.COMMITTED, (Object)txnMeta.status());
    }

    @Test
    public void testAbortNonExistentTxn() throws Exception {
        try {
            this.buffer.abortTxn(this.txnId, Long.MIN_VALUE).get();
            Assert.fail((String)"Should fail to abort a transaction if it doesn't exist");
        }
        catch (ExecutionException ee) {
            Assert.assertTrue((boolean)(ee.getCause() instanceof TransactionNotFoundException));
        }
    }

    @Test
    public void testAbortCommittedTxn() throws Exception {
        int numEntries = 10;
        this.appendEntries(this.txnId, 10, 0L);
        TransactionMeta txnMeta = (TransactionMeta)this.buffer.getTransactionMeta(this.txnId).get();
        Assert.assertEquals((Object)this.txnId, (Object)txnMeta.id());
        Assert.assertEquals((Object)TxnStatus.OPEN, (Object)txnMeta.status());
        this.buffer.commitTxn(this.txnId, Long.MIN_VALUE);
        txnMeta = (TransactionMeta)this.buffer.getTransactionMeta(this.txnId).get();
        Assert.assertEquals((Object)this.txnId, (Object)txnMeta.id());
        Assert.assertEquals((Object)TxnStatus.COMMITTED, (Object)txnMeta.status());
        try {
            this.buffer.abortTxn(this.txnId, Long.MIN_VALUE).get();
            Assert.fail((String)"Should fail to abort a committed transaction");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TransactionStatusException));
        }
        txnMeta = (TransactionMeta)this.buffer.getTransactionMeta(this.txnId).get();
        Assert.assertEquals((Object)this.txnId, (Object)txnMeta.id());
        Assert.assertEquals((Object)TxnStatus.COMMITTED, (Object)txnMeta.status());
    }

    @Test
    public void testAbortTxn() throws Exception {
        int numEntries = 10;
        this.appendEntries(this.txnId, 10, 0L);
        TransactionMeta txnMeta = (TransactionMeta)this.buffer.getTransactionMeta(this.txnId).get();
        Assert.assertEquals((Object)this.txnId, (Object)txnMeta.id());
        Assert.assertEquals((Object)TxnStatus.OPEN, (Object)txnMeta.status());
        this.buffer.abortTxn(this.txnId, Long.MIN_VALUE).get();
        this.verifyTxnNotExist(this.txnId);
    }

    @Test(enabled=false)
    public void testPurgeTxns() throws Exception {
        int numEntries = 10;
        TxnID txnId1 = new TxnID(1234L, 3456L);
        this.appendEntries(txnId1, 10, 0L);
        TransactionMeta txnMeta = (TransactionMeta)this.buffer.getTransactionMeta(txnId1).get();
        Assert.assertEquals((Object)txnId1, (Object)txnMeta.id());
        Assert.assertEquals((Object)TxnStatus.OPEN, (Object)txnMeta.status());
        TxnID txnId2 = new TxnID(1234L, 4567L);
        this.appendEntries(txnId2, 10, 0L);
        this.buffer.commitTxn(txnId2, Long.MIN_VALUE);
        TransactionMeta txnMeta2 = (TransactionMeta)this.buffer.getTransactionMeta(txnId2).get();
        Assert.assertEquals((Object)txnId2, (Object)txnMeta2.id());
        Assert.assertEquals((Object)TxnStatus.COMMITTED, (Object)txnMeta2.status());
        TxnID txnId3 = new TxnID(1234L, 5678L);
        this.appendEntries(txnId3, 10, 0L);
        this.buffer.commitTxn(txnId3, Long.MIN_VALUE);
        TransactionMeta txnMeta3 = (TransactionMeta)this.buffer.getTransactionMeta(txnId3).get();
        Assert.assertEquals((Object)txnId3, (Object)txnMeta3.id());
        Assert.assertEquals((Object)TxnStatus.COMMITTED, (Object)txnMeta3.status());
        this.buffer.purgeTxns((List)Lists.newArrayList((Object[])new Long[]{0L})).get();
        this.verifyTxnNotExist(txnId2);
        txnMeta = (TransactionMeta)this.buffer.getTransactionMeta(txnId1).get();
        Assert.assertEquals((Object)txnId1, (Object)txnMeta.id());
        Assert.assertEquals((Object)TxnStatus.OPEN, (Object)txnMeta.status());
        txnMeta3 = (TransactionMeta)this.buffer.getTransactionMeta(txnId3).get();
        Assert.assertEquals((Object)txnId3, (Object)txnMeta3.id());
        Assert.assertEquals((Object)TxnStatus.COMMITTED, (Object)txnMeta3.status());
    }

    private void appendEntries(TxnID txnId, int numEntries, long startSequenceId) {
        for (int i = 0; i < numEntries; ++i) {
            long sequenceId = startSequenceId + (long)i;
            this.buffer.appendBufferToTxn(txnId, sequenceId, Unpooled.copiedBuffer((CharSequence)("message-" + sequenceId), (Charset)StandardCharsets.UTF_8)).join();
        }
    }

    private void verifyAndReleaseEntries(List<TransactionEntry> txnEntries, TxnID txnID, long startSequenceId, int numEntriesToRead) {
        Assert.assertEquals((int)txnEntries.size(), (int)numEntriesToRead);
        for (int i = 0; i < numEntriesToRead; ++i) {
            try (TransactionEntry txnEntry = txnEntries.get(i);){
                Assert.assertEquals((long)txnEntry.committedAtLedgerId(), (long)22L);
                Assert.assertEquals((long)txnEntry.committedAtEntryId(), (long)33L);
                Assert.assertEquals((Object)txnEntry.txnId(), (Object)txnID);
                Assert.assertEquals((long)txnEntry.sequenceId(), (long)(startSequenceId + (long)i));
                Assert.assertEquals((String)new String(ByteBufUtil.getBytes((ByteBuf)txnEntry.getEntry().getDataBuffer()), StandardCharsets.UTF_8), (String)("message-" + i));
                continue;
            }
        }
    }

    private void verifyTxnNotExist(TxnID txnID) throws Exception {
        try {
            this.buffer.getTransactionMeta(txnID).get();
            Assert.fail((String)"Should fail to get transaction metadata if it doesn't exist");
        }
        catch (ExecutionException ee) {
            Assert.assertTrue((boolean)(ee.getCause() instanceof TransactionNotFoundException));
        }
    }
}

