/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.coordinator;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.TransactionMetadataStoreService;
import org.apache.pulsar.broker.transaction.buffer.impl.TransactionBufferClientImpl;
import org.apache.pulsar.broker.transaction.coordinator.TransactionMetaStoreTestBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.TransactionBufferClient;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClient;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionCoordinatorClientTest
extends TransactionMetaStoreTestBase {
    @Override
    protected void afterSetup() throws Exception {
        for (PulsarService pulsarService : this.pulsarServices) {
            TransactionBufferClient tbClient = (TransactionBufferClient)Mockito.mock(TransactionBufferClientImpl.class);
            Mockito.when((Object)tbClient.commitTxnOnTopic(ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(CompletableFuture.completedFuture(null));
            Mockito.when((Object)tbClient.abortTxnOnTopic(ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(CompletableFuture.completedFuture(null));
            Mockito.when((Object)tbClient.commitTxnOnSubscription(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(CompletableFuture.completedFuture(null));
            Mockito.when((Object)tbClient.abortTxnOnSubscription(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(CompletableFuture.completedFuture(null));
            TransactionMetadataStoreService metadataStoreService = pulsarService.getTransactionMetadataStoreService();
            Class<TransactionMetadataStoreService> clazz = TransactionMetadataStoreService.class;
            Field field = clazz.getDeclaredField("tbClient");
            field.setAccessible(true);
            field.set(metadataStoreService, tbClient);
        }
    }

    @Test
    public void testClientStart() throws PulsarClientException, TransactionCoordinatorClientException, InterruptedException {
        try {
            this.transactionCoordinatorClient.start();
            Assert.fail((String)"should failed here because the transaction metas store already started!");
        }
        catch (TransactionCoordinatorClientException transactionCoordinatorClientException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)this.transactionCoordinatorClient);
        Assert.assertEquals((Object)this.transactionCoordinatorClient.getState(), (Object)TransactionCoordinatorClient.State.READY);
    }

    @Test
    public void testNewTxn() throws TransactionCoordinatorClientException {
        TxnID txnID = this.transactionCoordinatorClient.newTransaction();
        Assert.assertNotNull((Object)txnID);
        Assert.assertEquals((long)txnID.getLeastSigBits(), (long)0L);
    }

    @Test
    public void testCommitAndAbort() throws TransactionCoordinatorClientException {
        TxnID txnID = this.transactionCoordinatorClient.newTransaction();
        this.transactionCoordinatorClient.addPublishPartitionToTxn(txnID, (List)Lists.newArrayList((Object[])new String[]{"persistent://public/default/testCommitAndAbort"}));
        this.transactionCoordinatorClient.commit(txnID);
        try {
            this.transactionCoordinatorClient.abort(txnID);
            Assert.fail((String)"Should be fail, because the txn is in committing state, can't abort now.");
        }
        catch (TransactionCoordinatorClientException transactionCoordinatorClientException) {
            // empty catch block
        }
    }
}

