/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import io.netty.util.HashedWheelTimer;
import java.util.Collections;
import java.util.UUID;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class ConsumerCleanupTest
extends ProducerConsumerBase {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @DataProvider(name="ackReceiptEnabled")
    public Object[][] ackReceiptEnabled() {
        return new Object[][]{{true}, {false}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="ackReceiptEnabled")
    public void testAllTimerTaskShouldCanceledAfterConsumerClosed(boolean ackReceiptEnabled) throws PulsarClientException, InterruptedException {
        PulsarClient pulsarClient = this.newPulsarClient(this.lookupUrl.toString(), 1);
        try {
            Consumer consumer = pulsarClient.newConsumer().topic(new String[]{"persistent://public/default/" + UUID.randomUUID().toString()}).subscriptionName("test").isAckReceiptEnabled(ackReceiptEnabled).subscribe();
            consumer.close();
            Thread.sleep(2000L);
            HashedWheelTimer timer = (HashedWheelTimer)((PulsarClientImpl)pulsarClient).timer();
            Assert.assertEquals((long)timer.pendingTimeouts(), (long)0L);
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }
}

