/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import io.netty.util.HashedWheelTimer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class ProducerCleanupTest
extends ProducerConsumerBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testAllTimerTaskShouldCanceledAfterProducerClosed() throws PulsarClientException, InterruptedException {
        Producer producer = this.pulsarClient.newProducer().topic("persistent://public/default/" + UUID.randomUUID().toString()).sendTimeout(1, TimeUnit.SECONDS).create();
        producer.close();
        Thread.sleep(2000L);
        HashedWheelTimer timer = (HashedWheelTimer)((PulsarClientImpl)this.pulsarClient).timer();
        Assert.assertEquals((long)timer.pendingTimeouts(), (long)0L);
    }
}

