/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.net.InetAddress;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.TlsProducerConsumerBase;
import org.apache.pulsar.client.impl.auth.AuthenticationTls;
import org.testng.annotations.Test;

@Test(groups={"broker-api"})
public class TlsSniTest
extends TlsProducerConsumerBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIpAddressInBrokerServiceUrl() throws Exception {
        String topicName = "persistent://my-property/use/my-ns/my-topic1";
        URI brokerServiceUrlTls = new URI(this.pulsar.getBrokerServiceUrlTls());
        String brokerServiceIpAddressUrl = String.format("pulsar+ssl://%s:%d", InetAddress.getByName(brokerServiceUrlTls.getHost()).getHostAddress(), brokerServiceUrlTls.getPort());
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(brokerServiceIpAddressUrl).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").allowTlsInsecureConnection(false).enableTlsHostnameVerification(false).operationTimeout(1000, TimeUnit.MILLISECONDS);
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("tlsCertFile", "./src/test/resources/authentication/tls/client-cert.pem");
        authParams.put("tlsKeyFile", "./src/test/resources/authentication/tls/client-key.pem");
        clientBuilder.authentication(AuthenticationTls.class.getName(), authParams);
        PulsarClient pulsarClient = clientBuilder.build();
        try {
            pulsarClient.newProducer().topic(topicName).create();
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }
}

