/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Collections;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MockBrokerService;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class ConsumerUnsubscribeTest {
    MockBrokerService mockBrokerService;

    @BeforeClass(alwaysRun=true)
    public void setup() {
        this.mockBrokerService = new MockBrokerService();
        this.mockBrokerService.start();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        if (this.mockBrokerService != null) {
            this.mockBrokerService.stop();
            this.mockBrokerService = null;
        }
    }

    @Test
    public void testConsumerUnsubscribeReference() throws Exception {
        PulsarClientImpl client = (PulsarClientImpl)PulsarClient.builder().serviceUrl(this.mockBrokerService.getBrokerAddress()).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{"persistent://public/default/t1"}).subscriptionName("sub1").subscribe();
            consumer.unsubscribe();
            Assert.assertEquals((int)client.consumersCount(), (int)0);
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }
}

