/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.api.raw.MessageParser;
import org.apache.pulsar.common.api.raw.RawMessage;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MessageParserTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeClass
    public void setup() throws Exception {
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        this.admin.tenants().createTenant("my-tenant", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("my-tenant/my-ns", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    @Override
    @AfterClass
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @DataProvider(name="batchingAndCompression")
    public static Object[][] batchingAndCompression() {
        return new Object[][]{{true, CompressionType.ZLIB}, {true, CompressionType.ZSTD}, {true, CompressionType.SNAPPY}, {true, CompressionType.LZ4}, {true, CompressionType.NONE}, {false, CompressionType.ZLIB}, {false, CompressionType.ZSTD}, {false, CompressionType.SNAPPY}, {false, CompressionType.LZ4}, {false, CompressionType.NONE}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="batchingAndCompression")
    public void testParseMessages(boolean batchEnabled, CompressionType compressionType) throws Exception {
        block16: {
            String topic = "persistent://my-tenant/my-ns/message-parse-test-" + batchEnabled + "-" + compressionType;
            TopicName topicName = TopicName.get((String)topic);
            int n = 10;
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).compressionType(compressionType).enableBatching(batchEnabled).batchingMaxPublishDelay(10L, TimeUnit.SECONDS).topic(topic).create();
            try {
                int i;
                ManagedCursor cursor = ((PersistentTopic)this.pulsar.getBrokerService().getTopicReference(topic).get()).getManagedLedger().newNonDurableCursor((Position)PositionImpl.earliest);
                if (batchEnabled) {
                    for (i = 0; i < 9; ++i) {
                        producer.sendAsync((Object)("hello-" + i));
                    }
                    producer.send((Object)"hello-9");
                } else {
                    for (i = 0; i < 10; ++i) {
                        producer.send((Object)("Pulsar-" + i));
                    }
                }
                if (batchEnabled) {
                    Entry entry = (Entry)cursor.readEntriesOrWait(1).get(0);
                    ArrayList messages = Lists.newArrayList();
                    ByteBuf headsAndPayload = entry.getDataBuffer();
                    try {
                        MessageParser.parseMessage((TopicName)topicName, (long)entry.getLedgerId(), (long)entry.getEntryId(), (ByteBuf)headsAndPayload, messages::add, (int)0x500000);
                    }
                    finally {
                        entry.release();
                    }
                    Assert.assertEquals((int)messages.size(), (int)10);
                    for (int i2 = 0; i2 < 10; ++i2) {
                        Assert.assertEquals((Object)((RawMessage)messages.get(i2)).getData(), (Object)Unpooled.wrappedBuffer((byte[])("hello-" + i2).getBytes()));
                    }
                    messages.forEach(msg -> {
                        msg.getSchemaVersion();
                        msg.release();
                    });
                    Awaitility.await().atMost(3L, TimeUnit.SECONDS).untilAsserted(() -> Assert.assertEquals((int)headsAndPayload.refCnt(), (int)0));
                    break block16;
                }
                Assert.assertEquals((long)cursor.getNumberOfEntriesInBacklog(false), (long)10L);
                List entries = cursor.readEntriesOrWait(10);
                Assert.assertEquals((int)entries.size(), (int)10);
                ArrayList headsAndPayloadList = Lists.newArrayList();
                ArrayList messages = Lists.newArrayList();
                for (Entry entry : entries) {
                    ByteBuf headsAndPayload = entry.getDataBuffer();
                    headsAndPayloadList.add(headsAndPayload);
                    MessageParser.parseMessage((TopicName)topicName, (long)entry.getLedgerId(), (long)entry.getEntryId(), (ByteBuf)entry.getDataBuffer(), messages::add, (int)0x500000);
                    entry.release();
                }
                Assert.assertEquals((int)messages.size(), (int)10);
                messages.forEach(msg -> {
                    msg.getSchemaVersion();
                    msg.release();
                });
                for (ByteBuf byteBuf : headsAndPayloadList) {
                    Awaitility.await().atMost(3L, TimeUnit.SECONDS).untilAsserted(() -> Assert.assertEquals((int)byteBuf.refCnt(), (int)0));
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
    }
}

