/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.compaction.TwoPhaseCompactor;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class CompactionRetentionTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(CompactionRetentionTest.class);
    private ScheduledExecutorService compactionScheduler;
    private BookKeeper bk;

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setManagedLedgerMinLedgerRolloverTimeMinutes(0);
        this.conf.setManagedLedgerMaxEntriesPerLedger(2);
        this.conf.setTopicLevelPoliciesEnabled(true);
        this.conf.setSystemTopicEnabled(true);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        this.admin.tenants().createTenant("my-tenant", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("my-tenant/my-ns", Collections.singleton("test"));
        this.compactionScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("compaction-%d").setDaemon(true).build());
        this.bk = this.pulsar.getBookKeeperClientFactory().create(this.conf, null, null, Optional.empty(), null);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
        if (this.compactionScheduler != null) {
            this.compactionScheduler.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompaction() throws Exception {
        String topic = "persistent://my-tenant/my-ns/my-topic-" + System.nanoTime();
        HashSet keys = Sets.newHashSet((Object[])new String[]{"a", "b", "c"});
        HashSet keysToExpire = Sets.newHashSet((Object[])new String[]{"x1", "x2"});
        HashSet<String> allKeys = new HashSet<String>();
        allKeys.addAll(keys);
        allKeys.addAll(keysToExpire);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        Producer producer = this.pulsarClient.newProducer(Schema.INT32).topic(topic).create();
        try {
            TwoPhaseCompactor compactor = new TwoPhaseCompactor(this.conf, this.pulsarClient, this.bk, this.compactionScheduler);
            compactor.compact(topic).join();
            log.info(" ---- X 1: {}", (Object)mapper.writeValueAsString((Object)this.admin.topics().getInternalStats(topic, false)));
            int round = 1;
            for (String key : allKeys) {
                producer.newMessage().key(key).value((Object)round).send();
            }
            log.info(" ---- X 2: {}", (Object)mapper.writeValueAsString((Object)this.admin.topics().getInternalStats(topic, false)));
            this.validateMessages(this.pulsarClient, true, topic, round, allKeys);
            compactor.compact(topic).join();
            log.info(" ---- X 3: {}", (Object)mapper.writeValueAsString((Object)this.admin.topics().getInternalStats(topic, false)));
            this.validateMessages(this.pulsarClient, true, topic, round, allKeys);
            round = 2;
            for (String key : allKeys) {
                producer.newMessage().key(key).value((Object)round).send();
            }
            compactor.compact(topic).join();
            this.validateMessages(this.pulsarClient, true, topic, round, allKeys);
            for (String key : keysToExpire) {
                producer.newMessage().key(key).send();
            }
            compactor.compact(topic).join();
            log.info(" ---- X 4: {}", (Object)mapper.writeValueAsString((Object)this.admin.topics().getInternalStats(topic, false)));
            this.validateMessages(this.pulsarClient, true, topic, round, keys);
            this.validateMessages(this.pulsarClient, false, topic, round, Collections.emptySet());
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    @Test
    public void testCompactionRetentionOnTopicCreationWithNamespacePolicies() throws Exception {
        String namespace = "my-tenant/my-ns";
        String topic = "persistent://my-tenant/my-ns/my-topic-" + System.nanoTime();
        this.admin.namespaces().setCompactionThreshold(namespace, 10L);
        this.testCompactionCursorRetention(topic);
    }

    @Test
    public void testCompactionRetentionAfterTopicCreationWithNamespacePolicies() throws Exception {
        String namespace = "my-tenant/my-ns";
        String topic = "persistent://my-tenant/my-ns/my-topic-" + System.nanoTime();
        this.pulsarClient.newProducer(Schema.INT32).topic(topic).create().close();
        this.admin.namespaces().setCompactionThreshold(namespace, 10L);
        Awaitility.await().untilAsserted(() -> this.testCompactionCursorRetention(topic));
    }

    @Test
    public void testCompactionRetentionOnTopicCreationWithTopicPolicies() throws Exception {
        String topic = "persistent://my-tenant/my-ns/my-topic-" + System.nanoTime();
        this.pulsarClient.newProducer(Schema.INT32).topic(topic).create().close();
        this.admin.topics().setCompactionThreshold(topic, 10L);
        Awaitility.await().untilAsserted(() -> this.testCompactionCursorRetention(topic));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCompactionCursorRetention(String topic) throws Exception {
        HashSet keys = Sets.newHashSet((Object[])new String[]{"a", "b", "c"});
        HashSet keysToExpire = Sets.newHashSet((Object[])new String[]{"x1", "x2"});
        HashSet<String> allKeys = new HashSet<String>();
        allKeys.addAll(keys);
        allKeys.addAll(keysToExpire);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        Producer producer = this.pulsarClient.newProducer(Schema.INT32).topic(topic).create();
        try {
            TwoPhaseCompactor compactor = new TwoPhaseCompactor(this.conf, this.pulsarClient, this.bk, this.compactionScheduler);
            log.info(" ---- X 1: {}", (Object)mapper.writeValueAsString((Object)this.admin.topics().getInternalStats(topic, false)));
            int round = 1;
            for (String key : allKeys) {
                producer.newMessage().key(key).value((Object)round).send();
            }
            log.info(" ---- X 2: {}", (Object)mapper.writeValueAsString((Object)this.admin.topics().getInternalStats(topic, false)));
            this.validateMessages(this.pulsarClient, true, topic, round, allKeys);
            compactor.compact(topic).join();
            log.info(" ---- X 3: {}", (Object)mapper.writeValueAsString((Object)this.admin.topics().getInternalStats(topic, false)));
            this.validateMessages(this.pulsarClient, true, topic, round, allKeys);
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateMessages(PulsarClient client, boolean readCompacted, String topic, int round, Set<String> expectedKeys) throws Exception {
        Reader reader = client.newReader(Schema.INT32).topic(topic).startMessageId(MessageId.earliest).readCompacted(readCompacted).create();
        try {
            Message msg;
            HashMap<String, Integer> receivedValues = new HashMap<String, Integer>();
            while ((msg = reader.readNext(1, TimeUnit.SECONDS)) != null) {
                Integer value = msg.size() > 0 ? (Integer)msg.getValue() : null;
                log.info("Received: {} -- value: {}", (Object)msg.getKey(), (Object)value);
                if (value == null) continue;
                receivedValues.put(msg.getKey(), value);
            }
            HashMap expectedReceivedValues = new HashMap();
            expectedKeys.forEach(k -> expectedReceivedValues.put(k, round));
            log.info("Received values: {}", receivedValues);
            log.info("Expected values: {}", expectedReceivedValues);
            Assert.assertEquals(receivedValues, expectedReceivedValues);
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }
}

