/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.compaction.CompactionRecord;
import org.apache.pulsar.compaction.CompactorMXBeanImpl;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker-compaction"})
public class CompactorMXBeanImplTest {
    @Test
    public void testSimple() throws Exception {
        CompactorMXBeanImpl mxBean = new CompactorMXBeanImpl();
        String topic = "topic1";
        mxBean.addCompactionStartOp(topic);
        CompactionRecord compaction = (CompactionRecord)mxBean.getCompactionRecordForTopic(topic).get();
        Assert.assertEquals((float)compaction.getLastCompactionRemovedEventCount(), (float)0.0f, (float)0.0f);
        mxBean.addCompactionRemovedEvent(topic);
        Assert.assertEquals((float)compaction.getLastCompactionRemovedEventCount(), (float)0.0f, (float)0.0f);
        mxBean.addCompactionEndOp(topic, true);
        Assert.assertEquals((float)compaction.getLastCompactionRemovedEventCount(), (float)1.0f, (float)0.0f);
        Assert.assertTrue((compaction.getLastCompactionSucceedTimestamp() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((compaction.getLastCompactionDurationTimeInMills() >= 0L ? 1 : 0) != 0);
        Assert.assertEquals((float)compaction.getLastCompactionFailedTimestamp(), (float)0.0f, (float)0.0f);
        Assert.assertEquals((float)compaction.getCompactionRemovedEventCount(), (float)1.0f, (float)0.0f);
        Assert.assertEquals((float)compaction.getCompactionSucceedCount(), (float)1.0f, (float)0.0f);
        Assert.assertEquals((float)compaction.getCompactionFailedCount(), (float)0.0f, (float)0.0f);
        Assert.assertTrue((compaction.getCompactionDurationTimeInMills() >= 0L ? 1 : 0) != 0);
        mxBean.addCompactionStartOp(topic);
        mxBean.addCompactionRemovedEvent(topic);
        mxBean.addCompactionEndOp(topic, false);
        Assert.assertEquals((float)compaction.getCompactionRemovedEventCount(), (float)2.0f, (float)0.0f);
        Assert.assertEquals((float)compaction.getCompactionFailedCount(), (float)1.0f, (float)0.0f);
        Assert.assertEquals((float)compaction.getCompactionSucceedCount(), (float)1.0f, (float)0.0f);
        Assert.assertTrue((compaction.getLastCompactionFailedTimestamp() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((compaction.getCompactionDurationTimeInMills() >= 0L ? 1 : 0) != 0);
        mxBean.addCompactionReadOp(topic, 22L);
        Assert.assertTrue((compaction.getCompactionReadThroughput() > 0.0 ? 1 : 0) != 0);
        mxBean.addCompactionWriteOp(topic, 33L);
        Assert.assertTrue((compaction.getCompactionWriteThroughput() > 0.0 ? 1 : 0) != 0);
        mxBean.addCompactionLatencyOp(topic, 10L, TimeUnit.NANOSECONDS);
        Assert.assertTrue((compaction.getCompactionLatencyBuckets()[0] > 0L ? 1 : 0) != 0);
        mxBean.reset();
        Assert.assertEquals((float)compaction.getCompactionRemovedEventCount(), (float)0.0f, (float)0.0f);
        Assert.assertEquals((float)compaction.getCompactionSucceedCount(), (float)0.0f, (float)0.0f);
        Assert.assertEquals((float)compaction.getCompactionFailedCount(), (float)0.0f, (float)0.0f);
        Assert.assertEquals((float)compaction.getCompactionDurationTimeInMills(), (float)0.0f, (float)0.0f);
    }
}

